/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.wizard;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.net.URL;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.Wizard;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.xml.addin.XMLSchemaBasedWizard;
import oracle.bali.xml.addin.wizard.SchemaBasedCustomizerPage;
import oracle.bali.xml.addin.wizard.SchemaBasedFileCreationPage;
import oracle.bali.xml.addin.wizard.SchemaBasedModel;
import oracle.bali.xml.addin.wizard.SchemaBasedXMLBuilder;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.model.TextNode;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.wizard.TitledWizardDialog;

public class XMLSchemaBasedCreationWizard
extends Wizard {
    private final Context _context;
    private SchemaBasedModel _model;
    private static final Image _IMAGE = ImageUtils.getImageResource(XMLSchemaBasedCreationWizard.class, (String)"images/wizard_image.gif");
    private SchemaBasedCustomizerPage _customizeDoc;

    public XMLSchemaBasedCreationWizard(Context context) {
        this._context = context;
    }

    public void launch() {
        try {
            this._model = new SchemaBasedModel();
            SchemaBasedFileCreationPage fileCreation = new SchemaBasedFileCreationPage(this._context, this._model);
            fileCreation.setHelpID("f1_createxmlfiledirname_html");
            this.addPage((WizardPage)fileCreation);
            this._customizeDoc = new SchemaBasedCustomizerPage(this._context, this._model);
            this._customizeDoc.setHelpID("f1_createxmlfileoptions_html");
            this.addPage((WizardPage)this._customizeDoc);
            TitledWizardDialog wizDlg = new TitledWizardDialog((BaseWizard)this, (Frame)Ide.getMainWindow());
            wizDlg.setWizardTitle(XMLSchemaBasedWizard.getResource("SCHEMAWIZ.TITLE"));
            wizDlg.runDialog();
            wizDlg.dispose();
            this.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void cancelWizard() {
        this.doCancel();
    }

    protected void doFinish() {
        super.doFinish();
        try {
            Project project = this._context.getProject();
            URL projectDir = this._model.getDirectoryURL();
            URLFileSystem.mkdirs((URL)projectDir);
            URL outUrl = URLFactory.newURL((URL)projectDir, (String)this._model.getFilename());
            SchemaBasedXMLBuilder builder = new SchemaBasedXMLBuilder(project, outUrl, this._model.getGrammar(), this._model.getGrammars(), this._model.getDocumentRoot(), this._model.getDepth(), this._model.getRequiredElements(), this._model.getUsePredefinedSchemas(), this._model.getEncoding());
            builder.build();
            TextNode node = (TextNode)NodeFactory.find((URL)outUrl);
            project.add((Element)node, true);
            CommandProcessor.getInstance().flush((Object)node);
            Context newContext = Context.newIdeContext((Node)node);
            EditorUtil.openExplicitEditorInFrame(CodeEditor.class, (Context)newContext);
            node.save();
        }
        catch (Exception x) {
            MessageDialog.error((Component)((Object)this), (Object)XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_CREATING_MESSAGE"), (String)XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_CREATING_TITLE"), null);
        }
    }

    public static final Image getWizardImage() {
        return _IMAGE;
    }

    protected void processWizardEvent(WizardEvent event) {
        super.processWizardEvent(event);
        if (event.getID() == 2001) {
            this.setMustFinish(event.getPage() != this._customizeDoc);
        }
    }
}

