/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardValidateListener;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.addin.SchemaRegistryAddin;
import oracle.bali.xml.addin.XMLSchemaBasedWizard;
import oracle.bali.xml.addin.schema.SchemaLoader;
import oracle.bali.xml.addin.wizard.BaseWizardPage;
import oracle.bali.xml.addin.wizard.SchemaBasedModel;
import oracle.bali.xml.addin.wizard.XMLSchemaBasedCreationWizard;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.grammar.schema.SchemaGrammarProvider;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.ide.Context;
import oracle.ide.dialogs.MessageDialog;
import oracle.ide.editor.EditorUtil;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.net.DefaultNameGenerator;
import oracle.ide.net.NameGenerator;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLTextField;

public class SchemaBasedFileCreationPage
extends BaseWizardPage
implements DocumentListener,
ChangeListener {
    private JTextField _name;
    private JTextField _schemaLoc;
    private JRadioButton _useBuiltInSchemas;
    private JRadioButton _dontUseBuiltInSchemas;
    private JButton _browseButton;
    private URLTextField _directoryUrl;
    private JLabel _schemaLabel;
    private URL _initDirectory;
    private Component _pageComponent;
    private JFileChooser _fileChooser;
    private static String _KEY_IGNORE = "SCHEMAWIZ.IGNORE_ERROR";
    private static String _KEY_EDIT_FILE = "SCHEMAWIZ.EDIT_FILE";
    private static String _KEY_ERROR_TITLE = "SCHEMAWIZ.ERROR_LOADING_TITLE";

    public SchemaBasedFileCreationPage(Context ctx, SchemaBasedModel model) {
        super(ctx, model);
        this.addWizardValidateListener(new FileCreationWizardValidator(this._pageComponent));
        this._updateCanAdvance();
    }

    public String getPageTitle() {
        return XMLSchemaBasedWizard.getResource("SCHEMAWIZ.FILE_TITLE");
    }

    @Override
    protected Component getPageComponent() {
        final Box topPane = Box.createVerticalBox();
        JPanel leftAlignLabelPane = new JPanel(new BorderLayout());
        JLabel l = new JLabel();
        String text = "<html>" + XMLSchemaBasedWizard.getResource("SCHEMAWIZ.FILE_CREATION_DESC") + "</html>";
        l.setText(text);
        topPane.add(leftAlignLabelPane);
        leftAlignLabelPane.add(l);
        topPane.add(Box.createVerticalStrut(5));
        Container masterPane = UIUtils.createLabelFieldContainer();
        JPanel leftAlignMasterPane = new JPanel(new BorderLayout());
        leftAlignMasterPane.add(masterPane);
        topPane.add(leftAlignMasterPane);
        text = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.XML_FILE");
        JLabel label = new JLabel(StringUtils.stripMnemonic((String)text));
        label.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._name = new JTextField();
        label.setLabelFor(this._name);
        URL initFilename = URLFactory.newUniqueURL((URL)this.getInitDirectory(), (NameGenerator)new DefaultNameGenerator("untitled", "xml"));
        String filename = initFilename.getFile();
        filename = filename.substring(filename.lastIndexOf("/") + 1);
        this._name.setText(filename);
        masterPane.add(label);
        masterPane.add(this._name);
        text = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.XML_DIRECTORY");
        JLabel dirLabel = new JLabel(StringUtils.stripMnemonic((String)text));
        dirLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._directoryUrl = new URLTextField(this.getInitDirectory());
        dirLabel.setLabelFor((Component)this._directoryUrl);
        text = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.BROWSE");
        JButton dirButton = new JButton(StringUtils.stripMnemonic((String)text));
        dirButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        dirButton.addActionListener((ActionListener)this._directoryUrl);
        masterPane.add(dirLabel);
        Box dirPanel = Box.createHorizontalBox();
        dirPanel.add((Component)this._directoryUrl);
        dirPanel.add(Box.createHorizontalStrut(12));
        dirPanel.add(dirButton);
        masterPane.add(dirPanel);
        topPane.add(Box.createVerticalStrut(15));
        leftAlignLabelPane = new JPanel(new BorderLayout());
        l = new JLabel();
        text = "<html>" + XMLSchemaBasedWizard.getResource("SCHEMAWIZ.SELECT_SCHEMA_DESC") + "</html>";
        l.setText(text);
        topPane.add(leftAlignLabelPane);
        leftAlignLabelPane.add(l);
        topPane.add(Box.createVerticalStrut(5));
        text = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.USE_PREREG");
        this._useBuiltInSchemas = new JRadioButton(StringUtils.stripMnemonic((String)text));
        this._useBuiltInSchemas.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        text = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.USE_FS");
        this._dontUseBuiltInSchemas = new JRadioButton(StringUtils.stripMnemonic((String)text));
        this._dontUseBuiltInSchemas.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._dontUseBuiltInSchemas.setSelected(true);
        ButtonGroup schemaChoice = new ButtonGroup();
        schemaChoice.add(this._dontUseBuiltInSchemas);
        schemaChoice.add(this._useBuiltInSchemas);
        JPanel usePanel = new JPanel(new BorderLayout());
        usePanel.add((Component)this._useBuiltInSchemas, "West");
        JPanel dontUsePanel = new JPanel(new BorderLayout());
        dontUsePanel.add((Component)this._dontUseBuiltInSchemas, "West");
        topPane.add(usePanel);
        topPane.add(Box.createVerticalStrut(5));
        topPane.add(dontUsePanel);
        text = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.SCHEMA_LOCATION");
        this._schemaLabel = new JLabel(StringUtils.stripMnemonic((String)text));
        this._schemaLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._schemaLoc = new JTextField();
        this._schemaLabel.setLabelFor(this._schemaLoc);
        text = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.BROWSE_2");
        this._browseButton = new JButton(StringUtils.stripMnemonic((String)text));
        this._browseButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int ret = SchemaBasedFileCreationPage.this.getFileChooser().showOpenDialog(topPane);
                if (ret == 0) {
                    SchemaBasedFileCreationPage.this._schemaLoc.setText(SchemaBasedFileCreationPage.this.getFileChooser().getSelectedFile().getPath());
                }
            }
        });
        topPane.add(Box.createVerticalStrut(5));
        Box schemaPanel = Box.createHorizontalBox();
        schemaPanel.add(Box.createHorizontalStrut(24));
        schemaPanel.add(this._schemaLabel);
        schemaPanel.add(Box.createHorizontalStrut(12));
        schemaPanel.add(this._schemaLoc);
        schemaPanel.add(Box.createHorizontalStrut(12));
        schemaPanel.add(this._browseButton);
        topPane.add(schemaPanel);
        this._name.getDocument().addDocumentListener(this);
        this._schemaLoc.getDocument().addDocumentListener(this);
        this._useBuiltInSchemas.addChangeListener(this);
        this._dontUseBuiltInSchemas.addChangeListener(this);
        this._directoryUrl.getDocument().addDocumentListener(this);
        topPane.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 1000), new Dimension(0, 1000)));
        this._pageComponent = topPane;
        return topPane;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this._useBuiltInSchemas) {
            this._schemaLoc.setEnabled(!this._useBuiltInSchemas.isSelected());
            this._schemaLabel.setEnabled(!this._useBuiltInSchemas.isSelected());
            this._browseButton.setEnabled(!this._useBuiltInSchemas.isSelected());
            this._updateCanAdvance();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this._updateCanAdvance();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this._updateCanAdvance();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this._updateCanAdvance();
    }

    private void _showUserError(String title, String msg) {
        MessageDialog.error((Component)this.getContent(), (Object)msg, (String)title, null);
    }

    private void _updateCanAdvance() {
        String name = this._name.getText();
        String schemaLoc = this._schemaLoc.getText();
        boolean useBuiltIn = this._useBuiltInSchemas.isSelected();
        boolean canAdvance = !"".equals(name) && (!"".equals(schemaLoc) || useBuiltIn) && this._directoryUrl.getURL() != null;
        this.setCanAdvance(canAdvance);
    }

    private GrammarProvider _loadGrammarProvider(URL u) throws Exception {
        if (u == null) {
            int lastDot;
            String fileExt = null;
            String filename = this._name.getText();
            if (filename != null && (lastDot = filename.lastIndexOf(46)) != -1) {
                fileExt = filename.substring(lastDot);
            }
            if (fileExt == null || "".equals(fileExt)) {
                fileExt = ".xml";
            }
            SchemaRegistryAddin.loadSchema(fileExt);
            return SchemaRegistryAddin.getGrammarProvider(fileExt);
        }
        SchemaGrammarProvider schemaProvider = new SchemaGrammarProvider();
        schemaProvider.addSchema(u);
        return schemaProvider;
    }

    private URL getInitDirectory() {
        if (this._initDirectory == null) {
            this._initDirectory = URLFactory.newDirURL((String)this.getContext().getProject().getBaseDirectory());
        }
        return this._initDirectory;
    }

    private JFileChooser getFileChooser() {
        if (this._fileChooser == null) {
            this._fileChooser = new JFileChooser(this.getInitDirectory().getFile());
            this._fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().endsWith(".xsd");
                }

                @Override
                public String getDescription() {
                    return XMLSchemaBasedWizard.getResource("SCHEMAWIZ.FILE_EXTENSION");
                }
            });
        }
        return this._fileChooser;
    }

    protected class FileCreationWizardValidator
    implements WizardValidateListener {
        Component _parentComponent;

        public FileCreationWizardValidator(Component parentComponent) {
            this._parentComponent = parentComponent;
        }

        public void wizardValidatePage(final WizardEvent event) {
            boolean showFileError = false;
            boolean fileAlreadyExists = false;
            URL dirURL = SchemaBasedFileCreationPage.this._directoryUrl.getURL();
            String filename = SchemaBasedFileCreationPage.this._name.getText();
            if (!URLFileSystem.canCreate((URL)dirURL)) {
                showFileError = true;
            } else if ("".equals(filename.trim())) {
                showFileError = true;
            } else {
                File f = new File(dirURL.getFile(), filename);
                if (f.exists()) {
                    fileAlreadyExists = true;
                }
            }
            if (showFileError) {
                SchemaBasedFileCreationPage.this._showUserError(XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_FILENAME"), XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_FILENAME_DESC"));
                ((Cancelable)event).cancel();
                return;
            }
            if (fileAlreadyExists) {
                SchemaBasedFileCreationPage.this._showUserError(XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_FILENAME"), XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_FILENAME_ALREADY_EXISTS") + ": " + SchemaBasedFileCreationPage.this._name.getText());
                ((Cancelable)event).cancel();
                return;
            }
            SchemaBasedModel model = (SchemaBasedModel)SchemaBasedFileCreationPage.this.getModel();
            model.setFilename(filename);
            model.setDirectoryURL(dirURL);
            model.setUsePredefinedSchemas(SchemaBasedFileCreationPage.this._useBuiltInSchemas.isSelected());
            String schemaLoc = SchemaBasedFileCreationPage.this._schemaLoc.getText();
            if (!SchemaBasedFileCreationPage.this._useBuiltInSchemas.isSelected() && !"".equals(schemaLoc)) {
                try {
                    String potentialFileName = SchemaBasedFileCreationPage.this._schemaLoc.getText();
                    URL u = potentialFileName.indexOf("://") == -1 ? URLFactory.newFileURL((String)potentialFileName) : new URL(potentialFileName);
                    if (!URLFileSystem.exists((URL)u)) {
                        SchemaBasedFileCreationPage.this._showUserError(XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA"), XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA_FILE_NO_EXIST"));
                        ((Cancelable)event).cancel();
                        return;
                    }
                    final boolean[] errorDetectedHolder = new boolean[]{true};
                    final URL localURL = u;
                    Runnable success = new Runnable(){

                        @Override
                        public void run() {
                            errorDetectedHolder[0] = false;
                        }
                    };
                    Runnable editFileRunnable = new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Node node = NodeFactory.findOrCreate((URL)localURL);
                                EditorUtil.openExplicitDefaultEditorInFrame((Node)node);
                                ((XMLSchemaBasedCreationWizard)SchemaBasedFileCreationPage.this.getParent()).cancelWizard();
                            }
                            catch (Exception iae) {
                                SchemaBasedFileCreationPage.this._showUserError(XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA"), iae.toString());
                            }
                            ((Cancelable)event).cancel();
                        }
                    };
                    Runnable ioError = new Runnable(){

                        @Override
                        public void run() {
                            SchemaBasedFileCreationPage.this._showUserError(XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA"), "");
                            ((Cancelable)event).cancel();
                        }
                    };
                    SchemaLoader.validateSchema(this._parentComponent, u, success, editFileRunnable, ioError, XMLSchemaBasedWizard.getResource(_KEY_IGNORE), XMLSchemaBasedWizard.getResource(_KEY_EDIT_FILE), XMLSchemaBasedWizard.getResource(_KEY_ERROR_TITLE), true);
                    if (errorDetectedHolder[0]) {
                        ((Cancelable)event).cancel();
                        return;
                    }
                    GrammarProvider grammarProvider = SchemaBasedFileCreationPage.this._loadGrammarProvider(u);
                    if (grammarProvider.getGrammars().isEmpty()) {
                        SchemaBasedFileCreationPage.this._showUserError(XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA"), XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA_INVALID"));
                        ((Cancelable)event).cancel();
                        return;
                    }
                    model.setGrammars(grammarProvider);
                }
                catch (MalformedURLException e) {
                    SchemaBasedFileCreationPage.this._showUserError(XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA_LOC"), XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA_FILENAME_INVALID"));
                    ((Cancelable)event).cancel();
                    return;
                }
                catch (Exception e) {
                    SchemaBasedFileCreationPage.this._showUserError(XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA"), XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA_INVALID"));
                    ((Cancelable)event).cancel();
                    return;
                }
            }
            try {
                GrammarProvider grammarProvider = SchemaBasedFileCreationPage.this._loadGrammarProvider(null);
                model.setGrammars(grammarProvider);
            }
            catch (Exception e) {
                e.printStackTrace();
                SchemaBasedFileCreationPage.this._showUserError(XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA"), XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ERROR_SCHEMA_BUILT_IN_INVALID"));
                ((Cancelable)event).cancel();
                return;
            }
        }
    }
}

