/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.schema;

import java.io.File;
import oracle.bali.xml.addin.schema.MapSchema;
import oracle.bali.xml.addin.schema.SchemaMap;
import oracle.bali.xml.addin.schema.SchemaOptions;
import oracle.ide.Ide;
import oracle.ide.config.ClientSetting;
import oracle.ide.config.IdeSettings;
import oracle.ide.config.IdeSettingsMigrator;
import oracle.ide.migration.MigrationManager;
import oracle.ide.migration.Migrator;
import oracle.javatools.util.Copyable;

public final class SchemaMigrator
implements Migrator {
    public static final int SCHEMA_SETTINGS = 0;
    private static final String _NOTSPECIFIED_EXT = ".notspecified";

    public int[] getMigrationCategories() {
        return new int[]{0};
    }

    public String getDescription(int category) {
        return null;
    }

    public boolean canMigrate(int category, File sourceDir) {
        return false;
    }

    public void setSelected(int category, boolean selected) {
    }

    public boolean isSelected(int category) {
        return false;
    }

    public String[] migrate(File sourceDir, File destDir) {
        MigrationManager mm = MigrationManager.getMigrationManager();
        Migrator settings = mm.getMigrator(IdeSettingsMigrator.class);
        if (settings != null && settings.isSelected(0)) {
            try {
                this._updateSettings();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return null;
    }

    private void _updateSettings() {
        IdeSettings settings = Ide.getSettings();
        SchemaOptions options = (SchemaOptions)settings.getData(SchemaOptions.KEY_SETTINGS);
        SchemaMap sm = options.getSchemas();
        for (MapSchema toCheck : sm.getSchemas()) {
            if (!toCheck.isUserDefined()) {
                sm.remove(toCheck.getURL(), toCheck.getExtension(), toCheck.isUserDefined());
                continue;
            }
            if (!_NOTSPECIFIED_EXT.equals(toCheck.getExtension())) continue;
            sm.remove(toCheck.getURL(), toCheck.getExtension(), toCheck.isUserDefined());
            sm.put(toCheck.getURL(), ".xml", toCheck.isUserDefined());
        }
        options.setSchemas(sm);
        ClientSetting.findOrCreate((String)"oracle.ide.xmlef").putData(SchemaOptions.KEY_SETTINGS, (Copyable)options);
    }
}

