/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.schema;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.addin.SchemaRegistryAddin;
import oracle.ide.Ide;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;

final class AddSchemaPanel
extends JPanel
implements ActionListener {
    private static final String _FILTER_KEY = "SCHEMAADDIN.SETTING_NAME";
    private static final String _KEY_ADD_TITLE = "SCHEMAADDIN.ADD_SCHEMA_TITLE";
    private static final String _KEY_ADD_LABEL = "SCHEMAADDIN.ADD_SCHEMA_LABEL";
    private static final String _KEY_ADD_EXT_LABEL = "SCHEMAADDIN.ADD_SCHEMA_EXTLABEL";
    private static final String _KEY_BROWSE = "SCHEMAADDIN.ADD_SCHEMA_BROWSE";
    private static final String _KEY_EDIT_TITLE = "SCHEMAADDIN.EDIT_SCHEMA_TITLE";
    private static final String _KEY_EDIT_LABEL = "SCHEMAADDIN.EDIT_SCHEMA_LABEL";
    private JTextField _fileField;
    private JTextField _extField;
    private String _fileText;
    private String _extText;
    private static URL _lastURL;
    private boolean _editing;
    private JLabel _addEditLabel;

    public AddSchemaPanel() {
        HelpUtils.setHelpID((JComponent)this, (String)"f1_prefaddschema_html");
        this._init();
    }

    public static String getTranslatedString(String key) {
        return SchemaRegistryAddin.getTranslatedString(key);
    }

    public boolean showAddDialog(Component invoker) {
        String title = this._editing ? AddSchemaPanel.getTranslatedString(_KEY_EDIT_TITLE) : AddSchemaPanel.getTranslatedString(_KEY_ADD_TITLE);
        JEWTDialog d = JEWTDialog.createDialog((Component)invoker, (String)title, (int)7);
        if (d == null) {
            return false;
        }
        d.setInitialFocus((Component)this._fileField);
        try {
            URL currentURL = new URL(this._fileText);
            if ("file".equals(currentURL.getProtocol())) {
                this._fileText = URLFileSystem.getPlatformPathName((URL)currentURL);
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        this._fileField.setText(this._fileText);
        this._extField.setText(this._extText);
        d.setContent((Component)this);
        boolean okPressed = d.runDialog();
        d.dispose();
        return okPressed;
    }

    public URL getURL() {
        this._fileText = this._fileField.getText();
        this._fileText = this._fileText.trim();
        return "".equals(this._fileText) ? null : URLFactory.newURL((String)this._fileText);
    }

    public String getExtension() {
        this._extText = this._extField.getText();
        return this._extText;
    }

    public void setURL(String fileText) {
        this._fileText = fileText;
        if (null != this._fileField) {
            this._fileField.setText(this._fileText);
        }
    }

    public void setExtention(String extensionText) {
        this._extText = extensionText;
        if (null != this._extField) {
            this._extField.setText(this._extText);
        }
    }

    public void setEditing(boolean editing) {
        this._editing = editing;
        this._setAddEditLabel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("BROWSE".equals(cmd)) {
            URL url = this._getDefaultFileUrl();
            URLChooser fileChooser = DialogUtil.newURLChooser((URL)url);
            fileChooser.setSelectionMode(0);
            String desc = AddSchemaPanel.getTranslatedString(_FILTER_KEY);
            String ext = ".xsd";
            DefaultURLFilter filter = new DefaultURLFilter(desc, ext);
            fileChooser.addChooseableURLFilter((URLFilter)filter);
            fileChooser.setURLFilter((URLFilter)filter);
            int result = fileChooser.showOpenDialog((Component)this);
            if (result == 0) {
                _lastURL = url = fileChooser.getSelectedURL();
                String text = null;
                if (url != null) {
                    text = url.toString();
                }
                this._fileField.setText(text);
            }
        }
    }

    private URL _getDefaultFileUrl() {
        URL fileURL = this.getURL();
        if (null != fileURL) {
            return fileURL;
        }
        if (_lastURL != null) {
            return _lastURL;
        }
        if (Ide.getActiveProject() != null) {
            return URLFactory.newDirURL((String)Ide.getActiveProject().getBaseDirectory());
        }
        return URLFactory.newDirURL((String)Ide.getUserSettingsDirectory());
    }

    private void _setAddEditLabel() {
        String labelString = this._editing ? AddSchemaPanel.getTranslatedString(_KEY_EDIT_LABEL) : AddSchemaPanel.getTranslatedString(_KEY_ADD_LABEL);
        this._addEditLabel.setText(StringUtils.stripMnemonic((String)labelString));
        this._addEditLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)labelString));
    }

    private void _init() {
        String browseString = AddSchemaPanel.getTranslatedString(_KEY_BROWSE);
        String extString = AddSchemaPanel.getTranslatedString(_KEY_ADD_EXT_LABEL);
        this._addEditLabel = new JLabel();
        this._setAddEditLabel();
        JTextField fileField = new JTextField();
        fileField.setColumns(50);
        this._addEditLabel.setLabelFor(fileField);
        JButton browseButton = new JButton(StringUtils.stripMnemonic((String)browseString));
        browseButton.setMnemonic(StringUtils.getMnemonicKeyCode((String)browseString));
        browseButton.setActionCommand("BROWSE");
        browseButton.addActionListener(this);
        JLabel extLabel = new JLabel(StringUtils.stripMnemonic((String)extString));
        extLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)extString));
        JTextField extField = new JTextField();
        extField.setColumns(5);
        extLabel.setLabelFor(extField);
        AddSchemaPanel panel = this;
        panel.setLayout(new BorderLayout(3, 3));
        JPanel url = new JPanel(new BorderLayout(3, 3));
        url.add("Center", this._addEditLabel);
        JPanel browsePanel = new JPanel(new FlowLayout(0, 5, 3));
        browsePanel.add(fileField);
        browsePanel.add(browseButton);
        JPanel topPanel = new JPanel(new BorderLayout(3, 3));
        topPanel.add("Center", url);
        topPanel.add("South", browsePanel);
        panel.add("North", topPanel);
        JPanel middlePanel = new JPanel(new BorderLayout(3, 3));
        middlePanel.add("West", extLabel);
        JPanel middleRightPanel = new JPanel(new BorderLayout(3, 3));
        middleRightPanel.add("West", extField);
        middlePanel.add("Center", middleRightPanel);
        panel.add("South", middlePanel);
        this._fileField = fileField;
        this._extField = extField;
    }
}

