/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownServiceException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import oracle.bali.xml.addin.XMLSourceNode;
import oracle.bali.xml.dom.buffer.util.EncodingUtils;
import oracle.ide.Addin;
import oracle.ide.model.Recognizer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.xml.StartElementPacket;
import oracle.ide.xml.XMLUtil;

final class XMLDefaultRecognizerAddin
implements Addin {
    private static final Logger _LOGGER = Logger.getLogger(XMLDefaultRecognizerAddin.class.getName());

    XMLDefaultRecognizerAddin() {
    }

    public void initialize() {
        Recognizer.setDefaultRecognizer((Recognizer)new Recognizer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Class recognize(URL url) {
                if (URLFileSystem.exists((URL)url)) {
                    InputStream inputStream = null;
                    try {
                        StartElementPacket packet;
                        char c;
                        inputStream = URLFileSystem.openInputStream((URL)url);
                        int requestedScanSize = 64;
                        byte[] scanArray = new byte[64];
                        int length = EncodingUtils.fillEncodingScanArray((InputStream)inputStream, (byte[])scanArray, (int)64);
                        String encodingClass = EncodingUtils.getEncodingClass((byte[])scanArray, (int)length);
                        String scanText = EncodingUtils.getScanText((byte[])scanArray, (int)length, (String)encodingClass);
                        if (scanText.length() >= 6 && scanText.startsWith("<?xml") && ((c = scanText.charAt(5)) == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f') && (packet = XMLUtil.getXMLRootElement((URL)url)) != null && packet.localName != null) {
                            Class<XMLSourceNode> clazz = XMLSourceNode.class;
                            return clazz;
                        }
                    }
                    catch (FileNotFoundException fnfe) {
                    }
                    catch (UnknownServiceException use) {
                    }
                    catch (IOException e) {
                        LogRecord lr = new LogRecord(Level.WARNING, "IOException trying to figure out if {0} is XML");
                        lr.setThrown(e);
                        lr.setParameters(new Object[]{url});
                        _LOGGER.log(lr);
                    }
                    finally {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                return null;
            }
        });
    }
}

