/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.util.ArrayList;
import java.util.List;
import oracle.javatools.parser.java.v2.JavaConstants;
import oracle.javatools.parser.java.v2.JavaProvider;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceBlockElement;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceClassBody;
import oracle.javatools.parser.java.v2.model.SourceClassInitializer;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFieldDeclaration;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceHasBlock;
import oracle.javatools.parser.java.v2.model.SourceLocalVariable;
import oracle.javatools.parser.java.v2.model.SourceLocalVariableDeclaration;
import oracle.javatools.parser.java.v2.model.SourceMember;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.SourceVariable;
import oracle.javatools.parser.java.v2.model.SourceVariableDeclaration;
import oracle.javatools.parser.java.v2.model.doc.SourceDocBlockTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocComment;
import oracle.javatools.parser.java.v2.model.doc.SourceDocDescription;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTag;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTagName;
import oracle.javatools.parser.java.v2.model.doc.SourceDocTextFragment;
import oracle.javatools.parser.java.v2.model.expression.SourceAssignmentExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypeExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceTypecastExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceCatchClause;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceFinallyClause;
import oracle.javatools.parser.java.v2.model.statement.SourceIfStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceReturnStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchLabel;
import oracle.javatools.parser.java.v2.model.statement.SourceSwitchStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceThrowStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.model.statement.SourceWhileStatement;

public class SourceUtils {
    public static void addImport(SourceFile file, String importName) {
        file.getSourceImportNames().add(importName);
    }

    public static void addLineComment(SourceBlock block, String commentText) {
    }

    public static void addLineComment(SourceClassBody block, String commentText) {
    }

    public static void addLineComment(SourceElement element, boolean before, String commentText) {
    }

    public static void addBlankLine(SourceBlock block) {
    }

    public static void addBlankLine(SourceClassBody body) {
    }

    public static void addBlankLine(SourceElement block, boolean before) {
    }

    public static SourceClass addClass(SourceFile file, String name, int modifiers) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)file);
        SourceClass cls = factory.createClass(0, name);
        cls.setModifiers(modifiers);
        file.getSourceClasses().add(cls);
        return cls;
    }

    public static SourceClass addInterface(SourceFile file, String name, int modifiers) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)file);
        SourceClass iface = factory.createClass(1, name);
        iface.setModifiers(modifiers);
        file.getSourceClasses().add(iface);
        return iface;
    }

    public static void setSuperclass(SourceClass cls, String fqName) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)cls);
        cls.setSourceSuperclass(factory.createType(fqName));
    }

    public static void addSuperInterface(SourceClass cls, String fqName) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)cls);
        cls.getSourceInterfaces().add(factory.createType(fqName));
    }

    public static SourceMethod addConstructor(SourceClass cls, int modifiers) {
        SourceMethod method = SourceUtils.createConstructor(cls, modifiers);
        cls.getSourceMembers().add(0, method);
        return method;
    }

    public static SourceMethod getDefaultConstructor(SourceClass cls) {
        return cls.getSourceConstructor(new JavaType[0]);
    }

    public static SourceMethod addMethod(SourceClass cls, String type, String name, int modifiers) {
        SourceMethod method = SourceUtils.createMethod(cls, type, name, modifiers);
        cls.getSourceMethods().add(method);
        return method;
    }

    public static SourceMethod addMethod(SourceClass cls, String type, String name, int modifiers, SourceMember sibling, boolean before) {
        SourceMethod method = SourceUtils.createMethod(cls, type, name, modifiers);
        SourceUtils.addMember(cls, (SourceMember)method, sibling, before);
        return method;
    }

    public static SourceMember addMember(SourceClass cls, SourceMember member, SourceMember sibling, boolean before) {
        int index;
        List members = cls.getSourceMembers();
        if (sibling != null && (index = members.indexOf(sibling)) != -1) {
            int pos = before ? index : index + 1;
            members.add(pos, member);
            return member;
        }
        if (before) {
            members.add(0, member);
        } else {
            members.add(member);
        }
        return member;
    }

    public static SourceMethod createMethod(SourceClass cls, String type, String name, int modifiers) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)cls);
        SourceTypeReference retType = factory.createType(type);
        SourceBlock block = cls.isClass() ? factory.createBlock() : null;
        SourceMethod method = factory.createMethod(retType, name, null, null, block);
        method.setModifiers(modifiers);
        return method;
    }

    public static SourceMethod createConstructor(SourceClass cls, int modifiers) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)cls);
        SourceBlock block = factory.createBlock();
        SourceMethod method = factory.createConstructor(null, null, block);
        method.setModifiers(modifiers);
        return method;
    }

    public static void addThrows(SourceMethod method, String throwName) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)method);
        SourceTypeReference throwType = factory.createType(throwName);
        method.getSourceExceptions().add(throwType);
    }

    public static void removeThrows(SourceMethod method, String throwName) {
        List exceptions = method.getSourceExceptions();
        for (SourceTypeReference type : exceptions) {
            if (!type.getName().equals(throwName)) continue;
            type.removeSelf();
            break;
        }
    }

    public static SourceMethod addMainMethod(SourceClass cls) {
        SourceMethod main = SourceUtils.createMainMethod(cls);
        cls.getSourceMethods().add(main);
        return main;
    }

    public static SourceMethod createMainMethod(SourceClass cls) {
        SourceMethod main = SourceUtils.createMethod(cls, "void", "main", 9);
        SourceUtils.addMethodParameter(main, "java.lang.String[]", "args");
        return main;
    }

    public static SourceMethod getMainMethod(SourceClass cls) {
        return SourceUtils.getMethod(cls, "main", new String[]{"java.lang.String[]"});
    }

    public static SourceMethod getMethod(SourceClass cls, String name, String[] paramTypes) {
        JavaProvider provider = cls.getOwningSourceFile().getProvider();
        int count = paramTypes == null ? 0 : paramTypes.length;
        JavaType[] types = new JavaType[count];
        for (int i = 0; i < count; ++i) {
            types[i] = SourceUtils.getType(provider, paramTypes[i]);
        }
        return cls.getSourceMethod(name, types);
    }

    public static JavaType getType(JavaProvider provider, String type) {
        String nonArrayName = type;
        int dimensions = 0;
        int firstBrackets = type.indexOf(91);
        if (firstBrackets != -1) {
            dimensions = (type.length() - firstBrackets) / 2;
            nonArrayName = type.substring(0, firstBrackets).trim();
        }
        JavaClass foundClass = provider.getClass(nonArrayName);
        if (dimensions == 0 || foundClass == null) {
            return foundClass;
        }
        return provider.getArrayType((JavaType)foundClass, dimensions);
    }

    public static SourceLocalVariable addMethodParameter(SourceMethod method, String type, String name) {
        SourceFile file = method.getOwningSourceFile();
        SourceLocalVariable param = SourceUtils.createLocalVariable(file, type, name);
        method.getSourceParameters().add(param);
        return param;
    }

    public static SourceClassInitializer addStaticClassInitializer(SourceClass cls, SourceBlock block) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)cls);
        SourceClassInitializer init = factory.createStaticInitializer(block);
        cls.getSourceInitializers().add(init);
        return init;
    }

    public static SourceDocComment addDocComment(SourceMember member, String descText) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)member);
        SourceDocTextFragment fragment = factory.createDocTextFragment(descText);
        SourceDocDescription description = factory.createDocDescription(fragment);
        SourceDocComment comment = factory.createDocComment(description);
        member.setDocComment(comment);
        return comment;
    }

    public static SourceDocTag addDocTag(SourceDocComment comment, String tagNameText, String tagText) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)comment);
        SourceDocTagName tagName = factory.createDocTagName(tagNameText);
        SourceDocTextFragment tagDescFrag = factory.createDocTextFragment(tagText);
        SourceDocDescription tagDesc = factory.createDocDescription(tagDescFrag);
        SourceDocBlockTag tag = factory.createDocBlockTag(tagName, tagDesc);
        comment.getBlockTags().add(tag);
        return tag;
    }

    public static SourceFieldDeclaration addField(SourceClass cls, String type, String name, int modifiers, String initText) {
        SourceFieldDeclaration field = SourceUtils.createField(cls, type, name, modifiers, initText);
        cls.getSourceFieldDeclarations().add(field);
        return field;
    }

    public static SourceFieldDeclaration createField(SourceClass cls, String type, String name, int modifiers, String initText) {
        if (name.indexOf(44) >= 0 || name.indexOf(61) >= 0) {
            String message = "Not a valid field name >>" + name + "<<";
            new IllegalArgumentException(message).printStackTrace();
            String fullText = type + ' ' + name + ';';
            return SourceUtils.createField(cls, fullText, modifiers);
        }
        SourceFactory factory = SourceUtils.getFactory((SourceElement)cls);
        SourceTypeReference varType = factory.createType(type);
        SourceExpression initExpr = null;
        if (initText != null && initText.length() > 0) {
            initExpr = factory.createExpressionFromText(initText);
        }
        SourceFieldDeclaration field = initExpr == null ? factory.createFieldDeclaration(varType, name) : factory.createFieldDeclaration(varType, name, initExpr);
        field.setModifiers(modifiers);
        return field;
    }

    public static SourceFieldDeclaration createField(SourceClass cls, String fieldText, int modifiers) {
        SourceFieldDeclaration field = SourceUtils.createField(cls, fieldText);
        if (field == null) {
            return null;
        }
        field.setModifiers(modifiers);
        return field;
    }

    public static SourceFieldDeclaration createField(SourceClass cls, String fieldText) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)cls);
        try {
            SourceFieldDeclaration field = (SourceFieldDeclaration)factory.createMemberFromText(fieldText);
            return field;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SourceLocalVariable createLocalVariable(SourceFile file, String type, String name) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)file);
        SourceTypeReference varType = factory.createType(type);
        SourceLocalVariable variable = factory.createLocalVariable(varType, name);
        return variable;
    }

    public static SourceVariableDeclaration addLocalVariableDeclaration(SourceBlock block, String type, String name, String initText) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression initExpr = null;
        if (initText != null && initText.length() > 0) {
            initExpr = factory.createExpressionFromText(initText);
        }
        return SourceUtils.addLocalVariableDeclaration(block, type, name, initExpr);
    }

    public static SourceVariableDeclaration addLocalVariableDeclaration(SourceBlock block, String type, String name, SourceExpression initExpr) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceTypeReference varType = factory.createType(type);
        SourceLocalVariableDeclaration decl = initExpr == null ? factory.createLocalVariableDeclaration(varType, name) : factory.createLocalVariableDeclaration(varType, name, initExpr);
        block.getCodeElements().add(decl);
        return decl;
    }

    public static SourceExpression createMethodCall(SourceBlock block, String lhs, String methodName, String[] args) {
        SourceExpression[] eArray;
        int argCount;
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        if (args == null) {
            args = JavaConstants.EMPTY_STRING_ARRAY;
        }
        if ((argCount = args.length) == 0) {
            eArray = SourceExpression.EMPTY_ARRAY;
        } else {
            ArrayList<SourceExpression> list = new ArrayList<SourceExpression>();
            for (int i = 0; i < argCount; ++i) {
                SourceExpression e = factory.createExpressionFromText(args[i]);
                if (e == null) continue;
                list.add(e);
            }
            SourceExpression[] newArray = new SourceExpression[list.size()];
            eArray = list.toArray(newArray);
        }
        return SourceUtils.createMethodCall(block, lhs, methodName, eArray);
    }

    public static SourceExpression createMethodCall(SourceBlock block, String lhs, String methodName, SourceExpression[] args) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression lhsExpr = null;
        if (lhs != null) {
            lhsExpr = factory.createExpressionFromText(lhs);
        }
        String typeCastName = null;
        if (lhsExpr != null && lhsExpr.getSymbolKind() == 59 && lhs.charAt(0) == '(' && lhs.charAt(lhs.length() - 1) != ')') {
            SourceTypecastExpression typeCastExpr = (SourceTypecastExpression)lhsExpr;
            lhsExpr = (SourceExpression)typeCastExpr.getSecondOperand().cloneSelf(factory.getSourceFile());
            typeCastName = ((SourceTypeExpression)typeCastExpr.getFirstOperand()).getSourceType().getName();
        }
        SourceListExpression exprList = factory.createExpressionList(args);
        SourceMethodCallExpression callExpr = factory.createMethodCall(lhsExpr, methodName, exprList);
        return typeCastName == null ? callExpr : factory.createTypecast(factory.createType(typeCastName), (SourceExpression)callExpr);
    }

    public static SourceStatement addMethodCallStatement(SourceBlock block, String lhs, String methodName, String[] args) {
        SourceExpression callExpr = SourceUtils.createMethodCall(block, lhs, methodName, args);
        return SourceUtils.addExpressionStatement(block, callExpr);
    }

    public static SourceStatement addMethodCallStatement(SourceBlock block, String lhs, String methodName, SourceExpression[] args) {
        SourceExpression callExpr = SourceUtils.createMethodCall(block, lhs, methodName, args);
        return SourceUtils.addExpressionStatement(block, callExpr);
    }

    public static SourceExpression createAssign(SourceBlock block, String lhsName, String rhsText) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression lhsExpr = factory.createExpressionFromText(lhsName);
        SourceExpression rhsExpr = factory.createExpressionFromText(rhsText);
        SourceAssignmentExpression assignExpr = factory.createAssignment(6, lhsExpr, rhsExpr);
        return assignExpr;
    }

    public static SourceStatement addAssignStatement(SourceBlock block, String lhsName, String rhsText) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression rhsExpr = factory.createExpressionFromText(rhsText);
        return SourceUtils.addAssignStatement(block, lhsName, rhsExpr);
    }

    public static SourceStatement addAssignStatement(SourceBlock block, String lhsName, SourceExpression rhsExpr) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression lhsExpr = factory.createExpressionFromText(lhsName);
        SourceAssignmentExpression assignExpr = factory.createAssignment(6, lhsExpr, rhsExpr);
        return SourceUtils.addExpressionStatement(block, (SourceExpression)assignExpr);
    }

    public static SourceStatement addExpressionStatement(SourceBlock block, String exprText) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression expr = factory.createExpressionFromText(exprText);
        return SourceUtils.addExpressionStatement(block, expr);
    }

    public static SourceStatement addExpressionStatement(SourceBlock block, SourceExpression expr) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpressionStatement stmt = factory.createExpressionStatement(expr);
        block.getCodeElements().add(stmt);
        return stmt;
    }

    public static SourceStatement addStatement(SourceBlock block, String stmtText) {
        SourceBlockElement be;
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceStatement stmt = factory.createStatementFromText(stmtText);
        if (stmt == null && (be = factory.createBlockElementFromText(stmtText)) != null) {
            throw new UnsupportedOperationException("Is a block element but not a statement");
        }
        block.getCodeElements().add(stmt);
        return stmt;
    }

    public static SourceStatement addExpressionStatement(SourceBlock block, String exprText, SourceElement sibling, boolean before) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression expr = factory.createExpressionFromText(exprText);
        return SourceUtils.addExpressionStatement(block, expr, sibling, before);
    }

    public static SourceStatement addExpressionStatement(SourceBlock block, SourceExpression expr, SourceElement sibling, boolean before) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpressionStatement stmt = factory.createExpressionStatement(expr);
        return SourceUtils.addStatement(block, (SourceStatement)stmt, sibling, before);
    }

    public static SourceStatement addStatement(SourceBlock block, SourceStatement stmt, SourceElement sibling, boolean before) {
        int index;
        List elements = block.getCodeElements();
        if (sibling != null && (index = elements.indexOf(sibling)) != -1) {
            int pos = before ? index : index + 1;
            elements.add(pos, stmt);
            return stmt;
        }
        if (before) {
            elements.add(0, stmt);
        } else {
            elements.add(stmt);
        }
        return stmt;
    }

    public static SourceIfStatement addIfStatement(SourceBlock block, String condition, SourceBlock ifBlock) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression condExpr = factory.createExpressionFromText(condition);
        SourceIfStatement ifStmt = factory.createIfStatement(condExpr, (SourceStatement)factory.createBlockStatement(ifBlock));
        block.getCodeElements().add(ifStmt);
        return ifStmt;
    }

    public static SourceWhileStatement addWhileStatement(SourceBlock block, String condition, SourceBlock whileBlock) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression condExpr = factory.createExpressionFromText(condition);
        SourceWhileStatement whileStmt = factory.createWhileStatement(condExpr, (SourceStatement)factory.createBlockStatement(whileBlock));
        block.getCodeElements().add(whileStmt);
        return whileStmt;
    }

    public static SourceIfStatement addIfElseStatement(SourceBlock block, String condition, SourceBlock ifBlock, SourceBlock elseBlock) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression condExpr = factory.createExpressionFromText(condition);
        SourceIfStatement ifStmt = factory.createIfElseStatement(condExpr, (SourceStatement)factory.createBlockStatement(ifBlock), (SourceStatement)factory.createBlockStatement(elseBlock));
        block.getCodeElements().add(ifStmt);
        return ifStmt;
    }

    public static SourceStatement addReturn(SourceBlock block, String stmtText) {
        SourceStatement returnStmt = SourceUtils.createReturn(block, stmtText);
        block.getCodeElements().add(returnStmt);
        return returnStmt;
    }

    public static SourceStatement createReturn(SourceBlock block, String stmtText) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression e = factory.createExpressionFromText(stmtText);
        SourceReturnStatement returnStmt = factory.createReturnStatement(e);
        return returnStmt;
    }

    public static SourceThrowStatement addThrowStatement(SourceBlock block, String throwText) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression throwExpr = factory.createExpressionFromText(throwText);
        SourceThrowStatement throwStmt = factory.createThrowStatement(throwExpr);
        block.getCodeElements().add(throwStmt);
        return throwStmt;
    }

    public static SourceSwitchStatement addSwitchStatement(SourceBlock block, String switchText, SourceBlock switchBlock) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceExpression switchExpr = factory.createExpressionFromText(switchText);
        SourceSwitchStatement switchStmt = factory.createSwitchStatement(switchExpr, factory.createBlockStatement(switchBlock));
        block.getCodeElements().add(switchStmt);
        return switchStmt;
    }

    public static SourceSwitchLabel addSwitchCaseLabel(SourceBlock switchBlock, String caseText) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)switchBlock);
        SourceExpression caseExpr = factory.createExpressionFromText(caseText);
        SourceSwitchLabel switchLabel = factory.createSwitchCaseLabel(caseExpr);
        switchBlock.getCodeElements().add(switchLabel);
        return switchLabel;
    }

    public static SourceTryStatement addTryCatchStatement(SourceBlock block, SourceBlock tryBlock, String catchType, String catchName, SourceBlock catchBlock) {
        SourceTryStatement tryStmt = SourceUtils.createTryCatchStatement(block, tryBlock, catchType, catchName, catchBlock);
        block.getCodeElements().add(tryStmt);
        return tryStmt;
    }

    public static SourceBlock getFinallyBlock(SourceTryStatement tryStatement) {
        SourceStatement stmt;
        SourceFinallyClause finallyClause = tryStatement.getFinallyClause();
        if (finallyClause != null && (stmt = finallyClause.getPrimaryClause()) instanceof SourceHasBlock) {
            return ((SourceHasBlock)stmt).getBlock();
        }
        return null;
    }

    public static SourceFinallyClause addFinallyClause(SourceTryStatement tryStmt, SourceBlock finallyBlock) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)tryStmt);
        SourceFinallyClause finallyClause = factory.createFinallyClause(factory.createBlockStatement(finallyBlock));
        tryStmt.getChildren().add(finallyClause);
        return finallyClause;
    }

    public static SourceCatchClause addCatchClause(SourceTryStatement tryStmt, String catchType, String catchName, SourceBlock catchBlock) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)tryStmt);
        SourceLocalVariable catchVar = SourceUtils.createLocalVariable(tryStmt.getOwningSourceFile(), catchType, catchName);
        SourceCatchClause catchClause = factory.createCatchClause(catchVar, factory.createBlockStatement(catchBlock));
        tryStmt.getCatchClauses().add(catchClause);
        return catchClause;
    }

    public static SourceTryStatement createTryCatchStatement(SourceBlock block, SourceBlock tryBlock, String catchType, String catchName, SourceBlock catchBlock) {
        SourceFactory factory = SourceUtils.getFactory((SourceElement)block);
        SourceLocalVariable catchVar = SourceUtils.createLocalVariable(block.getOwningSourceFile(), catchType, catchName);
        SourceTryStatement tryStmt = factory.createTryCatchStatement(factory.createBlockStatement(tryBlock), catchVar, factory.createBlockStatement(catchBlock));
        return tryStmt;
    }

    public static SourceVariable getMethodParameter(SourceMethod method, int index) {
        List parameters = method.getSourceParameters();
        if (parameters.size() > index) {
            return (SourceVariable)parameters.get(index);
        }
        return null;
    }

    public static SourceFactory getFactory(SourceElement element) {
        return element.getOwningSourceFile().getFactory();
    }

    public static SourceBlock createBlock(SourceElement element) {
        return SourceUtils.getFactory(element).createBlock();
    }
}

