/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.StringTokenizer;

public final class NamingUtil {
    private static final Collection<String> JAVA_KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "try", "void", "volatile", "while"));
    private static final Collection<String> JAVA_RESERVED_WORDS = Arrays.asList("true", "false", "null");

    private NamingUtil() {
    }

    public static boolean isJavaKeyword(String name) {
        return JAVA_KEYWORDS.contains(name);
    }

    public static boolean isJavaReservedWord(String name) {
        return NamingUtil.isJavaKeyword(name) || JAVA_RESERVED_WORDS.contains(name);
    }

    public static boolean isJavaIdentifier(String name) {
        if (name == null) {
            return false;
        }
        int length = name.length();
        if (length == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(name.charAt(0))) {
            return false;
        }
        if (NamingUtil.isJavaReservedWord(name)) {
            return false;
        }
        for (int i = 1; i < length; ++i) {
            if (Character.isJavaIdentifierPart(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isPackageIdentifier(String name) {
        if (name == null) {
            return false;
        }
        if (name.startsWith(".") || name.endsWith(".") || name.indexOf("..") >= 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(name, ".");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (NamingUtil.isJavaIdentifier(token)) continue;
            return false;
        }
        return true;
    }
}

