/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.util;

import java.io.IOException;
import java.net.URL;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.FileUtilities;
import oracle.javatools.parser.java.v2.classfile.ClassFile;
import oracle.jdeveloper.java.util.TimedLRUCache;

public final class ClassFileCache {
    private static final int CLASS_FILE_CACHE_SIZE = 100;
    private static final int CLASS_FILE_EXPIRATION_TIME = 3600;
    private static TimedLRUCache _classCache = new TimedLRUCache(100, 3600);

    private ClassFileCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassFile getClassFile(URL classURL) {
        long timestamp = URLFileSystem.lastModified((URL)classURL);
        CacheEntry entry = (CacheEntry)_classCache.get(classURL);
        if (entry != null) {
            if (timestamp == entry.timestamp) {
                return entry.classFile;
            }
            _classCache.remove(classURL);
        }
        TimedLRUCache timedLRUCache = _classCache;
        synchronized (timedLRUCache) {
            ClassFile classFile = ClassFileCache.readClassFile(classURL);
            if (classFile != null) {
                entry = new CacheEntry(classURL, classFile, timestamp);
                _classCache.put(classURL, entry);
                return classFile;
            }
        }
        return null;
    }

    private static ClassFile readClassFile(URL classURL) {
        try {
            byte[] data = FileUtilities.readFile((URL)classURL);
            if (data != null && data.length > 0) {
                ClassFile classFile = new ClassFile(data, classURL);
                return classFile;
            }
        }
        catch (IOException e) {
        }
        catch (ArrayIndexOutOfBoundsException e) {
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return null;
    }

    private static class CacheEntry {
        private URL classURL;
        private ClassFile classFile;
        private long timestamp;

        private CacheEntry(URL classURL, ClassFile classFile, long timestamp) {
            this.classURL = classURL;
            this.classFile = classFile;
            this.timestamp = timestamp;
        }
    }
}

