/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.ide.net.JarIndex;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.PackageEntry;
import oracle.jdeveloper.java.locator.URLClassLocator;

public class JarURLClassLocator
extends URLClassLocator {
    private static volatile long _lastBuiltTime = -1L;
    private static final Map<JarURLClassLocator, Boolean> INSTANCES = new WeakHashMap<JarURLClassLocator, Boolean>();
    private volatile Map<String, PackageEntry> _packageMap;
    private long _lastJarTimestamp = -1L;
    private final JarIndex _jarIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastBuiltTime() {
        Map<JarURLClassLocator, Boolean> map = INSTANCES;
        synchronized (map) {
            for (JarURLClassLocator instance : INSTANCES.keySet()) {
                instance.buildIndex();
            }
        }
        return _lastBuiltTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JarURLClassLocator(URL jarURL, int classType) {
        super(jarURL, classType);
        this._jarIndex = JarIndex.getInstance((URL)JarUtil.getJarFileURL((URL)jarURL));
        Map<JarURLClassLocator, Boolean> map = INSTANCES;
        synchronized (map) {
            INSTANCES.put(this, Boolean.TRUE);
        }
    }

    @Override
    public synchronized void buildIndex() {
        long timestamp = this._jarIndex.getTimestamp();
        if (this._packageMap == null || timestamp != this._lastJarTimestamp) {
            this.buildIndexImpl();
            this._lastJarTimestamp = timestamp;
            _lastBuiltTime = System.nanoTime();
        }
    }

    @Override
    protected void getPackages(String packagePrefix, Collection<String> out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            out.addAll(entry.getSubpackageNamesAsList());
        }
    }

    @Override
    protected void getClassesInPackage(String packagePrefix, Collection<String> out) {
        PackageEntry entry = this.findPackage(packagePrefix);
        if (entry != null) {
            if (this.isSourceTypeLocator()) {
                out.addAll(entry.getClassesAsList());
            } else {
                for (String className : entry.getClasses()) {
                    if (className.indexOf(36) != -1) continue;
                    out.add(className);
                }
            }
        }
    }

    @Override
    protected void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        this.buildIndex();
        for (PackageEntry entry : this._packageMap.values()) {
            String packageName = entry._packageName;
            for (String className : entry.getClasses()) {
                if (className.indexOf(36) != -1) continue;
                boolean acceptName = true;
                if (filter != null) {
                    acceptName = filter.acceptClassName(className, packageName);
                }
                if (!acceptName) continue;
                String fqName = JarURLClassLocator.buildFQName(packageName, className);
                out.add(fqName);
            }
        }
    }

    @Override
    protected void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        this.buildIndex();
        for (String packagePrefix : this._packageMap.keySet()) {
            if (packagePrefix.length() <= 0 || filter != null && !filter.acceptPackageName(packagePrefix)) continue;
            out.add(packagePrefix);
        }
    }

    @Override
    public URL getURL(String fqClassName) {
        int countCascades;
        this.buildIndex();
        String[] nameCascades = JarURLClassLocator.getNameCascades(fqClassName);
        String[] nameParts = JarURLClassLocator.getNameParts(fqClassName);
        int countParts = countCascades = nameCascades.length;
        if (countCascades > 1) {
            String packagePrefix = nameCascades[countCascades - 2];
            PackageEntry foundEntry = this.findPackage(packagePrefix);
            if (foundEntry == null) {
                return null;
            }
            String className = nameParts[countParts - 1];
            if (!foundEntry.getClassesAsList().contains(className)) {
                return null;
            }
        }
        for (String suffix : this.isSourceTypeLocator() ? SOURCE_SUFFIXES : CLASS_SUFFIXES) {
            String entryPath = fqClassName.replace('.', '/') + suffix;
            URL rootURL = this.getRootURL();
            String rootPrefix = JarUtil.getJarEntry((URL)rootURL);
            if (rootPrefix == null) {
                rootPrefix = "";
            }
            if (!this._jarIndex.exists(rootPrefix + entryPath)) continue;
            return URLFactory.newJarURL((URL)rootURL, (String)entryPath);
        }
        return null;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        if (this.isClassTypeLocator()) {
            this.buildIndex();
            URL rootURL = this.getRootURL();
            String rootPrefix = JarUtil.getJarEntry((URL)rootURL);
            if (rootPrefix == null) {
                rootPrefix = "";
            }
            if (this._jarIndex.exists(rootPrefix + resourceName)) {
                return URLFactory.newJarURL((URL)rootURL, (String)resourceName);
            }
        }
        return null;
    }

    private void buildIndexImpl() {
        String[] entryList = this._jarIndex.getEntries();
        int numEntries = entryList.length;
        String rootPrefix = JarUtil.getJarEntry((URL)this.getRootURL());
        int rootLen = rootPrefix != null ? rootPrefix.length() : 0;
        HashMap<String, Collection<String>> packageToClassMap = new HashMap<String, Collection<String>>(numEntries);
        HashMap<String, Collection<String>> packageToSubMap = new HashMap<String, Collection<String>>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            String entry = entryList[i];
            if (rootLen > 0) {
                if (!entry.startsWith(rootPrefix)) continue;
                entry = entry.substring(rootLen);
            }
            if (entry.length() == 0 || !this.isMatchingFileType(entry)) continue;
            JarURLClassLocator.addClassToMaps(entry, packageToClassMap, packageToSubMap);
        }
        ArraySortedSet allKeys = new ArraySortedSet(100);
        allKeys.addAll(packageToClassMap.keySet());
        allKeys.addAll(packageToSubMap.keySet());
        HashMap<String, PackageEntry> finalPackageMap = new HashMap<String, PackageEntry>(allKeys.size());
        for (String packageName : allKeys) {
            Collection classes = (Collection)packageToClassMap.get(packageName);
            Collection subs = (Collection)packageToSubMap.get(packageName);
            if ((classes == null || classes.isEmpty()) && (subs == null || subs.isEmpty())) continue;
            finalPackageMap.put(packageName, new PackageEntry(packageName, classes, subs));
        }
        this._packageMap = finalPackageMap;
    }

    private static void addClassToMaps(String classEntry, Map<String, Collection<String>> packageToClassMap, Map<String, Collection<String>> packageToSubMap) {
        int suffixDot = classEntry.lastIndexOf(46);
        String fqName = classEntry.substring(0, suffixDot).replace('/', '.');
        int lastDot = fqName.lastIndexOf(46);
        String packagePrefix = lastDot != -1 ? fqName.substring(0, lastDot) : "";
        String className = lastDot != -1 ? fqName.substring(lastDot + 1) : fqName;
        boolean existingPackage = true;
        ArraySortedSet classList = packageToClassMap.get(packagePrefix);
        if (classList == null) {
            classList = new ArraySortedSet(75);
            packageToClassMap.put(packagePrefix, (Collection<String>)classList);
            existingPackage = false;
        } else {
            className = new String(className);
        }
        classList.add(className);
        if (existingPackage) {
            return;
        }
        if (packagePrefix.length() == 0) {
            return;
        }
        JarURLClassLocator.fillPackagesInMaps(packagePrefix, packageToSubMap);
    }

    private static void fillPackagesInMaps(String packagePrefix, Map<String, Collection<String>> packageToSubMap) {
        String outer = "";
        int pos = 0;
        boolean done = false;
        while (!done) {
            int nextDot = packagePrefix.indexOf(46, pos);
            if (nextDot == -1) {
                done = true;
                nextDot = packagePrefix.length();
            }
            String sub = packagePrefix.substring(pos, nextDot);
            ArraySortedSet subList = packageToSubMap.get(outer);
            if (subList == null) {
                subList = new ArraySortedSet(20);
                packageToSubMap.put(outer, (Collection<String>)subList);
            }
            subList.add((String)sub);
            outer = packagePrefix.substring(0, nextDot);
            pos = nextDot + 1;
        }
    }

    private PackageEntry findPackage(String packageName) {
        this.buildIndex();
        return this._packageMap.get(packageName);
    }
}

