/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import oracle.javatools.util.ArraySortedSet;
import oracle.jdeveloper.java.JavaClassLocator2;
import oracle.jdeveloper.java.JavaResourceLocator;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.filter.SimpleNameFilter;

public abstract class BaseClassLocator
implements JavaClassLocator2,
JavaResourceLocator {
    public static final BaseClassLocator EMPTY_LOCATOR = new NOPClassLocator();
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final Collection EMPTY_COLLECTION = Arrays.asList(EMPTY_STRING_ARRAY);
    private static SimpleCache _splitNameCache = new SimpleCache(25);

    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        this.buildIndex();
    }

    @Override
    public Collection<URL> getResourceURLs(String resourceName) {
        URL url = this.getResourceURL(resourceName);
        if (url == null) {
            return Collections.emptyList();
        }
        ArrayList<URL> ret = new ArrayList<URL>(1);
        ret.add(url);
        return ret;
    }

    @Override
    public Collection<String> getPackages(String packagePrefix) {
        ArraySortedSet packageSet = new ArraySortedSet(20);
        this.getPackages(packagePrefix, (Collection<String>)packageSet);
        return packageSet;
    }

    @Override
    public Collection<String> getPackagesInterruptibly(String packagePrefix) throws InterruptedException {
        ArraySortedSet packageSet = new ArraySortedSet(20);
        this.getPackagesInterruptibly(packagePrefix, (Collection<String>)packageSet);
        return packageSet;
    }

    protected abstract void getPackages(String var1, Collection<String> var2);

    protected void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.getPackages(packagePrefix, out);
    }

    @Override
    public Collection<String> getClassesInPackage(String packagePrefix) {
        ArraySortedSet classSet = new ArraySortedSet(100);
        this.getClassesInPackage(packagePrefix, (Collection<String>)classSet);
        return classSet;
    }

    @Override
    public Collection<String> getClassesInPackageInterruptibly(String packagePrefix) throws InterruptedException {
        ArraySortedSet classSet = new ArraySortedSet(100);
        this.getClassesInPackageInterruptibly(packagePrefix, (Collection<String>)classSet);
        return classSet;
    }

    protected abstract void getClassesInPackage(String var1, Collection<String> var2);

    protected void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        this.getClassesInPackage(packagePrefix, out);
    }

    @Override
    public Collection<String> getAllClasses() {
        return this.getAllClasses(null);
    }

    @Override
    public Collection<String> getAllClassesInterruptibly() throws InterruptedException {
        return this.getAllClassesInterruptibly(null);
    }

    @Override
    public Collection<String> getAllClasses(ClassNameFilter filter) {
        HashSet<String> hashSet = new HashSet<String>(10000);
        this.getAllClasses(hashSet, filter);
        return hashSet;
    }

    @Override
    public Collection<String> getAllClassesInterruptibly(ClassNameFilter filter) throws InterruptedException {
        HashSet<String> hashSet = new HashSet<String>(10000);
        this.getAllClassesInterruptibly(hashSet, filter);
        return hashSet;
    }

    protected abstract void getAllClasses(Collection<String> var1, ClassNameFilter var2);

    protected void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        this.getAllClasses(out, filter);
    }

    @Override
    public Collection<String> getAllPackages() {
        return this.getAllPackages(null);
    }

    @Override
    public Collection<String> getAllPackagesInterruptibly() throws InterruptedException {
        return this.getAllPackagesInterruptibly(null);
    }

    @Override
    public Collection<String> getAllPackages(PackageNameFilter filter) {
        ArraySortedSet packageSet = new ArraySortedSet(200);
        this.getAllPackages((Collection<String>)packageSet, filter);
        return packageSet;
    }

    @Override
    public Collection<String> getAllPackagesInterruptibly(PackageNameFilter filter) throws InterruptedException {
        ArraySortedSet packageSet = new ArraySortedSet(200);
        this.getAllPackagesInterruptibly((Collection<String>)packageSet, filter);
        return packageSet;
    }

    protected abstract void getAllPackages(Collection<String> var1, PackageNameFilter var2);

    protected void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        this.getAllPackages(out, filter);
    }

    @Override
    public Collection<String> getClassesByName(String name, boolean matchCase) {
        SimpleNameFilter wholeNameFilter = new SimpleNameFilter(name, matchCase, 1);
        return this.getAllClasses(wholeNameFilter);
    }

    @Override
    public Collection<String> getClassesByNameInterruptibly(String name, boolean matchCase) throws InterruptedException {
        SimpleNameFilter wholeNameFilter = new SimpleNameFilter(name, matchCase, 1);
        return this.getAllClassesInterruptibly(wholeNameFilter);
    }

    @Override
    public Collection<String> getClassesByPrefix(String prefix, boolean matchCase) {
        SimpleNameFilter prefixFilter = new SimpleNameFilter(prefix, matchCase, 2);
        return this.getAllClasses(prefixFilter);
    }

    @Override
    public Collection<String> getClassesByPrefixInterruptibly(String prefix, boolean matchCase) throws InterruptedException {
        SimpleNameFilter prefixFilter = new SimpleNameFilter(prefix, matchCase, 2);
        return this.getAllClassesInterruptibly(prefixFilter);
    }

    @Override
    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.getURL(fqClassName);
    }

    @Override
    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.getSourceURL(fqClassName);
    }

    @Override
    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        return this.getClassURL(fqClassName);
    }

    protected static void checkInterrupt() throws InterruptedException {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
    }

    protected static BaseClassLocator ensureValid(BaseClassLocator locator) {
        if (locator != null) {
            return locator;
        }
        return EMPTY_LOCATOR;
    }

    public static <T> void addToCollection(T[] array, Collection<T> collection) {
        collection.addAll(Arrays.asList(array));
    }

    public static String[] getStringArray(Collection<String> collection) {
        int size = collection == null ? 0 : collection.size();
        return size == 0 ? EMPTY_STRING_ARRAY : collection.toArray(new String[size]);
    }

    public static String buildFQName(String packagePrefix, String className) {
        String fullName = packagePrefix.length() > 0 ? packagePrefix + "." + className : className;
        return fullName;
    }

    protected static String[] getNameParts(String fqName) {
        SplitName splitName = BaseClassLocator.getSplitName(fqName);
        return splitName._nameParts;
    }

    protected static String[] getNameCascades(String fqName) {
        SplitName splitName = BaseClassLocator.getSplitName(fqName);
        return splitName._nameCascades;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SplitName getSplitName(String fqName) {
        SimpleCache simpleCache = _splitNameCache;
        synchronized (simpleCache) {
            SplitName splitName = (SplitName)BaseClassLocator._splitNameCache.get(fqName);
            if (splitName == null) {
                splitName = new SplitName(fqName);
                BaseClassLocator._splitNameCache.put(fqName, splitName);
            }
            return splitName;
        }
    }

    private static class NOPClassLocator
    extends BaseClassLocator {
        private NOPClassLocator() {
        }

        @Override
        public void buildIndex() {
        }

        @Override
        protected void getPackages(String packagePrefix, Collection<String> out) {
        }

        @Override
        protected void getClassesInPackage(String packagePrefix, Collection<String> out) {
        }

        @Override
        protected void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        }

        @Override
        protected void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        }

        @Override
        public URL getURL(String fqClassName) {
            return null;
        }

        @Override
        public URL getSourceURL(String fqClassName) {
            return null;
        }

        @Override
        public URL getClassURL(String fqClassName) {
            return null;
        }

        @Override
        public URL getResourceURL(String resourceName) {
            return null;
        }

        @Override
        public Collection<URL> getResourceURLs(String resourceName) {
            return Collections.emptyList();
        }
    }

    private static class SplitName {
        private String[] _nameParts;
        private String[] _nameCascades;

        private SplitName(String fqName) {
            int lastDot;
            int i;
            int numDots = 0;
            int nameLength = fqName.length();
            for (i = 0; i < nameLength; ++i) {
                if (fqName.charAt(i) != '.') continue;
                ++numDots;
            }
            this._nameParts = new String[numDots + 1];
            this._nameCascades = new String[numDots + 1];
            this._nameCascades[numDots] = fqName;
            for (i = numDots - 1; i >= 0; --i) {
                String longerCascade = this._nameCascades[i + 1];
                lastDot = longerCascade.lastIndexOf(46);
                this._nameCascades[i] = longerCascade.substring(0, lastDot);
            }
            for (i = 0; i <= numDots; ++i) {
                String cascade = this._nameCascades[i];
                lastDot = cascade.lastIndexOf(46);
                this._nameParts[i] = lastDot == -1 ? cascade : cascade.substring(lastDot + 1);
            }
        }
    }

    private static class SimpleCache {
        private int _maxSize;
        private ArrayList _entryList;
        private HashMap _entryMap;

        private SimpleCache(int maxSize) {
            this._maxSize = maxSize;
            this._entryList = new ArrayList(maxSize + 1);
            this._entryMap = new HashMap(maxSize + 1);
        }

        private Object get(String key) {
            return this._entryMap.get(key);
        }

        private void put(String key, Object value) {
            this._entryMap.put(key, value);
            this._entryList.add(key);
            if (this._entryList.size() > this._maxSize) {
                String oldestKey = (String)this._entryList.remove(0);
                this._entryMap.remove(oldestKey);
            }
        }
    }
}

