/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.locator;

import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.java.locator.BaseClassLocator;

public class ArrayClassLocator
extends BaseClassLocator {
    private BaseClassLocator[] _locators;

    public ArrayClassLocator(BaseClassLocator[] locators) {
        this._locators = locators;
    }

    @Override
    public void buildIndex() {
        int count = this._locators.length;
        for (int i = 0; i < count; ++i) {
            this._locators[i].buildIndex();
        }
    }

    @Override
    public void buildIndexInterruptibly() throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            locator.buildIndexInterruptibly();
        }
    }

    @Override
    protected void getPackages(String packagePrefix, Collection<String> out) {
        for (BaseClassLocator locator : this._locators) {
            locator.getPackages(packagePrefix, out);
        }
    }

    @Override
    protected void getPackagesInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            locator.getPackagesInterruptibly(packagePrefix, out);
        }
    }

    @Override
    protected void getClassesInPackage(String packagePrefix, Collection<String> out) {
        for (BaseClassLocator locator : this._locators) {
            locator.getClassesInPackage(packagePrefix, out);
        }
    }

    @Override
    protected void getClassesInPackageInterruptibly(String packagePrefix, Collection<String> out) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            locator.getClassesInPackageInterruptibly(packagePrefix, out);
        }
    }

    @Override
    protected void getAllClasses(Collection<String> out, ClassNameFilter filter) {
        for (BaseClassLocator locator : this._locators) {
            locator.getAllClasses(out, filter);
        }
    }

    @Override
    protected void getAllClassesInterruptibly(Collection<String> out, ClassNameFilter filter) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            locator.getAllClassesInterruptibly(out, filter);
        }
    }

    @Override
    protected void getAllPackages(Collection<String> out, PackageNameFilter filter) {
        for (BaseClassLocator locator : this._locators) {
            locator.getAllPackages(out, filter);
        }
    }

    @Override
    protected void getAllPackagesInterruptibly(Collection<String> out, PackageNameFilter filter) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            locator.getAllPackagesInterruptibly(out, filter);
        }
    }

    @Override
    public URL getURL(String fqClassName) {
        for (BaseClassLocator locator : this._locators) {
            URL url = locator.getURL(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getURLInterruptibly(String fqClassName) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            URL url = locator.getURLInterruptibly(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getSourceURL(String fqClassName) {
        for (BaseClassLocator locator : this._locators) {
            URL url = locator.getSourceURL(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getSourceURLInterruptibly(String fqClassName) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            URL url = locator.getSourceURLInterruptibly(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getClassURL(String fqClassName) {
        for (BaseClassLocator locator : this._locators) {
            URL url = locator.getClassURL(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getClassURLInterruptibly(String fqClassName) throws InterruptedException {
        for (BaseClassLocator locator : this._locators) {
            ArrayClassLocator.checkInterrupt();
            URL url = locator.getClassURLInterruptibly(fqClassName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public URL getResourceURL(String resourceName) {
        for (BaseClassLocator locator : this._locators) {
            URL url = locator.getResourceURL(resourceName);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public Collection<URL> getResourceURLs(String resourceName) {
        LinkedList<URL> urls = new LinkedList<URL>();
        for (BaseClassLocator locator : this._locators) {
            urls.addAll(locator.getResourceURLs(resourceName));
        }
        return urls;
    }
}

