/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import oracle.i18n.util.LocaleMapper;
import oracle.jdbc.OracleDriver;
import oracle.sql.CLOB;
import oracle.xml.sql.OracleXMLSQLException;
import oracle.xml.sql.XSULocale;
import oracle.xml.sql.dataset.OracleXMLDataSetExtJdbc;
import oracle.xml.sql.dml.OracleXMLSave;
import oracle.xml.sql.docgen.OracleXMLDocGen;
import oracle.xml.sql.docgen.OracleXMLDocGenLob;
import oracle.xml.sql.query.OracleXMLQuery;

public class OracleXMLStore {
    private static Connection conn;
    private static String connEnc;
    private static String encTag;
    private static final String DBENCODING = "_";
    private static final int INSERT = 1;
    private static final int UPDATE = 2;
    private static final int DELETE = 3;
    private static int maxRows;
    private static int skipRows;
    private static String rowSetTag;
    private static String rowTag;
    private static String rowIdCol;
    private static String rowIdAttr;
    private static String errorTag;
    private static final int LOWER_CASE = 1;
    private static final int UPPER_CASE = 2;
    private static final int DEFAULT_CASE = 3;
    private static int tagcase;
    private static String styleSheet;
    private static String styleSheetType;
    private static boolean nullAttrInd;
    private static String collIdAttr;
    private static boolean raiseException;
    private static boolean propagateOriginalException;
    private static int errCode;
    private static String errMsg;
    private static Vector bindNames;
    private static Vector bindValues;
    private static Reader metaHeader;
    private static Reader dataHeader;
    private static String docTag;
    private static int docType;
    private static String queryDateFormat;
    private static boolean updateQueryDateFormat;
    private static String dateFormat;
    private static boolean ignoreCase;
    private static int batchSize;
    private static int cmtBatch;
    private static String lobDuration;
    private static Vector updColList;
    private static Vector keyColList;

    public static void getXML(Connection connection, String string, int n, CLOB cLOB) throws Exception {
        try {
            conn = connection;
            OracleXMLStore.getXML(new StringReader(string), n, cLOB);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            errCode = oracleXMLSQLException.getErrorCode();
            errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw propagateOriginalException && exception != null ? exception : oracleXMLSQLException;
        }
    }

    public static void getXML(CLOB cLOB, int n, CLOB cLOB2) throws Exception {
        if (conn == null) {
            conn = new OracleDriver().defaultConnection();
        }
        try {
            OracleXMLStore.getXML(cLOB.getCharacterStream(), n, cLOB2);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            errCode = oracleXMLSQLException.getErrorCode();
            errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw propagateOriginalException && exception != null ? exception : oracleXMLSQLException;
        }
    }

    public static void getXML(String string, int n, CLOB cLOB) throws Exception {
        if (conn == null) {
            conn = new OracleDriver().defaultConnection();
        }
        try {
            OracleXMLStore.getXML(new StringReader(string), n, cLOB);
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            errCode = oracleXMLSQLException.getErrorCode();
            errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw propagateOriginalException && exception != null ? exception : oracleXMLSQLException;
        }
    }

    private static void getXML(Reader reader, int n, CLOB cLOB) throws Exception {
        Exception exception = null;
        OracleXMLDataSetExtJdbc oracleXMLDataSetExtJdbc = null;
        try {
            oracleXMLDataSetExtJdbc = new OracleXMLDataSetExtJdbc(conn, new BufferedReader(reader), bindNames, bindValues);
        }
        catch (Exception exception2) {
            exception = exception2;
        }
        OracleXMLQuery oracleXMLQuery = new OracleXMLQuery(oracleXMLDataSetExtJdbc);
        if (exception != null) {
            oracleXMLQuery.setException(exception);
        }
        oracleXMLQuery.setRowsetTag(rowSetTag);
        oracleXMLQuery.setRowTag(rowTag);
        oracleXMLQuery.setCollIdAttrName(collIdAttr);
        oracleXMLQuery.setRaiseException(raiseException);
        oracleXMLQuery.setErrorTag(errorTag);
        oracleXMLQuery.useNullAttributeIndicator(nullAttrInd);
        oracleXMLQuery.setDataHeader(dataHeader, docTag);
        oracleXMLQuery.setMetaHeader(metaHeader);
        if (updateQueryDateFormat) {
            oracleXMLQuery.setDateFormat(queryDateFormat);
            updateQueryDateFormat = false;
        }
        if (rowIdAttr != null) {
            oracleXMLQuery.setRowIdAttrName(rowIdAttr);
        }
        if (rowIdCol != null) {
            oracleXMLQuery.setRowIdAttrValue(rowIdCol);
        }
        oracleXMLQuery.setEncoding(encTag);
        if (tagcase == 2) {
            oracleXMLQuery.useUpperCaseTagNames();
        } else if (tagcase == 1) {
            oracleXMLQuery.useLowerCaseTagNames();
        }
        if (styleSheet != null) {
            if (styleSheetType != null) {
                oracleXMLQuery.setStylesheetHeader(styleSheet, styleSheetType);
            } else {
                oracleXMLQuery.setStylesheetHeader(styleSheet);
            }
        }
        try {
            if (docType == 1) {
                oracleXMLQuery.setMaxRows(maxRows);
                oracleXMLQuery.setSkipRows(skipRows);
                OracleXMLDocGenLob oracleXMLDocGenLob = new OracleXMLDocGenLob(conn, cLOB);
                oracleXMLQuery.getXML((OracleXMLDocGen)oracleXMLDocGenLob, n);
                oracleXMLDocGenLob.flush();
            } else {
                OracleXMLDocGenLob oracleXMLDocGenLob = new OracleXMLDocGenLob(conn, cLOB);
                if (docType == 2) {
                    oracleXMLQuery.getXMLMetaData(n, true, oracleXMLDocGenLob);
                } else {
                    oracleXMLQuery.getXMLMetaData(n, false, oracleXMLDocGenLob);
                }
                oracleXMLDocGenLob.flush();
            }
        }
        catch (Exception exception3) {
            throw (Exception)exception3.fillInStackTrace();
        }
        finally {
            if (oracleXMLQuery != null) {
                oracleXMLQuery.close();
            }
            if (oracleXMLDataSetExtJdbc != null) {
                oracleXMLDataSetExtJdbc.close();
            }
        }
    }

    public static void getXMLMetaData(String string, int n, int n2, CLOB cLOB) throws Exception {
        docType = n2 != 0 ? 2 : 0;
        OracleXMLStore.getXML(string, n, cLOB);
        docType = 1;
    }

    public static void getXMLMetaData(CLOB cLOB, int n, int n2, CLOB cLOB2) throws Exception {
        docType = n2 != 0 ? 2 : 0;
        OracleXMLStore.getXML(cLOB, n, cLOB2);
        docType = 1;
    }

    public static void bindValue(String string, String string2) {
        if (string == null) {
            return;
        }
        if (bindNames == null) {
            bindNames = new Vector(10, 10);
            bindValues = new Vector(10, 10);
        }
        bindNames.addElement(string);
        bindValues.addElement(string2);
    }

    public static void clearBindValues() {
        bindNames = null;
        bindValues = null;
    }

    private static OracleXMLSave createSaveObject(String string) throws SQLException {
        int n;
        String[] stringArray;
        int n2;
        if (conn == null) {
            conn = new OracleDriver().defaultConnection();
        }
        OracleXMLSave oracleXMLSave = new OracleXMLSave(conn, string);
        if (batchSize > 0) {
            oracleXMLSave.setBatchSize(batchSize);
        }
        if (cmtBatch > 0) {
            oracleXMLSave.setCommitBatch(cmtBatch);
        }
        oracleXMLSave.setIgnoreCase(ignoreCase);
        oracleXMLSave.setDateFormat(dateFormat);
        oracleXMLSave.setRowTag(rowTag);
        if (keyColList != null) {
            n2 = keyColList.size();
            stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = (String)keyColList.elementAt(n);
            }
            oracleXMLSave.setKeyColumnList(stringArray);
        }
        if (updColList != null) {
            n2 = updColList.size();
            stringArray = new String[n2];
            for (n = 0; n < n2; ++n) {
                stringArray[n] = (String)updColList.elementAt(n);
            }
            oracleXMLSave.setUpdateColumnList(stringArray);
        }
        return oracleXMLSave;
    }

    public static void setKeyColumn(String string) {
        if (keyColList == null) {
            keyColList = new Vector(10, 10);
        }
        keyColList.addElement(string);
    }

    public static void clearKeyColumnList() {
        keyColList = null;
    }

    public static void setUpdateColumn(String string) {
        if (updColList == null) {
            updColList = new Vector(10, 10);
        }
        updColList.addElement(string);
    }

    public static void clearUpdateColumnList() {
        updColList = null;
    }

    public static int saveXML(String string, String string2, int n) throws Exception {
        OracleXMLSave oracleXMLSave = null;
        try {
            oracleXMLSave = OracleXMLStore.createSaveObject(string);
            switch (n) {
                case 1: {
                    int n2 = oracleXMLSave.insertXML(string2);
                    return n2;
                }
                case 2: {
                    int n3 = oracleXMLSave.updateXML(string2);
                    return n3;
                }
                case 3: {
                    int n4 = oracleXMLSave.deleteXML(string2);
                    return n4;
                }
            }
            int n5 = 0;
            return n5;
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            errCode = oracleXMLSQLException.getErrorCode();
            errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw propagateOriginalException && exception != null ? exception : oracleXMLSQLException;
        }
        finally {
            if (oracleXMLSave != null) {
                oracleXMLSave.close();
            }
        }
    }

    public static int saveXML(String string, CLOB cLOB, int n) throws Exception {
        OracleXMLSave oracleXMLSave = null;
        try {
            Reader reader = cLOB.getCharacterStream();
            oracleXMLSave = OracleXMLStore.createSaveObject(string);
            switch (n) {
                case 1: {
                    int n2 = oracleXMLSave.insertXML(reader);
                    return n2;
                }
                case 2: {
                    int n3 = oracleXMLSave.updateXML(reader);
                    return n3;
                }
                case 3: {
                    int n4 = oracleXMLSave.deleteXML(reader);
                    return n4;
                }
            }
            int n5 = 0;
            return n5;
        }
        catch (OracleXMLSQLException oracleXMLSQLException) {
            errCode = oracleXMLSQLException.getErrorCode();
            errMsg = oracleXMLSQLException.getMessage();
            Exception exception = oracleXMLSQLException.getParentException();
            throw propagateOriginalException && exception != null ? exception : oracleXMLSQLException;
        }
        finally {
            if (oracleXMLSave != null) {
                oracleXMLSave.close();
            }
        }
    }

    public static int insertXML(String string, String string2) throws Exception {
        return OracleXMLStore.saveXML(string, string2, 1);
    }

    public static int insertXML(String string, CLOB cLOB) throws Exception {
        return OracleXMLStore.saveXML(string, cLOB, 1);
    }

    public static int updateXML(String string, String string2) throws Exception {
        return OracleXMLStore.saveXML(string, string2, 2);
    }

    public static int updateXML(String string, CLOB cLOB) throws Exception {
        return OracleXMLStore.saveXML(string, cLOB, 2);
    }

    public static int deleteXML(String string, String string2) throws Exception {
        return OracleXMLStore.saveXML(string, string2, 3);
    }

    public static int deleteXML(String string, CLOB cLOB) throws Exception {
        return OracleXMLStore.saveXML(string, cLOB, 3);
    }

    public static void setRowsetTag(String string) {
        rowSetTag = string;
    }

    public static void setRowTag(String string) {
        rowTag = string;
    }

    public static void setRowIdAttrName(String string) {
        rowIdAttr = string;
    }

    public static void setRowIdColumn(String string) {
        rowIdCol = string;
    }

    public static void setCollIdAttr(String string) {
        collIdAttr = string;
    }

    public static void setRaiseException(int n) {
        raiseException = n != 0;
    }

    public static void useNullAttributeIndicator(int n) {
        nullAttrInd = n != 0;
    }

    public static void propagateOriginalException(int n) {
        propagateOriginalException = n != 0;
    }

    public static void getExceptionContent(int[] nArray, String[] stringArray) {
        nArray[0] = errCode;
        stringArray[0] = errMsg;
    }

    public static void setStylesheetHeader(String string) {
        styleSheet = string;
    }

    public static void setStylesheetHeaderType(String string) {
        styleSheetType = string;
    }

    public static void useLowerCaseTagNames() {
        tagcase = 1;
    }

    public static void useUpperCaseTagNames() {
        tagcase = 2;
    }

    public static void useDefaultCaseTagNames() {
        tagcase = 3;
    }

    public static void ignoreTagCase(int n) {
        ignoreCase = n != 0;
    }

    public static void setErrorTag(String string) {
        errorTag = string;
    }

    public static void setMaxRows(int n) {
        maxRows = n >= 0 ? n : -1;
    }

    public static void setSkipRows(int n) {
        skipRows = n >= 0 ? n : -1;
    }

    public static void setDateFormat(String string) {
        dateFormat = string;
    }

    public static void setQueryDateFormat(String string) {
        queryDateFormat = string;
        updateQueryDateFormat = true;
    }

    public static void setBatchSize(int n) {
        batchSize = n;
    }

    public static void setCommitBatch(int n) {
        cmtBatch = n;
    }

    public static void setMetaHeader(Reader reader) throws Exception {
        metaHeader = reader == null ? null : reader;
    }

    public static void setDataHeader(Reader reader, String string) throws Exception {
        if (reader == null) {
            dataHeader = null;
        } else {
            dataHeader = reader;
            docTag = string;
        }
    }

    public static void setMetaHeader(CLOB cLOB) throws Exception {
        metaHeader = cLOB == null ? null : cLOB.getCharacterStream();
    }

    public static void setDataHeader(CLOB cLOB, String string) throws Exception {
        if (cLOB == null) {
            dataHeader = null;
        } else {
            dataHeader = cLOB.getCharacterStream();
            docTag = string;
        }
    }

    public static void setLobDuration(String string) {
        if (string == null) {
            return;
        }
        lobDuration = string;
    }

    public static void setEncodingTag(String string) {
        if (string != null && string.compareTo(DBENCODING) == 0) {
            if (connEnc == null) {
                connEnc = System.getProperty("file.encoding");
                try {
                    connEnc = LocaleMapper.getIANACharacterSet((int)3, (String)connEnc);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                    connEnc = XSULocale.getIANACharset(connEnc);
                }
            }
            encTag = connEnc;
        } else {
            encTag = string;
        }
    }

    public static void resetOptions() {
        maxRows = -1;
        skipRows = 0;
        rowSetTag = "ROWSET";
        rowTag = "ROW";
        rowIdCol = null;
        rowIdAttr = "num";
        errorTag = "ERROR";
        encTag = null;
        tagcase = 3;
        styleSheet = null;
        ignoreCase = false;
        dateFormat = "MM/dd/yyyy HH:mm:ss";
        queryDateFormat = null;
        updateQueryDateFormat = false;
        OracleXMLStore.clearBindValues();
        dataHeader = null;
        metaHeader = null;
        docType = 1;
        lobDuration = "DBMS_LOB.SESSION";
        errCode = 0;
        errMsg = null;
    }

    static {
        connEnc = null;
        encTag = null;
        maxRows = -1;
        skipRows = 0;
        rowSetTag = "ROWSET";
        rowTag = "ROW";
        rowIdCol = null;
        rowIdAttr = "num";
        errorTag = "ERROR";
        tagcase = 3;
        styleSheet = null;
        styleSheetType = null;
        nullAttrInd = false;
        collIdAttr = null;
        raiseException = false;
        propagateOriginalException = false;
        errCode = 0;
        errMsg = null;
        bindNames = null;
        bindValues = null;
        metaHeader = null;
        dataHeader = null;
        docTag = "DOCUMENT";
        docType = 1;
        queryDateFormat = null;
        updateQueryDateFormat = false;
        dateFormat = "MM/dd/yyyy HH:mm:ss";
        ignoreCase = false;
        batchSize = -1;
        cmtBatch = -1;
        lobDuration = "DBMS_LOB.SESSION";
        updColList = null;
        keyColList = null;
    }
}

