/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.testObjects;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.testObjects.ObjectUpdateException;
import oracle.dbtools.unit_test.utils.UtUtils;

public class UtLookup {
    private String _id;
    private String _category;
    private String _datatype;
    private String _value;
    private boolean _dirty = false;

    public String getId() {
        return this._id;
    }

    public void setId(String string) {
        this._dirty = true;
        this._id = string;
    }

    public String getCategory() {
        return this._category;
    }

    public void setCategory(String string) {
        this._dirty = true;
        this._category = string;
    }

    public String getDatatype() {
        return this._datatype;
    }

    public void setDatatype(String string) {
        this._dirty = true;
        this._datatype = string;
    }

    public String getValue() {
        return this._value;
    }

    public void setValue(String string) {
        this._dirty = true;
        this._value = string;
    }

    public UtLookup(String string, String string2, String string3, String string4) {
        this._id = string;
        this._category = string2;
        this._datatype = string3;
        this._value = string4;
    }

    public boolean save(boolean bl) throws ObjectUpdateException {
        if (!bl && !this._dirty) {
            return true;
        }
        boolean bl2 = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            Savepoint savepoint = null;
            try {
                savepoint = connection.setSavepoint();
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                String string = UtUtils.getQuery("mergeCategory");
                hashMap.put("LU_ID", this._id);
                hashMap.put("CATEGORY", this._category);
                hashMap.put("DATATYPE", this._datatype);
                hashMap.put("VALUE", this._value);
                dBUtil.setRaiseError(true);
                int n = dBUtil.executeUpdate(string, hashMap);
                if (0 == n) {
                    connection.rollback(savepoint);
                    throw new ObjectUpdateException();
                }
                bl2 = n > 0;
                this._dirty = false;
                connection.commit();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                if (savepoint != null) {
                    try {
                        connection.rollback(savepoint);
                    }
                    catch (SQLException sQLException2) {
                        Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException2.getStackTrace()[0].toString(), sQLException2);
                    }
                }
                throw new ObjectUpdateException(sQLException);
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
        return bl2;
    }
}

