/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.runner;

import java.sql.Connection;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtRepositoryManager;
import oracle.dbtools.unit_test.runner.Runner;
import oracle.dbtools.unit_test.runner.StatusObject;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.testObjects.UtTest;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.IdeRunner;
import oracle.ide.IdeStarter;

public class UnitTestRunner
extends IdeRunner {
    String repo = null;
    String db = null;
    String runable = null;
    String type = null;
    String log = null;

    public void runCommand(IdeStarter ideStarter) {
        System.err.println("UnitTestRunner is no longer active. Please use the ututil batch file or shell scripts locatated in the Sql developer bin directory.");
    }

    public void processArgs(String[] stringArray) throws Exception {
        int n = 0;
        while (n < stringArray.length && stringArray[n].startsWith("-")) {
            String string;
            if ((string = stringArray[n++]).equals("-suiteId")) {
                this.type = "suiteId";
                if (n < stringArray.length) {
                    this.runable = stringArray[n++];
                } else {
                    System.err.println(string + " requires a suite id");
                }
            }
            if (string.equals("-testId")) {
                this.type = "testId";
                if (n < stringArray.length) {
                    this.runable = stringArray[n++];
                } else {
                    System.err.println(string + " requires a test id");
                }
            }
            if (string.equals("-testName")) {
                this.type = "testName";
                if (n < stringArray.length) {
                    this.runable = stringArray[n++];
                } else {
                    System.err.println(string + " requires a test name");
                }
            }
            if (string.equals("-suiteName")) {
                this.type = "suiteName";
                if (n < stringArray.length) {
                    this.runable = stringArray[n++];
                } else {
                    System.err.println(string + " requires a suite name");
                }
            }
            if (string.equals("-repo")) {
                if (n < stringArray.length) {
                    this.repo = stringArray[n++];
                } else {
                    System.err.println(string + " requires a connection name for the repository");
                }
            }
            if (string.equals("-db")) {
                if (n < stringArray.length) {
                    this.db = stringArray[n++];
                } else {
                    System.err.println(string + " requires a connection name for DB to run test on");
                }
            }
            if (!string.equals("-log")) continue;
            if (n < stringArray.length) {
                this.log = stringArray[n++];
                continue;
            }
            System.err.println(string + " no logging value was passed uNone");
        }
        if (this.repo == null || this.db == null || this.runable == null) {
            UnitTestRunner.usage();
            System.exit(0);
        }
    }

    public static void usage() {
        System.err.println("");
        System.err.println("RunUnitTest -testId <test id> -repo <connection name> -db <connection name> {-log <0=None,1=status,2=status/message>}");
        System.err.println("RunUnitTest -suiteId <suite id> -repo <connection name> -db <connection name> {-log <0=None,1=status,2=status/message>}");
        System.err.println("RunUnitTest -testName <test name> -repo <connection name> -db <connection name> {-log <0=None,1=status,2=status/message>}");
        System.err.println("RunUnitTest -suiteName <suite name> -repo <connection name> -db <connection name> {-log <0=None,1=status,2=status/message>}");
        System.err.println("");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() {
        UtRepositoryManager utRepositoryManager = UtAddin.getRepositoryManager();
        String string = Connections.ConnectionKey.createConnectionKey((String)"IdeConnections", (String)this.repo).getQualifiedName();
        StatusObject statusObject = null;
        boolean bl = utRepositoryManager.openConnectionWithChecks(string);
        if (!bl) {
            System.err.println("Unable to open repository");
            System.exit(1);
        } else {
            try {
                String string2 = Connections.ConnectionKey.createConnectionKey((String)"IdeConnections", (String)this.db).getQualifiedName();
                Connection connection = UtUtils.getRunnerConnection(string2);
                if (connection == null) {
                    System.err.println("Unable to create runner");
                    System.exit(1);
                }
                Runner runner = new Runner(connection);
                if (this.type.equals("suiteId")) {
                    statusObject = runner.executeSuiteCMD(new UtSuite(this.runable), null, true, true);
                } else if (this.type.equals("testId")) {
                    statusObject = runner.executeTestCMD(new UtTest(this.runable), null, true, true);
                } else if (this.type.equals("suiteName")) {
                    String string3 = UtUtils.getSuiteId(this.runable);
                    if (string3 == null) {
                        System.err.println("Could not find suite unable to run.");
                        System.exit(1);
                    }
                    statusObject = runner.executeSuiteCMD(new UtSuite(string3), null, true, true);
                } else if (this.type.equals("testName")) {
                    String string4 = UtUtils.getTestId(this.runable);
                    if (string4 == null) {
                        System.err.println("Could not find test unable to run.");
                        System.exit(1);
                    }
                    statusObject = runner.executeTestCMD(new UtTest(string4), null, true, true);
                }
            }
            finally {
                if (this.log == null || this.log.equals("0")) {
                    System.exit(0);
                } else if (this.log.equals("2")) {
                    System.out.println(statusObject.getStatus());
                    System.out.println(statusObject.getMessage());
                    System.exit(0);
                } else if (this.log.equals("1")) {
                    System.out.println(statusObject.getStatus());
                    System.exit(0);
                }
            }
        }
    }
}

