/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.runner;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.runner.Utilities;
import oracle.jdbc.OraclePreparedStatement;

public class CoverageManager {
    private Connection _testConnection;
    private long _runNumber;
    private String _errorText;

    public CoverageManager(Connection connection) {
        this._testConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean profilerInstalled() {
        boolean bl = false;
        try {
            String string = "select count(*) from all_objects where object_name = 'DBMS_PROFILER'";
            PreparedStatement preparedStatement = this._testConnection.prepareStatement(string);
            try {
                ResultSet resultSet = preparedStatement.executeQuery();
                resultSet.next();
                bl = resultSet.getInt(1) != 0;
            }
            finally {
                preparedStatement.close();
            }
        }
        catch (SQLException sQLException) {
            this._errorText = sQLException.getLocalizedMessage();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCoverage() {
        try {
            String string = Utilities.getQuery("startCoverage");
            CallableStatement callableStatement = this._testConnection.prepareCall(string);
            try {
                callableStatement.registerOutParameter(1, 2);
                callableStatement.execute();
                this._runNumber = callableStatement.getLong(1);
            }
            finally {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {
            this._errorText = sQLException.getLocalizedMessage();
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopCoverage() {
        try {
            String string = Utilities.getQuery("stopCoverage");
            CallableStatement callableStatement = this._testConnection.prepareCall(string);
            try {
                callableStatement.execute();
            }
            finally {
                callableStatement.close();
            }
        }
        catch (SQLException sQLException) {
            if (this._errorText == null) {
                this._errorText = sQLException.getLocalizedMessage();
            }
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectStats(String string, String string2) {
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            try {
                String string3 = Utilities.getQuery("addCoverageStats");
                OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string3);
                try {
                    if (this._errorText != null) {
                        oraclePreparedStatement.setStringAtName("UTC_ID", UUID.randomUUID().toString());
                        oraclePreparedStatement.setStringAtName("UTIR_ID", string2);
                        oraclePreparedStatement.setStringAtName("UTI_ID", string);
                        oraclePreparedStatement.setStringAtName("UNIT_OWNER", "");
                        oraclePreparedStatement.setStringAtName("UNIT_NAME", "");
                        oraclePreparedStatement.setIntAtName("LINE", -1);
                        oraclePreparedStatement.setIntAtName("TOTAL_OCCUR", -1);
                        oraclePreparedStatement.setIntAtName("TOTAL_TIME", -1);
                        oraclePreparedStatement.setStringAtName("TEXT", this._errorText);
                        oraclePreparedStatement.addBatch();
                    }
                    DBUtil dBUtil = DBUtil.getInstance((Connection)this._testConnection);
                    dBUtil.setRaiseError(false);
                    String string4 = Utilities.getQuery("coverageRunStats");
                    OraclePreparedStatement oraclePreparedStatement2 = (OraclePreparedStatement)this._testConnection.prepareStatement(string4);
                    oraclePreparedStatement2.setStringAtName("RUNID", Long.toString(this._runNumber));
                    ResultSet resultSet = oraclePreparedStatement2.executeQuery();
                    while (resultSet.next()) {
                        String string5 = resultSet.getString("OWNER");
                        String string6 = resultSet.getString("NAME");
                        String string7 = resultSet.getString("LINE");
                        String string8 = resultSet.getString("TOTAL_OCCUR");
                        String string9 = resultSet.getString("TOTAL_TIME");
                        String string10 = resultSet.getString("TEXT");
                        oraclePreparedStatement.setStringAtName("UTC_ID", UUID.randomUUID().toString());
                        oraclePreparedStatement.setStringAtName("UTIR_ID", string2);
                        oraclePreparedStatement.setStringAtName("UTI_ID", string);
                        oraclePreparedStatement.setStringAtName("UNIT_OWNER", string5);
                        oraclePreparedStatement.setStringAtName("UNIT_NAME", string6);
                        oraclePreparedStatement.setStringAtName("LINE", string7);
                        oraclePreparedStatement.setStringAtName("TOTAL_OCCUR", string8);
                        oraclePreparedStatement.setStringAtName("TOTAL_TIME", string9);
                        oraclePreparedStatement.setStringAtName("TEXT", string10);
                        oraclePreparedStatement.addBatch();
                    }
                    oraclePreparedStatement.executeBatch();
                }
                finally {
                    oraclePreparedStatement.close();
                }
                connection.commit();
            }
            catch (SQLException sQLException) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException.getStackTrace()[0].toString(), sQLException);
                try {
                    connection.rollback();
                }
                catch (SQLException sQLException2) {
                    Logger.getLogger(this.getClass().getName()).log(Level.WARNING, sQLException2.getStackTrace()[0].toString(), sQLException2);
                }
            }
            finally {
                Connections.getInstance().unlock(connection);
            }
        }
    }
}

