/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.repository;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.db.ConnectionResolver;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.utils.UtUtils;

public final class RepositoryManager {
    protected static final Logger LOGGER = Logger.getLogger(RepositoryManager.class.getName());
    public static final int REPO_VERSION = 20;
    private static LinkedList<String> repos = new LinkedList();

    protected static void warn(Throwable throwable) {
        String string = throwable.getMessage() + " - " + throwable.getStackTrace()[0].toString();
        LOGGER.log(Level.WARNING, string, throwable);
    }

    public void installRepository(Connection connection) throws IOException {
        boolean bl = UtUtils.isLocalRepos();
        if (!RepositoryManager.doesRepositoryExist(connection) || !bl) {
            URL uRL = this.getClass().getResource("20/create20.sql");
            this.runUrl(uRL, connection, false);
        } else if (bl && RepositoryManager.getCurentRepoVersion(connection) < 20) {
            String string = String.valueOf(RepositoryManager.getCurentRepoVersion(connection));
            int n = repos.indexOf(string);
            ListIterator<String> listIterator = repos.listIterator(n + 1);
            while (listIterator.hasNext()) {
                String string2 = listIterator.next();
                URL uRL = this.getClass().getResource(string2 + "/update" + string2 + ".sql");
                this.runUrl(uRL, connection, true);
            }
        } else {
            throw new IOException(UtAddinArb.getString("NO_ACTION"));
        }
    }

    public void dropRepository(Connection connection) throws IOException {
        if (RepositoryManager.doesRepositoryExist(connection)) {
            int n = RepositoryManager.getCurentRepoVersion(connection);
            URL uRL = this.getClass().getResource("20/drop" + String.valueOf(n) + ".sql");
            if (uRL == null) {
                Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "Unable to load drop repository resource for version " + n);
                uRL = this.getClass().getResource("20/drop20.sql");
            }
            this.runUrl(uRL, connection, true);
        }
    }

    public void purgeRepository(Connection connection) throws IOException {
        if (RepositoryManager.doesRepositoryExist(connection)) {
            URL uRL = this.getClass().getResource("20/purge" + String.valueOf(RepositoryManager.getCurentRepoVersion(connection)) + ".sql");
            this.runUrl(uRL, connection, false);
        }
    }

    public void dropSynonyms(Connection connection) throws IOException {
        if (RepositoryManager.doesRepositoryExist(connection)) {
            URL uRL = this.getClass().getResource("20/dropSynonyms" + String.valueOf(RepositoryManager.getCurentRepoVersion(connection)) + ".sql");
            this.runUrl(uRL, connection, true);
        }
    }

    public void createSynonyms(Connection connection) throws IOException {
        if (RepositoryManager.doesRepositoryExist(connection)) {
            URL uRL = this.getClass().getResource("20/createSynonyms" + String.valueOf(RepositoryManager.getCurentRepoVersion(connection)) + ".sql");
            this.runUrl(uRL, connection, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesRepositoryExist(Connection connection) {
        boolean bl;
        block11: {
            bl = false;
            if (connection != null) {
                try {
                    if (Connections.getInstance().lock(connection)) {
                        ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
                        if (connectionResolver == null) {
                            DBUtil.setConnectionResolver((ConnectionResolver)Connections.getInstance());
                        }
                        try {
                            PreparedStatement preparedStatement = connection.prepareStatement("select value from ut_metadata where name = 'VERSION' and (exists (select null from user_tables where table_name = 'UT_METADATA') or exists (select null from all_synonyms where owner = 'PUBLIC' and table_name = 'UT_METADATA'))");
                            try {
                                ResultSet resultSet = preparedStatement.executeQuery();
                                bl = resultSet.next();
                                break block11;
                            }
                            finally {
                                preparedStatement.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            RepositoryManager.warn(sQLException);
                        }
                        break block11;
                    }
                    bl = false;
                }
                finally {
                    Connections.getInstance().unlock(connection);
                }
            }
        }
        return bl;
    }

    public static boolean upgradeRepository(Connection connection) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCurentRepoVersion(Connection connection) {
        int n = -99;
        if (!RepositoryManager.doesRepositoryExist(connection)) {
            return -99;
        }
        try {
            if (Connections.getInstance().lock(connection)) {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                ConnectionResolver connectionResolver = DBUtil.getConnectionResolver();
                if (connectionResolver == null) {
                    DBUtil.setConnectionResolver((ConnectionResolver)Connections.getInstance());
                }
                dBUtil.setRaiseError(false);
                String string = dBUtil.executeOracleReturnOneCol("select value from ut_metadata where name = 'VERSION'", null);
                try {
                    n = Integer.valueOf(string);
                }
                catch (Exception exception) {
                    RepositoryManager.warn(exception);
                }
            }
        }
        finally {
            Connections.getInstance().unlock(connection);
        }
        return n;
    }

    public static boolean isCurrentVersion(Connection connection) {
        return RepositoryManager.getCurentRepoVersion(connection) == 20;
    }

    public static boolean hasReqPrivs(Connection connection) {
        String[] stringArray = new String[]{"TABLE", "VIEW", "SEQUENCE", "PROCEDURE", "TYPE"};
        String[] stringArray2 = RepositoryManager.getUserPrivileges(connection);
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].contains(stringArray[i])) continue;
                bl = true;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getUserPrivileges(Connection connection) {
        if (connection == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap hashMap = new HashMap();
        Statement statement = null;
        ResultSet resultSet = null;
        String string = "select PRIVILEGE from role_sys_privs where role in (select role from session_roles)UNION select PRIVILEGE from user_sys_privs";
        try {
            hashMap.clear();
            statement = DBUtil.getInstance((Connection)connection).prepareExecute(string, hashMap);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                arrayList.add(resultSet.getString("PRIVILEGE"));
            }
        }
        catch (SQLException sQLException) {
            RepositoryManager.warn(sQLException);
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public void runUrl(URL uRL, Connection connection, boolean bl) throws IOException {
        if (uRL == null) {
            throw new IOException(UtAddinArb.getString("NO_RESOURCE"));
        }
        ScriptRunnerContext scriptRunnerContext = new ScriptRunnerContext();
        scriptRunnerContext.setTopLevel(true);
        scriptRunnerContext.setLastUrl(uRL);
        if (bl) {
            scriptRunnerContext.setSqlError(1);
        } else {
            scriptRunnerContext.setSqlError(6);
        }
        scriptRunnerContext.setOsError(6);
        BufferedOutputStream bufferedOutputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        byteArrayOutputStream = new ByteArrayOutputStream();
        bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
        ScriptExecutor scriptExecutor = new ScriptExecutor(uRL, connection);
        scriptExecutor.setScriptRunnerContext(scriptRunnerContext);
        scriptExecutor.setOut(bufferedOutputStream);
        scriptExecutor.setName("Unit Test Repository Manager Thread");
        scriptExecutor.run();
        if (scriptRunnerContext.getProperty("sqldev.error").equals(Boolean.TRUE)) {
            String string = (String)scriptRunnerContext.getProperty("sqldev.last.err.message");
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, string);
            if (!bl) {
                if (string == null) {
                    throw new IOException("SQLException");
                }
                throw new IOException(string);
            }
        }
    }

    static {
        repos.add("10");
        repos.add("20");
    }
}

