/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.manage_objects;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.unit_test.manage_objects.ManageObjectsArb;
import oracle.dbtools.unit_test.manage_objects.SyncTestWizPanel;
import oracle.dbtools.unit_test.testObjects.UpgradeController;
import oracle.ide.panels.TraversableContext;

class SyncTestWizSummary
extends SyncTestWizPanel {
    private JTextArea _summary;
    private static final String _paraSep = "\n-----------------------------------------------------------------";

    @Override
    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        UpgradeController upgradeController = this.getWizContext().getUpgradeController();
        if (this._summary == null) {
            this.initUI();
        }
        this._summary.setText(this.getSummaryText(upgradeController));
    }

    public Object getExitTransition() {
        return null;
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        JScrollPane jScrollPane = new JScrollPane();
        this._summary = new JTextArea();
        this._summary.setEditable(false);
        jScrollPane.setViewportView(this._summary);
        this.add(jScrollPane, new GridBagConstraints(0, 0, 5, 5, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    private String getSummaryText(UpgradeController upgradeController) {
        TreeSet<String> treeSet;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(ManageObjectsArb.getString("SYNC_NOTICE"));
        stringBuffer.append(_paraSep);
        stringBuffer.append('\n');
        stringBuffer.append(ManageObjectsArb.getString("CURRENT_SIG_NOTICE"));
        stringBuffer.append('\n');
        stringBuffer.append(this.formatSignature(upgradeController.getTest().getTestCall()));
        stringBuffer.append(_paraSep);
        stringBuffer.append('\n');
        stringBuffer.append(ManageObjectsArb.getString("NEW_SIG_NOTICE"));
        stringBuffer.append('\n');
        stringBuffer.append(this.formatSignature(upgradeController.getNewTest().getTestCall()));
        stringBuffer.append(_paraSep);
        stringBuffer.append('\n');
        stringBuffer.append(ManageObjectsArb.getString("TEST_MODIFIED_NOTICE"));
        int n = 1;
        if (upgradeController.hasObjectOwnerChanged()) {
            stringBuffer.append("\n         ");
            stringBuffer.append(n++);
            stringBuffer.append(". ");
            stringBuffer.append(ManageObjectsArb.getString("OWNER_CHANGED_NOTICE"));
        }
        if (upgradeController.hasObjectNameChanged()) {
            stringBuffer.append("\n         ");
            stringBuffer.append(n++);
            stringBuffer.append(". ");
            stringBuffer.append(ManageObjectsArb.getString("OBJECT_NAME_CHANGED_NOTICE"));
        }
        if (upgradeController.hasSourceConnectionChanged()) {
            stringBuffer.append("\n         ");
            stringBuffer.append(n++);
            stringBuffer.append(". ");
            stringBuffer.append(ManageObjectsArb.getString("SOURCE_CONN_CHANGED_NOTICE"));
        }
        Collection<String> collection = upgradeController.getChangedOrDeletedArgNames();
        Collection<String> collection2 = upgradeController.getNewArgNames();
        if (collection.size() != 0) {
            stringBuffer.append("\n         ");
            stringBuffer.append(n++);
            stringBuffer.append(". ");
            stringBuffer.append(ManageObjectsArb.getString("ARG_INFO_DELETED_NOTICE"));
            treeSet = new TreeSet<String>(collection);
            for (String string : treeSet) {
                stringBuffer.append("\n               ");
                stringBuffer.append(string);
            }
        }
        if (collection2.size() != 0) {
            stringBuffer.append("\n         ");
            stringBuffer.append(n++);
            stringBuffer.append(". ");
            stringBuffer.append(ManageObjectsArb.getString("ARG_INFO_ADDED_NOTICE"));
            treeSet = new TreeSet<String>(collection2);
            for (String string : treeSet) {
                stringBuffer.append("\n               ");
                stringBuffer.append(string);
            }
        }
        stringBuffer.append(_paraSep);
        return stringBuffer.toString();
    }

    private String formatSignature(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        stringBuffer.append("         ");
        if (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            stringBuffer.append("\n               ");
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(stringTokenizer.nextToken());
        }
        return stringBuffer.toString();
    }
}

