/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.manage_objects;

import java.net.URL;
import oracle.dbtools.raptor.navigator.impl.ChildObjectElement;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.model.Element;

public class PLSQLOperation {
    private String _schema;
    private String _packageName;
    private String _operationName;
    private boolean _function;
    private String _signature;
    private String _overload;

    public PLSQLOperation(DBObject dBObject) {
        String string = dBObject.getObjectType();
        if (string.equals("MEMBER")) {
            Element element = dBObject.getElement();
            ChildObjectElement childObjectElement = null;
            if (!(element instanceof ChildObjectElement)) {
                return;
            }
            childObjectElement = (ChildObjectElement)element;
            String string2 = (String)childObjectElement.getProperty("NAME");
            this._operationName = UtUtils.getCanonicalizedName(string2);
            if (childObjectElement.getProperty("OVERLOAD") != null) {
                this._overload = Integer.toString((Integer)childObjectElement.getProperty("OVERLOAD"));
            }
            URL uRL = dBObject.getURL();
            this._packageName = DBURLFormatHelper.getName((URL)uRL);
            this._schema = DBURLFormatHelper.getSchema((URL)uRL);
            string = (String)childObjectElement.getProperty("MEMBER_TYPE");
        } else if (string.equals("FUNCTION") || string.equals("PROCEDURE")) {
            this._operationName = dBObject.getObjectName();
            this._schema = dBObject.getSchemaName();
        } else {
            throw new IllegalArgumentException();
        }
        this._signature = null;
        this._function = string.equals("FUNCTION");
    }

    public PLSQLOperation(String string, String string2, String string3, boolean bl, String string4, String string5) {
        this._schema = string;
        this._packageName = string2;
        this._operationName = string3;
        this._function = bl;
        this._signature = string4;
        this._overload = string5;
    }

    public String getSchema() {
        return this._schema;
    }

    public String getPackage() {
        return this._packageName;
    }

    public String getOperation() {
        return this._operationName;
    }

    public boolean isFunction() {
        return this._function;
    }

    public String getSignature() {
        return this._signature;
    }

    public String getQualifiedSignature() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this._schema);
        stringBuffer.append('.');
        if (this._packageName != null) {
            stringBuffer.append(this._packageName);
            stringBuffer.append('.');
        }
        stringBuffer.append(this._signature);
        return stringBuffer.toString();
    }

    public String getOverload() {
        return this._overload;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PLSQLOperation)) {
            return false;
        }
        PLSQLOperation pLSQLOperation = (PLSQLOperation)object;
        return this.sameString(this._schema, pLSQLOperation._schema) && this.sameString(this._packageName, pLSQLOperation._packageName) && this.sameString(this._operationName, pLSQLOperation._operationName) && this._function == pLSQLOperation._function && this.sameString(this._overload, pLSQLOperation._overload);
    }

    private boolean sameString(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string == null || string2 == null) {
            return false;
        }
        return string.equals(string2);
    }
}

