/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.db.ResultSetWrapper;
import oracle.dbtools.raptor.controls.CustomTabbedPane;
import oracle.dbtools.raptor.utils.Connections;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.testObjects.UtSuite;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.ide.dialogs.OnePageWizardDialogFactory;
import oracle.ide.help.HelpSystem;

public class SuiteItemPickerDialog {
    private UtSuite _suite;
    private List<UtSuite.SuiteItem> _suiteTests = new ArrayList<UtSuite.SuiteItem>();
    private DefaultListModel _testNameList = new DefaultListModel();
    private Map<String, String> _testNameToIdMap = new HashMap<String, String>();
    private JCheckBox _testRunStart;
    private JCheckBox _testRunTear;
    private JList _testList;
    private List<UtSuite.SuiteItem> _nestedSuites = new ArrayList<UtSuite.SuiteItem>();
    private DefaultListModel _nestedSuiteNameList = new DefaultListModel();
    private Map<String, String> _nestedSuiteNameToIdMap = new HashMap<String, String>();
    private JCheckBox _nestedSuiteRunStart;
    private JCheckBox _nestedSuiteRunTear;
    private JList _nestedSuiteList;

    public boolean runDialog(String string, Tabs tabs) {
        if (null == string) {
            throw new NullPointerException("Programmer Error: suiteId must not be null.");
        }
        this._suite = new UtSuite(string);
        this.initModel();
        return this.runDialog(this.getPanel(tabs), tabs);
    }

    public List<UtSuite.SuiteItem> getSuiteItems() {
        ArrayList<UtSuite.SuiteItem> arrayList = new ArrayList<UtSuite.SuiteItem>();
        arrayList.addAll(this._suiteTests);
        arrayList.addAll(this._nestedSuites);
        return arrayList;
    }

    private JPanel getPanel(Tabs tabs) {
        CustomTabbedPane customTabbedPane = new CustomTabbedPane();
        if (tabs != Tabs.SUITES_ONLY) {
            customTabbedPane.addTab(null, UtAddinArb.getString("ADD_TEST_ITEM_TAB_NAME"), (Component)this.getTestPanel());
        }
        if (tabs != Tabs.TESTS_ONLY) {
            customTabbedPane.addTab(null, UtAddinArb.getString("ADD_NESTED_SUITE_ITEM_TAB_NAME"), (Component)this.getNestedSuitePanel());
        }
        return customTabbedPane;
    }

    private JPanel getTestPanel() {
        this._testRunStart = new JCheckBox(UtAddinArb.getString("RUN_STARTUP_LABEL"));
        this._testRunStart.setSelected(true);
        this._testRunTear = new JCheckBox(UtAddinArb.getString("RUN_TEARDOWN_LABEL"));
        this._testRunTear.setSelected(true);
        this._testList = new JList(this._testNameList);
        JScrollPane jScrollPane = new JScrollPane(this._testList);
        JPanel jPanel = new JPanel(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_add_suite_tests_dialog_html");
        jPanel.add((Component)this._testRunStart, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        jPanel.add((Component)this._testRunTear, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(1, 0, 2, 3, 1.0, 1.0, 17, 1, new Insets(1, 1, 0, 0), 0, 0));
        return jPanel;
    }

    private JPanel getNestedSuitePanel() {
        this._nestedSuiteRunStart = new JCheckBox(UtAddinArb.getString("RUN_STARTUP_LABEL"));
        this._nestedSuiteRunStart.setSelected(true);
        this._nestedSuiteRunTear = new JCheckBox(UtAddinArb.getString("RUN_TEARDOWN_LABEL"));
        this._nestedSuiteRunTear.setSelected(true);
        this._nestedSuiteList = new JList(this._nestedSuiteNameList);
        JScrollPane jScrollPane = new JScrollPane(this._nestedSuiteList);
        JPanel jPanel = new JPanel(new GridBagLayout());
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_add_suite_tests_dialog_html");
        jPanel.add((Component)this._nestedSuiteRunStart, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        jPanel.add((Component)this._nestedSuiteRunTear, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(1, 1, 0, 0), 0, 0));
        jPanel.add((Component)jScrollPane, new GridBagConstraints(1, 0, 2, 3, 1.0, 1.0, 17, 1, new Insets(1, 1, 0, 0), 0, 0));
        return jPanel;
    }

    private void initModel() {
        this.initTestsModel();
        this.initNestedSuitesModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTestsModel() {
        this._suiteTests.clear();
        this._testNameList.clear();
        this._testNameToIdMap.clear();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string = UtUtils.getQuery("listTests");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("ID", this._suite.getSid());
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        this._testNameList.addElement(resultSet.getString("NAME"));
                        this._testNameToIdMap.put(resultSet.getString("NAME"), resultSet.getString("UT_ID"));
                    }
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initNestedSuitesModel() {
        this._nestedSuites.clear();
        this._nestedSuiteNameList.clear();
        this._nestedSuiteNameToIdMap.clear();
        Connection connection = UtAddin.getRepositoryManager().getConnection();
        if (Connections.getInstance().lock(connection)) {
            ResultSetWrapper resultSetWrapper = null;
            try {
                DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
                dBUtil.setRaiseError(true);
                String string = UtUtils.getQuery("listSuites");
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("ID", this._suite.getSid());
                resultSetWrapper = dBUtil.executeOracleQuery(string, hashMap);
                if (resultSetWrapper != null) {
                    ResultSet resultSet = resultSetWrapper.getResultSet();
                    while (resultSet.next()) {
                        this._nestedSuiteNameList.addElement(resultSet.getString("NAME"));
                        this._nestedSuiteNameToIdMap.put(resultSet.getString("NAME"), resultSet.getString("UT_SID"));
                    }
                }
            }
            catch (SQLException sQLException) {
            }
            finally {
                if (resultSetWrapper != null) {
                    resultSetWrapper.close();
                }
                Connections.getInstance().unlock(connection);
            }
        }
    }

    private boolean runDialog(JPanel jPanel, Tabs tabs) {
        String string = UtAddinArb.getString("ADD_SUITE_ITEM_TITLE");
        HelpSystem.getHelpSystem().registerTopic((JComponent)jPanel, "f1_add_suite_tests_dialog_html");
        boolean bl = OnePageWizardDialogFactory.runDialog((Component)jPanel, (Component)jPanel, (String)string);
        if (bl) {
            String string2;
            String string3;
            boolean bl2;
            boolean bl3;
            if (tabs != Tabs.SUITES_ONLY) {
                bl3 = this._testRunStart.isSelected();
                bl2 = this._testRunTear.isSelected();
                for (Object object : this._testList.getSelectedValues()) {
                    string3 = (String)object;
                    string2 = this._testNameToIdMap.get(string3);
                    UtSuite utSuite = this._suite;
                    utSuite.getClass();
                    this._suiteTests.add(new UtSuite.SuiteItem(utSuite, string2, null, bl3, bl2));
                }
            }
            if (tabs != Tabs.TESTS_ONLY) {
                bl3 = this._nestedSuiteRunStart.isSelected();
                bl2 = this._nestedSuiteRunTear.isSelected();
                for (Object object : this._nestedSuiteList.getSelectedValues()) {
                    string3 = (String)object;
                    string2 = this._nestedSuiteNameToIdMap.get(string3);
                    UtSuite utSuite = this._suite;
                    utSuite.getClass();
                    this._nestedSuites.add(new UtSuite.SuiteItem(utSuite, null, string2, bl3, bl2));
                }
            }
        }
        return bl;
    }

    public static enum Tabs {
        BOTH,
        TESTS_ONLY,
        SUITES_ONLY;

    }
}

