/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.dbtools.unit_test.codehook.CodeHook;
import oracle.dbtools.unit_test.codehook.CodeHookLookup;
import oracle.dbtools.unit_test.codehook.ICodeHook;
import oracle.dbtools.unit_test.editor.CodeHookPanel;
import oracle.dbtools.unit_test.editor.ListTableModel;
import oracle.dbtools.unit_test.startup.IStartup;
import oracle.dbtools.unit_test.startup.StartupArb;
import oracle.javatools.icons.OracleIcons;

public class StartupListTableModel
extends ListTableModel<IStartup> {
    private static final int SELECTOR = 0;
    private static final int STARTUP = 1;
    private static final String[] COL_NAMES = new String[]{"", StartupArb.getString("STARTUP_LABEL")};
    private CodeHookLookup _lookup;
    private static Component DUMMY_RENDERER = new JLabel();

    public StartupListTableModel(CodeHookLookup codeHookLookup) {
        super(COL_NAMES, null);
        this._lookup = codeHookLookup;
    }

    @Override
    public void setTable(JTable jTable) {
        super.setTable(jTable);
        jTable.getColumnModel().getColumn(0).setMaxWidth(10);
        jTable.setDefaultEditor(CodeHook.class, new CodeHookCellEditor());
        jTable.setDefaultRenderer(CodeHook.class, new CodeHookCellRenderer());
        jTable.setSurrendersFocusOnKeystroke(true);
    }

    @Override
    protected Object getValueAt(IStartup iStartup, int n) {
        switch (n) {
            case 0: {
                return "";
            }
            case 1: {
                return iStartup;
            }
        }
        return null;
    }

    @Override
    protected boolean isCellEditable(IStartup iStartup, int n) {
        switch (n) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    protected void setValueAt(Object object, IStartup iStartup, int n) {
        block0 : switch (n) {
            case 1: {
                if (object.equals(iStartup)) break;
                IStartup iStartup2 = (IStartup)object;
                List list = this.getRowList();
                for (int i = 0; i < list.size(); ++i) {
                    IStartup iStartup3 = (IStartup)list.get(i);
                    if (!iStartup3.equals(iStartup)) continue;
                    list.set(i, iStartup2);
                    break block0;
                }
                break;
            }
        }
    }

    @Override
    public AbstractAction getRemoveSelectedAction() {
        final AbstractAction abstractAction = super.getRemoveSelectedAction();
        AbstractAction abstractAction2 = new AbstractAction("", OracleIcons.getIcon((String)"delete.png")){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = true;
                int n = StartupListTableModel.this.getSelectedRow();
                int n2 = StartupListTableModel.this.getSelectedRowCount();
                for (int i = 0; i < n2; ++i) {
                    int n3 = n + i;
                    Object object = StartupListTableModel.this.getValueAt(n3, 1);
                    if (!(object instanceof CodeHook)) continue;
                }
                if (bl) {
                    abstractAction.actionPerformed(actionEvent);
                }
            }

            @Override
            public boolean isEnabled() {
                return abstractAction.isEnabled();
            }
        };
        return abstractAction2;
    }

    class CodeHookCellRenderer
    implements TableCellRenderer {
        CodeHookCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Border border;
            if (null == object) {
                return DUMMY_RENDERER;
            }
            CodeHookPanel codeHookPanel = new CodeHookPanel((ICodeHook)object, StartupListTableModel.this._lookup);
            jTable.setRowHeight(n, codeHookPanel.getPreferredSize().height);
            codeHookPanel.setEditable(StartupListTableModel.this.isEditable());
            if (bl2 && (border = UIManager.getBorder("Table.focusCellHighlightBorder")) != null) {
                codeHookPanel.setBorder(border);
            }
            return codeHookPanel;
        }
    }

    class CodeHookCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        CodeHookPanel editor;

        CodeHookCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.editor = new CodeHookPanel((ICodeHook)object, StartupListTableModel.this._lookup);
            this.editor.setEditable(StartupListTableModel.this.isEditable());
            final JTable jTable2 = jTable;
            final int n3 = n;
            final int n4 = n2;
            this.editor.addPropertyChangeListener("CODE_HOOK", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    jTable2.getModel().setValueAt(CodeHookCellEditor.this.editor.getCodeHook(), n3, n4);
                }
            });
            return this.editor;
        }

        @Override
        public Object getCellEditorValue() {
            return this.editor == null ? null : this.editor.getCodeHook();
        }
    }
}

