/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test.config;

import java.util.HashMap;
import java.util.Map;
import oracle.dbtools.raptor.controls.celleditor.PairElement;
import oracle.ide.config.Preferences;
import oracle.ide.panels.TraversableContext;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public class UtConfig
extends HashStructureAdapter
implements Copyable {
    public static final String KEY = "UtConfig";
    public static final String LOOKUP_CATEGORY = "LOOKUP_CATEGORY";
    public static final String KEY_REPOSITORY = "Repository";
    private static final String EMPTY_REPOSITORY = "";
    private static Map<String, Object> s_defaults = new HashMap<String, Object>();

    private static Integer getIntegerDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof Integer ? (Integer)object : (object != null ? Integer.valueOf(Integer.parseInt(object.toString())) : null);
    }

    private static String getStringDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof String ? (String)object : (object != null ? object.toString() : null);
    }

    private Boolean getBooleanDefault(String string) {
        Object object = s_defaults.get(string);
        return object instanceof Boolean ? (Boolean)object : (object != null ? Boolean.valueOf(object.toString()) : null);
    }

    private UtConfig(HashStructure hashStructure) {
        super(hashStructure);
    }

    public static UtConfig getInstance(PropertyStorage propertyStorage) {
        return new UtConfig(UtConfig.findOrCreate((PropertyStorage)propertyStorage, (String)KEY));
    }

    public static UtConfig getInstance(TraversableContext traversableContext) {
        return UtConfig.getInstance(traversableContext.getPropertyStorage());
    }

    public static synchronized UtConfig getInstance() {
        Preferences preferences = Preferences.getPreferences();
        return UtConfig.getInstance((PropertyStorage)preferences);
    }

    public String getString(String string) {
        return this._hash.getString(string, UtConfig.getStringDefault(string));
    }

    public void setString(String string, String string2) {
        this._hash.putString(string, string2);
    }

    public int getInt(String string) {
        return this._hash.getInt(string, UtConfig.getIntegerDefault(string).intValue());
    }

    public void setInt(String string, int n) {
        this._hash.putInt(string, n);
    }

    public Boolean getBoolean(String string) {
        return this._hash.getBoolean(string, this.getBooleanDefault(string).booleanValue());
    }

    public void setBoolean(String string, boolean bl) {
        this._hash.putBoolean(string, bl);
    }

    public PairElement getPairElement(String string) {
        String string2 = this._hash.getString(string);
        if (string2 != null) {
            String[] stringArray = string2.split("\\|");
            return new PairElement(stringArray[0], stringArray[1]);
        }
        string2 = UtConfig.getStringDefault(string);
        if (string2 != null) {
            String[] stringArray = string2.split("\\|");
            return new PairElement(stringArray[0], stringArray[1]);
        }
        return null;
    }

    public void setPairElement(String string, PairElement pairElement) {
        this._hash.putString(string, pairElement.getID() + "|" + pairElement.getName());
    }

    public void clearBinds() {
        this._hash.clear();
    }

    public String getRepository() {
        return this._hash.getString(KEY_REPOSITORY, EMPTY_REPOSITORY);
    }

    public synchronized void setRepository(String string) {
        if (string != null) {
            this._hash.putString(KEY_REPOSITORY, string);
        }
    }

    public UtConfig() {
        super(HashStructure.newInstance());
    }

    public synchronized HashMap<String, Object> getAllParameters() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (String string : this._hash.keySet()) {
            hashMap.put(string, this._hash.getObject(string));
        }
        return hashMap;
    }

    public synchronized void setAllParameters(HashMap<String, Object> hashMap) {
        for (String string : hashMap.keySet()) {
            this._hash.putString(string, hashMap.get(string).toString());
        }
    }

    static {
        s_defaults.put(LOOKUP_CATEGORY, "AAbcAAbc123123abab|DEFAULT");
    }
}

