/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.dbtools.raptor.datatypes.LockableDataTypeConnectionProvider;
import oracle.dbtools.unit_test.UtAddin;
import oracle.dbtools.unit_test.utils.UtUtils;
import oracle.jdbc.OracleConnection;

public class UtDataTypeConnectionProvider
extends LockableDataTypeConnectionProvider<OracleConnection> {
    protected String dbQualName;
    public static final String DB_QUAL_NAME = "dbQualName";

    public UtDataTypeConnectionProvider() {
        super(OracleConnection.class);
    }

    public OracleConnection getDataTypeConnection() {
        OracleConnection oracleConnection = (OracleConnection)this.peekDataTypeConnection();
        if (oracleConnection == null) {
            oracleConnection = (OracleConnection)UtUtils.getDataConnection(this.dbQualName);
            if (null == oracleConnection) {
                if (this.dbQualName != null) {
                    this.setDataTypeConnectionQualName(null);
                }
            } else {
                this.setDataTypeConnectionQualName(UtUtils.getDbQualName((Connection)oracleConnection));
                this.setDataTypeConnection((Connection)oracleConnection);
            }
        }
        return oracleConnection;
    }

    public OracleConnection getValidDataTypeConnection() {
        OracleConnection oracleConnection = (OracleConnection)this.peekDataTypeConnection();
        try {
            if (oracleConnection == null || oracleConnection.isClosed()) {
                this.setDataTypeConnection(null);
                oracleConnection = this.getDataTypeConnection();
            }
        }
        catch (SQLException sQLException) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, sQLException.getLocalizedMessage(), sQLException);
        }
        return oracleConnection;
    }

    public String getDataTypeConnectionQualName() {
        return this.peekDataTypeConnectionQualName();
    }

    public String peekDataTypeConnectionQualName() {
        return this.dbQualName;
    }

    public void setDataTypeConnectionQualName(String string) {
        if (!this.areEqual(string, this.dbQualName)) {
            String string2 = this.dbQualName;
            this.dbQualName = string;
            this.firePropertyChange(DB_QUAL_NAME, string2, this.dbQualName);
            this.setDataTypeConnection(null);
        }
    }

    private boolean areEqual(Object object, Object object2) {
        if (null == object) {
            return null == object2;
        }
        return object.equals(object2);
    }

    public OracleConnection getNLSConnection() {
        return this.peekNLSConnection();
    }

    public OracleConnection peekNLSConnection() {
        return (OracleConnection)UtAddin.getRepositoryManager().getConnection();
    }

    public OracleConnection getValidNLSConnection() {
        return this.getNLSConnection();
    }
}

