/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.unit_test;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Window;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import oracle.bali.share.nls.StringUtils;
import oracle.dbtools.raptor.ConnectionArb;
import oracle.dbtools.raptor.dialogs.actions.XMLBasedObjectAction;
import oracle.dbtools.raptor.images.RaptorImage;
import oracle.dbtools.unit_test.UtAddinArb;
import oracle.dbtools.unit_test.UtController;
import oracle.dbtools.unit_test.UtDataTypeConnectionProvider;
import oracle.dbtools.unit_test.UtRepositoryManager;
import oracle.dbtools.unit_test.UtRepositoryStateListener;
import oracle.dbtools.unit_test.config.UtConfig;
import oracle.dbtools.unit_test.editor.UtEditor;
import oracle.dbtools.unit_test.editor.UtLibraryEditorAddin;
import oracle.dbtools.unit_test.editor.UtLookupEditorAddin;
import oracle.dbtools.unit_test.editor.UtSuiteEditorAddin;
import oracle.dbtools.unit_test.editor.UtTestEditorAddin;
import oracle.dbtools.unit_test.navigator.UtNavigatorContextMenu;
import oracle.dbtools.unit_test.navigator.UtNavigatorManager;
import oracle.dbtools.unit_test.navigator.nodes.RootFolder;
import oracle.dbtools.unit_test.net.UtUrlFileSystemHelper;
import oracle.dbtools.unit_test.net.UtUrlStreamHandler;
import oracle.dbtools.unit_test.repository.RepositoryManager;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.resource.IdeArb;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.SwingUtils;

public class UtAddin
implements Addin {
    private static UtRepositoryManager s_repositoryManager;
    private static UtDataTypeConnectionProvider s_datatypeConnectionProvider;
    private static UtConfig s_Config;
    private static ArrayList<UtRepositoryStateListener> s_repositoryListeners;
    private static UtNavigatorManager s_utNavMgr;
    public static final String UT_MENU_ID = "UtMenu";
    public static final String CREATE_REPO = "CreateUTRepository";
    public static final String DEFAULT_REPO = "DefaultUTRepository";
    public static final String UNSET_REPO = "UnsetUTRepository";
    public static final String DROP_REPO = "DropUTRepository";
    public static final String PURGE_RESULTS = "PurgeUTResults";
    public static final String PURGE_REPO = "PurgeUTRepository";
    public static final String SHOW_SHARED = "ShowShared";
    public static final String CREATE_SYNS = "CreateSynonyms";
    public static final String DROP_SYNS = "DropSynonyms";
    public static final String MANAGE_USERS = "ManageUsers";
    public static final String IMPORT_FILE = "ImportFile";
    public static final String CREATE_DEMO = "CreateDemo";
    public static final Icon rootIcon;
    public static final Icon suiteFolderIcon;
    public static final Icon reportFolderIcon;
    public static final Icon suiteNodeIcon;
    public static final Icon testFolderIcon;
    public static final Icon testNodeIcon;
    public static final Icon testEditorIcon;
    public static final Icon testImplIcon;
    public static final Icon libStartupTypesFolderIcon;
    public static final Icon libTeardownTypesFolderIcon;
    public static final Icon libValidationTypesFolderIcon;
    public static final Icon libStartupsFolderIcon;
    public static final Icon libTeardownsFolderIcon;
    public static final Icon libValidationsFolderIcon;
    public static final Icon libStartupIcon;
    public static final Icon libTeardownIcon;
    public static final Icon libValidationIcon;
    public static final Icon libraryFolderIcon;
    public static final Icon lookupFolderIcon;
    public static final Icon lookupNodeIcon;
    public static final String menuIcon = "unittestroot.png";
    public static final Icon libEditorIcon;
    public static final Icon navIcon;
    public static final Icon testParamIcon;
    public static final Icon suiteEditorIcon;
    public static final Icon lookupEditorIcon;

    public void initialize() {
        URLFileSystem.addURLStreamHandlerFactory((URLStreamHandlerFactory)new UtUrlStreamHandler());
        URLFileSystem.registerHelper((String)"sqldev.unit_test", (URLFileSystemHelper)new UtUrlFileSystemHelper());
        URLFileSystem.registerHelper((String)"sqldev.unit_test", (URLFileSystemHelper)new UtUrlFileSystemHelper());
        URLFileSystem.registerHelper((String)"sqldev.unit_test", (URLFileSystemHelper)new UtUrlFileSystemHelper());
        s_utNavMgr = new UtNavigatorManager();
        s_utNavMgr.addContextMenuListener(new UtNavigatorContextMenu(), null);
        s_utNavMgr.initialize();
        EditorManager.getEditorManager().registerDynamic((EditorAddin)new UtTestEditorAddin());
        EditorManager.getEditorManager().registerDynamic((EditorAddin)new UtSuiteEditorAddin());
        EditorManager.getEditorManager().registerDynamic((EditorAddin)new UtLibraryEditorAddin());
        EditorManager.getEditorManager().registerDynamic((EditorAddin)new UtLookupEditorAddin());
        String string = UtAddinArb.getString("UT_ACCELERATOR_CATEGORY");
        int n = Ide.findOrCreateCmdID((String)"UnitTestEditor.Pin");
        IdeAction.get((int)n, (String)string, (String)IdeArb.getString((int)28), null, null, (Icon)OracleIcons.getIcon((String)"pin.png"), null, (boolean)true);
        int n2 = Ide.findOrCreateCmdID((String)"UnitTestEditor.Refresh");
        IdeAction.get((int)n2, (String)string, (String)UtAddinArb.getString("REFRESH"), null, null, (Icon)OracleIcons.getIcon((String)"refresh.png"), null, (boolean)true);
        int n3 = Ide.findOrCreateCmdID((String)"UnitTestEditor.Run");
        IdeAction.get((int)n3, (String)string, (String)UtAddinArb.getString("RUN_TEST"), null, null, (Icon)OracleIcons.getIcon((String)"run.png"), null, (boolean)true);
        int n4 = Ide.findOrCreateCmdID((String)"UnitTestEditor.Debug");
        IdeAction.get((int)n4, (String)string, (String)UtAddinArb.getString("DEBUG_IMPL"), null, null, (Icon)OracleIcons.getIcon((String)"debug.png"), null, (boolean)true);
        int n5 = Ide.findOrCreateCmdID((String)"UnitTestEditor.Edit");
        IdeAction.get((int)n5, (String)string, (String)IdeArb.getString((int)79), null, null, (Icon)OracleIcons.getIcon((String)"edit.png"), null, (boolean)true);
        int n6 = Ide.findOrCreateCmdID((String)"UnitTestEditor.Commit");
        IdeAction.get((int)n6, (String)string, (String)ConnectionArb.getString((String)"RDEP_COMMIT"), null, null, (Icon)OracleIcons.getIcon((String)"commit.png"), null, (boolean)true);
        int n7 = Ide.findOrCreateCmdID((String)"UnitTestEditor.Rollback");
        IdeAction.get((int)n7, (String)string, (String)ConnectionArb.getString((String)"RDEP_ROLLBACK"), null, null, (Icon)OracleIcons.getIcon((String)"rollback.png"), null, (boolean)true);
        KeyStrokeContextRegistry keyStrokeContextRegistry = Ide.getKeyStrokeContextRegistry();
        keyStrokeContextRegistry.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "/oracle/dbtools/unit_test/editor/accelerators.xml");
        this.addUtMenu();
        XMLBasedObjectAction.registerPackage((String)"oracle.dbtools.unit_test.actions.xml");
        UtAddin.getRepositoryManager().initialize();
    }

    private void addUtMenu() {
        Menubar menubar;
        try {
            menubar = Ide.getMenubar();
            if (menubar == null) {
                throw new IllegalStateException("Menu is unavailable - cannot initialise");
            }
        }
        catch (NullPointerException nullPointerException) {
            throw new IllegalStateException("Ide is unavailable - cannot initialise");
        }
        UtController utController = new UtController();
        String string = UtAddinArb.getString("MENU_UT");
        JMenu jMenu = new JMenu(StringUtils.stripMnemonic((String)string));
        jMenu.setMnemonic(StringUtils.getMnemonicKeyCode((String)string));
        jMenu.setIcon(navIcon);
        JMenu jMenu2 = MenuManager.getJMenu((String)"Tools");
        menubar.add((Component)jMenu, jMenu2, MenuConstants.decrement((float)MenuConstants.SECTION_TOOLS_ADDINS));
        menubar.sortSectionByName(jMenu2, MenuConstants.decrement((float)MenuConstants.SECTION_TOOLS_ADDINS));
        string = UtAddinArb.getString("DEFAULT_REPO");
        JMenuItem jMenuItem = this.createMenuItem(menubar, utController, DEFAULT_REPO, StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string));
        menubar.add((Component)jMenuItem, jMenu, 1.0f);
        string = UtAddinArb.getString("UNSET_REPO");
        JMenuItem jMenuItem2 = this.createMenuItem(menubar, utController, UNSET_REPO, StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string));
        menubar.add((Component)jMenuItem2, jMenu, 1.0f);
        float f = MenuConstants.increment((float)1.0f);
        string = UtAddinArb.getString("PURGE_RESULTS");
        JMenuItem jMenuItem3 = this.createMenuItem(menubar, utController, PURGE_RESULTS, StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string));
        menubar.add((Component)jMenuItem3, jMenu, f);
        float f2 = MenuConstants.increment((float)f);
        string = UtAddinArb.getString("CREATE_REPO");
        JMenuItem jMenuItem4 = this.createMenuItem(menubar, utController, CREATE_REPO, StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string));
        menubar.add((Component)jMenuItem4, jMenu, f2);
        string = UtAddinArb.getString("DROP_REPO");
        JMenuItem jMenuItem5 = this.createMenuItem(menubar, utController, DROP_REPO, StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string));
        menubar.add((Component)jMenuItem5, jMenu, f2);
        string = UtAddinArb.getString("PURGE_REPO");
        JMenuItem jMenuItem6 = this.createMenuItem(menubar, utController, PURGE_REPO, StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string));
        menubar.add((Component)jMenuItem6, jMenu, f2);
        float f3 = MenuConstants.increment((float)f2);
        string = UtAddinArb.getString("IMPORT_FILE");
        JMenuItem jMenuItem7 = this.createMenuItem(menubar, utController, IMPORT_FILE, StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string));
        menubar.add((Component)jMenuItem7, jMenu, f3);
        float f4 = MenuConstants.increment((float)f3);
        string = UtAddinArb.getString("MANAGE_USERS");
        JMenuItem jMenuItem8 = this.createMenuItem(menubar, utController, MANAGE_USERS, StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string));
        menubar.add((Component)jMenuItem8, jMenu, f4);
        float f5 = MenuConstants.increment((float)f4);
        string = UtAddinArb.getString("SHOW_SHARED_REPO");
        JMenuItem jMenuItem9 = this.createMenuItem(menubar, utController, SHOW_SHARED, StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string));
        menubar.add((Component)jMenuItem9, jMenu, f5);
        string = UtAddinArb.getString("CREATE_SYNS");
        JMenuItem jMenuItem10 = this.createMenuItem(menubar, utController, CREATE_SYNS, StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string));
        menubar.add((Component)jMenuItem10, jMenu, f5);
        string = UtAddinArb.getString("DROP_SYNS");
        JMenuItem jMenuItem11 = this.createMenuItem(menubar, utController, DROP_SYNS, StringUtils.stripMnemonic((String)string), StringUtils.getMnemonicKeyCode((String)string));
        menubar.add((Component)jMenuItem11, jMenu, f5);
    }

    private JMenuItem createMenuItem(Menubar menubar, Controller controller, String string, String string2, int n) {
        int n2 = Ide.findOrCreateCmdID((String)string);
        IdeAction ideAction = IdeAction.get((int)n2, null, (String)StringUtils.stripMnemonic((String)string2), (String)IdeMainWindow.ACTION_CATEGORY_VIEW, (Integer)StringUtils.getMnemonicKeyCode((String)string2), null, null, (boolean)true);
        ideAction.addController(controller);
        JMenuItem jMenuItem = new JMenuItem((Action)ideAction);
        jMenuItem.setMnemonic(n);
        return jMenuItem;
    }

    public static UtNavigatorManager getNavigatorManager() {
        return s_utNavMgr;
    }

    public static void addRepositoryStateListener(UtRepositoryStateListener utRepositoryStateListener) {
        if (s_repositoryListeners == null) {
            s_repositoryListeners = new ArrayList();
        }
        s_repositoryListeners.add(utRepositoryStateListener);
    }

    public static UtRepositoryManager getRepositoryManager() {
        if (s_repositoryManager == null) {
            s_repositoryManager = new UtRepositoryManager();
        }
        return s_repositoryManager;
    }

    public static UtDataTypeConnectionProvider getDataTypeConnectionProvider() {
        if (s_datatypeConnectionProvider == null) {
            s_datatypeConnectionProvider = new UtDataTypeConnectionProvider();
        }
        return s_datatypeConnectionProvider;
    }

    public static boolean isRepositoryOpen() {
        return UtAddin.getRepositoryManager().isConnected();
    }

    public static boolean defaultDefined() {
        return !UtAddin.getConfig().getRepository().equals("");
    }

    public static String getRepositoryConnectionName() {
        if (UtAddin.getRepositoryManager().isConnected()) {
            return UtAddin.getRepositoryManager().getName();
        }
        return null;
    }

    public static void closeRepository() {
        UtAddin.getRepositoryManager().closeConnection();
        s_repositoryManager = null;
        if (s_repositoryListeners != null) {
            for (UtRepositoryStateListener utRepositoryStateListener : s_repositoryListeners) {
                utRepositoryStateListener.repositoryClosed();
            }
        }
        RootFolder.getInstance().clearTree();
    }

    public static void openRepository(String string) {
        if (UtAddin.getRepositoryManager().openConnectionNoChecks(string)) {
            if (!RepositoryManager.doesRepositoryExist(UtAddin.getRepositoryManager().getConnection())) {
                RootFolder.getInstance().clearTree();
            } else if (!RepositoryManager.isCurrentVersion(UtAddin.getRepositoryManager().getConnection())) {
                RootFolder.getInstance().clearTree();
            } else {
                if (s_repositoryListeners != null) {
                    for (UtRepositoryStateListener utRepositoryStateListener : s_repositoryListeners) {
                        utRepositoryStateListener.repositoryOpened(string);
                    }
                }
                RootFolder.getInstance().loadTree();
            }
            RootFolder.getInstance().reset();
        }
    }

    public static boolean isReposPingable() {
        return UtAddin.getRepositoryManager().isReposPingable();
    }

    public static UtConfig getConfig() {
        if (s_Config == null) {
            Preferences preferences = Preferences.getPreferences();
            s_Config = UtConfig.getInstance((PropertyStorage)preferences);
        }
        return s_Config;
    }

    public static void closeAllUnitTestUI() {
        Window[] windowArray = Window.getOwnerlessWindows();
        UtAddin.closeDialogs(windowArray);
        UtAddin.closeAllEditors();
        RootFolder.getInstance().clearTree();
    }

    public static void closeAllUnitTestUIDefer() {
        SwingUtils.dispatch((Runnable)new Runnable(){

            @Override
            public void run() {
                UtAddin.closeAllUnitTestUI();
            }
        });
    }

    public static void closeAllEditors() {
        ArrayList<Editor> arrayList = new ArrayList<Editor>();
        List list = EditorManager.getEditorManager().getAllEditors();
        for (Editor editor : list) {
            if (!(editor instanceof UtEditor)) continue;
            arrayList.add(editor);
        }
        EditorManager.getEditorManager().closeEditors(arrayList);
    }

    public static void closeAllEditorsDefer() {
        SwingUtils.dispatch((Runnable)new Runnable(){

            @Override
            public void run() {
                UtAddin.closeAllEditors();
            }
        });
    }

    private static void closeDialogs(Window[] windowArray) {
        for (Window window : windowArray) {
            UtAddin.closeDialogs(window.getOwnedWindows());
            if (!(window instanceof Dialog) || !window.isVisible()) continue;
            window.setVisible(false);
        }
    }

    static {
        s_Config = null;
        rootIcon = RaptorImage.getIcon((String)menuIcon);
        suiteFolderIcon = RaptorImage.getIcon((String)"suitefolder.png");
        reportFolderIcon = RaptorImage.getIcon((String)"reportroot.png");
        suiteNodeIcon = RaptorImage.getIcon((String)"suitefolder.png");
        testFolderIcon = RaptorImage.getIcon((String)"testfolder.png");
        testNodeIcon = RaptorImage.getIcon((String)"testnode.png");
        testEditorIcon = RaptorImage.getIcon((String)"testnode.png");
        testImplIcon = RaptorImage.getIcon((String)"testimpl.png");
        libStartupTypesFolderIcon = RaptorImage.getIcon((String)"libstartupsfolder.png");
        libTeardownTypesFolderIcon = RaptorImage.getIcon((String)"libteardownsfolder.png");
        libValidationTypesFolderIcon = RaptorImage.getIcon((String)"libvalidationfolder.png");
        libStartupsFolderIcon = RaptorImage.getIcon((String)"libstartupsfolder.png");
        libTeardownsFolderIcon = RaptorImage.getIcon((String)"libteardownsfolder.png");
        libValidationsFolderIcon = RaptorImage.getIcon((String)"libvalidationfolder.png");
        libStartupIcon = RaptorImage.getIcon((String)"libstartup.png");
        libTeardownIcon = RaptorImage.getIcon((String)"libteardown.png");
        libValidationIcon = RaptorImage.getIcon((String)"validateRegExp.png");
        libraryFolderIcon = RaptorImage.getIcon((String)"libraryfolder.png");
        lookupFolderIcon = RaptorImage.getIcon((String)"lookupfolder.png");
        lookupNodeIcon = RaptorImage.getIcon((String)"datatypefolder.png");
        libEditorIcon = RaptorImage.getIcon((String)"libeditor.png");
        navIcon = RaptorImage.getIcon((String)menuIcon);
        testParamIcon = RaptorImage.getIcon((String)"testimpl.png");
        suiteEditorIcon = RaptorImage.getIcon((String)"suites.png");
        lookupEditorIcon = RaptorImage.getIcon((String)"lookupattribute.png");
    }
}

