/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webbrowser;

import java.net.URL;
import oracle.ide.config.ChangeEventSource;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Copyable;

public final class BrowserOptions
extends ChangeEventSource
implements Copyable {
    public static final String KEY_SETTINGS = "WebBrowserOptions";
    private static final String BROWSER_CMD_LINE = "browserCmdLine";

    public BrowserOptions() {
    }

    private BrowserOptions(HashStructure hash) {
        super(hash);
    }

    public static BrowserOptions getInstance(PropertyStorage prefs) {
        return new BrowserOptions(BrowserOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public String getBrowserCmdLine(URL url) {
        String browserCmdLine = this.getBrowserCmdLine();
        if (url == null) {
            return browserCmdLine;
        }
        return BrowserOptions.macroSubstitution(browserCmdLine, "${URL}", url.toString());
    }

    public String getBrowserCmdLine() {
        return this._hash.getString(BROWSER_CMD_LINE, "");
    }

    public void setBrowserCmdLine(String cmdLine) {
        this._hash.putString(BROWSER_CMD_LINE, this.handleDoubleQuotes(cmdLine.trim()));
    }

    private static String macroSubstitution(String str, String macro, String text) {
        int i;
        if (macro.equals(text)) {
            return str;
        }
        int ml = macro.length();
        int tl = text.length();
        while ((i = str.indexOf(macro)) >= 0) {
            int sl = str.length();
            StringBuffer sb = new StringBuffer(sl + tl - ml);
            if (i > 0) {
                sb.append(str.substring(0, i));
            }
            sb.append(text);
            if (i + ml < sl) {
                sb.append(str.substring(i + ml));
            }
            str = sb.toString();
        }
        return str;
    }

    private String handleDoubleQuotes(String s) {
        int length;
        if (s.indexOf(34) == 0) {
            s = s.substring(1);
        }
        if ((length = s.length()) > 0 && s.lastIndexOf(34) == length - 1) {
            s = s.substring(0, length - 1);
        }
        s = s.replace('\"', '\'');
        return s.trim();
    }
}

