/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser.internal;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.security.misc.Checksum;

public final class Util {
    private static Boolean _cachedInternal;
    private static List<Worker> _queue;
    private static Thread _detectThread;

    private Util() {
    }

    public static synchronized void isInsideOracle(Worker worker) {
        if (_cachedInternal != null) {
            worker.onResult(_cachedInternal);
            return;
        }
        _queue.add(worker);
        if (_detectThread == null) {
            _detectThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    Util.setIsInsideOracle(Util.detectInternal());
                }
            });
            _detectThread.start();
        }
    }

    private static synchronized void setIsInsideOracle(Boolean isInsideOracle) {
        _cachedInternal = isInsideOracle;
        boolean result = isInsideOracle;
        Iterator<Worker> i = _queue.iterator();
        while (i.hasNext()) {
            i.next().onResult(result);
        }
        _queue.clear();
    }

    @Deprecated
    public static synchronized boolean isInsideOracle() {
        if (_cachedInternal != null) {
            return _cachedInternal;
        }
        _cachedInternal = Util.detectInternal();
        return _cachedInternal;
    }

    private static boolean isVerboseLogging() {
        return Boolean.getBoolean("ide.internalcheck.verbose");
    }

    private static boolean detectInternal() {
        try {
            if (Util.pingIdeWebSite()) {
                if (Util.isVerboseLogging()) {
                    System.err.println("Detected internal user: pinged internal website");
                }
                return true;
            }
            if (Util.checkHostname()) {
                if (Util.isVerboseLogging()) {
                    System.err.println("Detected internal user from hostname");
                }
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw (ThreadDeath)t;
            }
            if (Util.isVerboseLogging()) {
                System.err.println("Failed to detect internal user");
                t.printStackTrace();
            }
            return false;
        }
    }

    private static synchronized boolean checkHostname() {
        block4: {
            try {
                InetAddress[] inets = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
                for (int i = 0; i < inets.length; ++i) {
                    String hostName = inets[i].getCanonicalHostName();
                    if (hostName == null || !hostName.endsWith(".oracle.com")) continue;
                    return true;
                }
            }
            catch (UnknownHostException uhe) {
                if (!Util.isVerboseLogging()) break block4;
                uhe.printStackTrace();
            }
        }
        if (Util.isVerboseLogging()) {
            System.err.println("Failed to detect internal user: No hostname contains .oracle.com");
        }
        return false;
    }

    private static synchronized boolean pingIdeWebSite() {
        ProxyOptions tmppo = new ProxyOptions();
        tmppo.setUseProxy(Boolean.FALSE);
        final int[] response = new int[]{0};
        tmppo.doTask(new Runnable(){

            @Override
            public void run() {
                block2: {
                    String urlString = System.getProperty("ide.internalcheck.url", "http://ide.us.oracle.com/");
                    try {
                        URL urlToPing = new URL(urlString);
                        URLConnection conn = urlToPing.openConnection();
                        conn.setConnectTimeout(800);
                        conn.setReadTimeout(800);
                        ((HttpURLConnection)conn).setRequestMethod("HEAD");
                        conn.connect();
                        response[0] = ((HttpURLConnection)conn).getResponseCode();
                    }
                    catch (IOException ioe) {
                        if (!Util.isVerboseLogging()) break block2;
                        System.err.println("Could not connect to " + urlString + " when detecting internal user.");
                        ioe.printStackTrace();
                    }
                }
            }
        });
        return response[0] >= 200 && response[0] <= 299;
    }

    public static String encode(String data) {
        if (data == null) {
            return null;
        }
        try {
            byte[] b = data.getBytes();
            return Util.e(Checksum.MD5((byte[])b, null));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static String decode(String data) {
        if (data == null) {
            return null;
        }
        byte[] b = Util.d(data);
        if (b.length > 0) {
            try {
                b = Checksum.SHA((byte[])b, null);
                return new String(b);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
        return null;
    }

    public static String e(byte[] b) {
        StringBuffer result = new StringBuffer(b.length * 2);
        for (int i = 0; i < b.length; ++i) {
            result.append(Util.intToAlpha((b[i] & 0xF0) >> 4));
            result.append(Util.intToAlpha(b[i] & 0xF));
        }
        return result.toString();
    }

    public static byte[] d(String s) {
        int len = s.length();
        byte[] result = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            byte b1 = Util.alphaToInt(s.charAt(i));
            byte b2 = Util.alphaToInt(s.charAt(i + 1));
            result[i / 2] = (byte)(b1 << 4 & 0xF0 | b2 & 0xF);
        }
        return result;
    }

    private static char intToAlpha(int i) {
        assert (i < 16);
        return (char)(i < 10 ? i + 48 : i - 10 + 65);
    }

    private static byte alphaToInt(char c) {
        assert (c >= '0' && c <= '9' || c >= 'A' && c <= 'F');
        return (byte)(c >= 'A' ? c - 65 + 10 : c - 48);
    }

    static {
        _queue = new LinkedList<Worker>();
        _detectThread = null;
    }

    public static interface Worker {
        public void onResult(boolean var1);
    }
}

