/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Ide;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.controls.JMultiLineLabel;
import oracle.ide.controls.WholeNumberField;
import oracle.ide.net.URLFactory;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.resource.ProxySettingsArb;
import oracle.ide.util.ResourceUtils;
import oracle.ide.webbrowser.HttpPing;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.BrowserArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.dialogs.MessagePanel;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ModelUtil;

public final class ProxySettingsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_useProxy;
    private JTextField textfield_proxyHost;
    private WholeNumberField textfield_proxyPort;
    private JTextField textfield_proxyExceptions;
    private JCheckBox checkbox_useProxyAuth;
    private JLabel label_proxyUserName;
    private JTextField textfield_proxyUserName;
    private JLabel label_proxyPassword;
    private JPasswordField textfield_proxyPassword;
    private boolean _suppressUseProxy;
    private JButton _testProxy;
    private JLabel _testProxyStatus;
    private Thread _testThread;
    private JLabel _warningLabel;
    private static String DEFAULT_PROXY_EXCEPTIONS = "";

    public ProxySettingsPanel() {
        this(false);
    }

    public ProxySettingsPanel(boolean suppressUseProxy) {
        this._suppressUseProxy = suppressUseProxy;
        this.initializeComponent();
    }

    private void initializeComponent() {
        String useProxyText = ProxySettingsArb.getString((int)0);
        this.checkbox_useProxy = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_useProxy, (String)useProxyText);
        String proxyHostText = ProxySettingsArb.getString((int)1);
        String proxyPortText = ProxySettingsArb.getString((int)2);
        String proxyExceptionsText = ProxySettingsArb.getString((int)3);
        String exceptionsHintText = ProxySettingsArb.getString((int)4);
        JLabel label_proxyHost = new JLabel();
        JLabel label_proxyPort = new JLabel();
        JLabel label_proxyExceptions = new JLabel();
        JMultiLineLabel label_exceptionsHint = new JMultiLineLabel(exceptionsHintText);
        label_exceptionsHint.setMinimumRows(4);
        this.textfield_proxyHost = new JTextField();
        this.textfield_proxyPort = new WholeNumberField(8);
        this.textfield_proxyExceptions = new JTextField();
        this.textfield_proxyExceptions.setText(DEFAULT_PROXY_EXCEPTIONS);
        ResourceUtils.resLabel((JLabel)label_proxyHost, (Component)this.textfield_proxyHost, (String)proxyHostText);
        ResourceUtils.resLabel((JLabel)label_proxyPort, (Component)this.textfield_proxyPort, (String)proxyPortText);
        ResourceUtils.resLabel((JLabel)label_proxyExceptions, (Component)this.textfield_proxyExceptions, (String)proxyExceptionsText);
        String useProxyAuthText = ProxySettingsArb.getString((int)5);
        this.checkbox_useProxyAuth = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_useProxyAuth, (String)useProxyAuthText);
        String proxyUserNameText = ProxySettingsArb.getString((int)6);
        String proxyPasswordText = ProxySettingsArb.getString((int)7);
        this.label_proxyUserName = new JLabel();
        this.label_proxyPassword = new JLabel();
        this.textfield_proxyUserName = new JTextField();
        this.textfield_proxyPassword = new JPasswordField();
        ResourceUtils.resLabel((JLabel)this.label_proxyUserName, (Component)this.textfield_proxyUserName, (String)proxyUserNameText);
        ResourceUtils.resLabel((JLabel)this.label_proxyPassword, (Component)this.textfield_proxyPassword, (String)proxyPasswordText);
        Component[] dependents = new Component[]{label_proxyHost, this.textfield_proxyHost, label_proxyPort, this.textfield_proxyPort, label_proxyExceptions, this.textfield_proxyExceptions, label_exceptionsHint, this.checkbox_useProxyAuth};
        new ItemSelectableTracker((ItemSelectable)this.checkbox_useProxy, dependents);
        ActionListener listener = new ActionListener(){

            @Override
            public final void actionPerformed(ActionEvent event) {
                boolean enabled = ProxySettingsPanel.this.checkbox_useProxy.isSelected();
                if (enabled) {
                    String proxyExceptions = ProxySettingsPanel.this.textfield_proxyExceptions.getText();
                    if (!ModelUtil.hasLength((String)proxyExceptions)) {
                        proxyExceptions = ProxyOptions.ensureLocalExceptionsAdded(proxyExceptions);
                    }
                    ProxySettingsPanel.this.textfield_proxyExceptions.setText(proxyExceptions);
                }
                ProxySettingsPanel.this.updateProxyAuthFields();
            }
        };
        this.checkbox_useProxy.addActionListener(listener);
        this.checkbox_useProxyAuth.addActionListener(listener);
        this.setLayout(new GridBagLayout());
        Insets defaultInsets = new Insets(2, 5, 2, 5);
        Insets indentedInsets = new Insets(2, 29, 2, 5);
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        if (!this._suppressUseProxy) {
            this.add(this.checkbox_useProxy, constraints);
        }
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(label_proxyHost, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.textfield_proxyHost, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(label_proxyPort, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add((Component)this.textfield_proxyPort, constraints);
        constraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        this.add(label_proxyExceptions, constraints);
        constraints = new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        this.add(this.textfield_proxyExceptions, constraints);
        constraints = new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 1, defaultInsets, 0, 0);
        this.add((Component)label_exceptionsHint, constraints);
        constraints = new GridBagConstraints(0, 5, 2, 1, 1.0, 0.0, 17, 0, new Insets(15, 29, 2, 5), 0, 0);
        this.add(this.checkbox_useProxyAuth, constraints);
        JPanel authPanel = new JPanel();
        authPanel.setLayout(new GridBagLayout());
        constraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        authPanel.add((Component)this.label_proxyUserName, constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        authPanel.add((Component)this.textfield_proxyUserName, constraints);
        constraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, indentedInsets, 0, 0);
        authPanel.add((Component)this.label_proxyPassword, constraints);
        constraints = new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, defaultInsets, 0, 0);
        authPanel.add((Component)this.textfield_proxyPassword, constraints);
        constraints = new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 17, 2, new Insets(0, 24, 0, 0), 0, 0);
        this.add(authPanel, constraints);
        this._testProxy = new JButton();
        this._testProxyStatus = new JLabel();
        JPanel testProxyPanel = new JPanel();
        testProxyPanel.setLayout(new BorderLayout(5, 0));
        testProxyPanel.add((Component)this._testProxy, "West");
        testProxyPanel.add((Component)this._testProxyStatus, "Center");
        constraints = new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 17, 2, new Insets(15, 24, 0, 0), 0, 0);
        this.add(testProxyPanel, constraints);
        ResourceUtils.resButton((AbstractButton)this._testProxy, (String)BrowserArb.getString(29));
        this._testProxy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ProxySettingsPanel.this.startProxyTest();
            }
        });
        class ChangeListener
        implements ActionListener,
        DocumentListener {
            ChangeListener() {
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                ProxySettingsPanel.this.resetProxyTest();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProxySettingsPanel.this.resetProxyTest();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProxySettingsPanel.this.resetProxyTest();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProxySettingsPanel.this.resetProxyTest();
            }
        }
        ChangeListener cl = new ChangeListener();
        this.checkbox_useProxy.addActionListener(cl);
        this.checkbox_useProxyAuth.addActionListener(cl);
        this.textfield_proxyExceptions.getDocument().addDocumentListener(cl);
        this.textfield_proxyHost.getDocument().addDocumentListener(cl);
        this.textfield_proxyPassword.getDocument().addDocumentListener(cl);
        this.textfield_proxyPort.getDocument().addDocumentListener(cl);
        this.textfield_proxyUserName.getDocument().addDocumentListener(cl);
        this._warningLabel = new JLabel();
        constraints = new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 17, 2, new Insets(20, 5, 0, 0), 0, 0);
        this.add(this._warningLabel, constraints);
        this.updateProxyAuthFields();
    }

    public void setHost(String host) {
        this.textfield_proxyHost.setText(host);
    }

    public void setPort(String port) {
        this.textfield_proxyPort.setText(port);
    }

    public void setExceptions(String exceptions) {
        this.textfield_proxyExceptions.setText(exceptions);
    }

    public void setUseProxy(boolean useProxy) {
        this.checkbox_useProxy.setSelected(useProxy);
        this._testProxy.setEnabled(this.checkbox_useProxy.isSelected());
    }

    public void setUseProxyAuthentication(boolean useProxyAuthentication) {
        this.checkbox_useProxyAuth.setSelected(useProxyAuthentication);
    }

    public void setUserName(String userName) {
        this.textfield_proxyUserName.setText(userName);
    }

    public void setPassword(String password) {
        this.textfield_proxyPassword.setText(password);
    }

    public String getHost() {
        return this.textfield_proxyHost.getText();
    }

    public String getPort() {
        try {
            int value = Integer.parseInt(this.textfield_proxyPort.getText());
            if (value >= 0 && value <= 65535) {
                return Integer.toString(value);
            }
            this.textfield_proxyPort.setText("");
            return "";
        }
        catch (NumberFormatException e) {
            return "";
        }
        catch (RuntimeException e) {
            return "";
        }
    }

    public String getExceptions() {
        return this.textfield_proxyExceptions.getText();
    }

    public boolean getUseProxy() {
        return this.checkbox_useProxy.isSelected();
    }

    public boolean getUseProxyAuthentication() {
        return this.checkbox_useProxyAuth.isSelected();
    }

    public String getUserName() {
        return this.textfield_proxyUserName.getText();
    }

    public String getPassword() {
        return new String(this.textfield_proxyPassword.getPassword());
    }

    public void setProxyOptions(ProxyOptions proxyOptions) {
        this.setHost(proxyOptions.getUnfilteredProxyHost());
        this.setPort(proxyOptions.getUnfilteredProxyPort());
        this.setUseProxy(ProxySettingsPanel.valueOf(proxyOptions.getUnfilteredUseProxy()));
        this.setExceptions(proxyOptions.getUnfilteredProxyExceptions());
        this.setUseProxyAuthentication(ProxySettingsPanel.valueOf(proxyOptions.getUnfilteredUseProxyAuthentication()));
        this.setUserName(proxyOptions.getUnfilteredProxyUserName());
        this.setPassword(proxyOptions.getUnfilteredProxyPassword());
    }

    private static boolean valueOf(Boolean b) {
        return b == null ? false : b;
    }

    public ProxyOptions getProxyOptions() {
        ProxyOptions po = new ProxyOptions();
        po.setProxyHost(this.getHost());
        po.setProxyPort(this.getPort());
        po.setProxyExceptions(this.getExceptions());
        po.setUseProxy(this.getUseProxy());
        po.setUseProxyAuthentication(this.getUseProxyAuthentication());
        po.setProxyUserName(this.getUserName());
        po.setProxyPassword(this.getPassword());
        return po;
    }

    private void updateProxyAuthFields() {
        boolean enabled = this.checkbox_useProxy.isSelected() && this.checkbox_useProxyAuth.isSelected();
        this.label_proxyUserName.setEnabled(enabled);
        this.label_proxyPassword.setEnabled(enabled);
        this.textfield_proxyUserName.setEnabled(enabled);
        this.textfield_proxyPassword.setEnabled(enabled);
        this._testProxy.setEnabled(this.checkbox_useProxy.isSelected());
    }

    public void onEntry(TraversableContext tc) {
        ProxyOptions proxyOptions = this.findProxyOptions(tc);
        Boolean useProxyBoolean = proxyOptions.getUnfilteredUseProxy();
        boolean useProxy = useProxyBoolean != null ? useProxyBoolean : false;
        Boolean useProxyAuthBoolean = proxyOptions.getUnfilteredUseProxyAuthentication();
        boolean useProxyAuth = useProxyAuthBoolean != null ? useProxyAuthBoolean : false;
        this.setHost(proxyOptions.getUnfilteredProxyHost());
        this.setPort(proxyOptions.getUnfilteredProxyPort());
        this.setExceptions(proxyOptions.getUnfilteredProxyExceptions());
        this.setUseProxy(useProxy);
        this.setUseProxyAuthentication(useProxyAuth);
        this.setUserName(proxyOptions.getUnfilteredProxyUserName());
        this.setPassword(proxyOptions.getUnfilteredProxyPassword());
        this.setProxyTestStatus(ProxyTestStatus.NOT_STARTED);
        if (proxyOptions.getIsIdeProxy() && !proxyOptions.isDefaultFilter()) {
            this._warningLabel.setText(ProxySettingsArb.format((int)10, (Object)proxyOptions.getFilter().getLabel()));
            this._warningLabel.setForeground(Color.RED);
            this._warningLabel.setVisible(true);
        } else {
            this._warningLabel.setVisible(false);
        }
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        ProxyOptions proxyOptions = this.findProxyOptions(tc);
        boolean useProxy = this.getUseProxy();
        proxyOptions.setUseProxy(useProxy ? Boolean.TRUE : Boolean.FALSE);
        proxyOptions.setProxyHost(this.getHost());
        proxyOptions.setProxyExceptions(ProxyOptions.normalizeExceptions(this.getExceptions()));
        proxyOptions.setProxyPort(this.getPort());
        proxyOptions.setUseProxyAuthentication(this.getUseProxyAuthentication());
        proxyOptions.setProxyUserName(this.getUserName());
        proxyOptions.setProxyPassword(this.getPassword());
        if (!this.authenticationIsValid(proxyOptions)) {
            proxyOptions.setUseProxyAuthentication(Boolean.FALSE);
        }
        if (proxyOptions.getIsIdeProxy() && !proxyOptions.isDefaultFilter()) {
            MessageDialog.optionalInformation((String)"oracle.ide.webbrowser.ProxySettingsPanel", (Component)((Object)this), (String)ProxySettingsArb.format((int)10, (Object)proxyOptions.getFilter().getLabel()), (String)ProxySettingsArb.getString((int)11), null);
        }
        if (this._testThread != null) {
            this._testThread.interrupt();
            this.setProxyTestStatus(ProxyTestStatus.NOT_STARTED);
        }
    }

    private ProxyOptions findProxyOptions(TraversableContext tc) {
        return ProxyOptions.getInstance(tc.getPropertyStorage());
    }

    private void setProxyTestProgress(final URL url) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                ProxySettingsPanel.this._testProxyStatus.setText(BrowserArb.format(31, url.getProtocol(), url.getHost()));
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void setProxyTestStatus(final ProxyTestStatus status) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                if (status == ProxyTestStatus.NOT_STARTED) {
                    ProxySettingsPanel.this._testProxyStatus.setVisible(false);
                    ProxySettingsPanel.this._testProxy.setToolTipText(null);
                } else {
                    Icon icon = null;
                    String label = null;
                    String buttonToolTip = null;
                    switch (status) {
                        case TESTING: {
                            icon = OracleIcons.getIcon((String)"throbber.gif");
                            label = BrowserArb.getString(30);
                            break;
                        }
                        case SUCCESSFUL: {
                            icon = OracleIcons.getIcon((String)"check.png");
                            label = BrowserArb.getString(32);
                            buttonToolTip = BrowserArb.getString(34);
                            break;
                        }
                        case FAILED: {
                            icon = OracleIcons.getIcon((String)"error.png");
                            label = BrowserArb.getString(33);
                            buttonToolTip = BrowserArb.getString(35);
                        }
                    }
                    ProxySettingsPanel.this._testProxyStatus.setVisible(true);
                    ProxySettingsPanel.this._testProxyStatus.setIcon(icon);
                    ProxySettingsPanel.this._testProxyStatus.setText(label);
                    ProxySettingsPanel.this._testProxy.setToolTipText(buttonToolTip);
                }
                ProxySettingsPanel.this._testProxy.setEnabled(ProxySettingsPanel.this.checkbox_useProxy.isSelected() && status != ProxyTestStatus.TESTING);
                ProxySettingsPanel.this.revalidate();
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void resetProxyTest() {
        if (this._testThread != null) {
            this._testThread.interrupt();
            this.setProxyTestStatus(ProxyTestStatus.NOT_STARTED);
        }
    }

    private boolean authenticationIsValid(ProxyOptions options) {
        if (!this.getUseProxyAuthentication()) {
            return true;
        }
        String proxyUserName = options.getProxyUserName();
        String proxyPassword = options.getProxyPassword();
        proxyUserName = proxyUserName != null ? proxyUserName.trim() : "";
        proxyPassword = proxyPassword != null ? proxyPassword.trim() : "";
        return proxyUserName.length() > 0 && proxyPassword.length() > 0;
    }

    private void startProxyTest() {
        final ProxyOptions options = this.getProxyOptions();
        if (!this.authenticationIsValid(options)) {
            MessageDialog.error((Component)Ide.getMainWindow(), (Object)BrowserArb.getString(41), (String)BrowserArb.getString(40), null);
            return;
        }
        this.setProxyTestStatus(ProxyTestStatus.TESTING);
        Runnable testRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ProxySettingsPanel proxySettingsPanel = ProxySettingsPanel.this;
                synchronized (proxySettingsPanel) {
                    ProxyTestStatus newStatus = ProxyTestStatus.NOT_STARTED;
                    try {
                        URL[] urls;
                        for (URL url : urls = new URL[]{URLFactory.newURL((String)"http://www.internic.net"), URLFactory.newURL((String)"http://www.oracle.com"), URLFactory.newURL((String)"http://download.oracle.com")}) {
                            ProxySettingsPanel.this.setProxyTestProgress(url);
                            new HttpPing(options, url).ping();
                            if (!Thread.interrupted()) continue;
                            return;
                        }
                        newStatus = ProxyTestStatus.SUCCESSFUL;
                    }
                    catch (HttpPing.PingFailedException failure) {
                        if (!Thread.interrupted()) {
                            newStatus = ProxyTestStatus.FAILED;
                            ProxySettingsPanel.this.displayProxyTestFailure(failure);
                        }
                    }
                    finally {
                        ProxySettingsPanel.this.setProxyTestStatus(newStatus);
                    }
                }
            }
        };
        this._testThread = new Thread(testRunnable, BrowserArb.getString(39));
        this._testThread.setPriority(1);
        this._testThread.start();
    }

    private void displayProxyTestFailure(final HttpPing.PingFailedException failure) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                final JEWTDialog jd = JEWTDialog.createDialog((Component)((Object)ProxySettingsPanel.this), (String)ProxySettingsArb.getString((int)8), (int)16);
                final MessagePanel p = new MessagePanel();
                p.setTitle(failure.getMessage());
                p.setMessageText(failure.getDetails());
                p.setMessageType(3);
                AbstractAction details = new AbstractAction(ProxySettingsArb.getString((int)9)){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ProxySettingsPanel.this.displayProxyTestDetails((Component)p, failure);
                        jd.closeDialog(false);
                    }
                };
                p.addHyperAction((Action)details);
                jd.setContent((Component)p);
                jd.runDialog();
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    private void displayProxyTestDetails(Component parent, HttpPing.PingFailedException failure) {
        JTextArea a = new JTextArea();
        a.setLineWrap(true);
        a.setWrapStyleWord(true);
        a.setRows(22);
        a.setColumns(70);
        a.setEditable(false);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (failure.getHttpResponseCode() == -1) {
            sw.append(BrowserArb.getString(36));
        } else {
            sw.append(BrowserArb.format(37, String.valueOf(failure.getHttpResponseCode()) + " " + failure.getHttpResponseMessage()));
        }
        sw.append("\n\n");
        if (failure.getCause() != null) {
            failure.getCause().printStackTrace(pw);
        }
        pw.close();
        a.setText(sw.toString());
        a.setCaretPosition(0);
        JEWTDialog jd = JEWTDialog.createDialog((Component)parent, (String)BrowserArb.getString(38), (int)16);
        jd.setContent((Component)new JScrollPane(a));
        jd.runDialog();
    }

    public void apply(ApplyEvent e) {
        this.resetProxyTest();
    }

    public void cancel(ApplyEvent e) {
        this.resetProxyTest();
    }

    private static enum ProxyTestStatus {
        NOT_STARTED,
        TESTING,
        SUCCESSFUL,
        FAILED;

    }
}

