/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.config.ChangeEventSource;
import oracle.ide.config.Preferences;
import oracle.ide.webbrowser.ProxyOptionsFilter;
import oracle.ide.webbrowser.internal.Util;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.marshal.TransientMarker;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.security.misc.Checksum;

public class ProxyOptions
extends ChangeEventSource
implements Copyable {
    private static final Logger LOG = Logger.getLogger(ProxyOptions.class.getName());
    public static final String KEY_SETTINGS = "proxy-options";
    public static final String PROPERTY_PROXY_HOST = "http.proxyHost";
    public static final String PROPERTY_PROXY_PORT = "http.proxyPort";
    public static final String PROPERTY_PROXY_EXCEPTIONS = "http.nonProxyHosts";
    public static final String DEFAULT_PROXY_PORT = "80";
    private static final String PROPERTY_PROXY_USERNAME = "http.proxyUserName";
    private static final String PROPERTY_PROXY_USERNAME2 = "http.proxyUsername";
    private static final String PROPERTY_PROXY_PASSWORD = "http.proxyPassword";
    private static final String PROPERTY_PROXY_HOST_SECURE = "https.proxyHost";
    private static final String PROPERTY_PROXY_PORT_SECURE = "https.proxyPort";
    private static final String PROPERTY_PROXY_USERNAME_SECURE = "https.proxyUserName";
    private static final String PROPERTY_PROXY_USERNAME_SECURE2 = "https.proxyUsername";
    private static final String PROPERTY_PROXY_PASSWORD_SECURE = "https.proxyPassword";
    private static final String PROPERTY_PROXY_EXCEPTIONS_SECURE = "https.nonProxyHosts";
    private static final String IS_IDE_PROXY = "IsIdeProxy";
    private static final ProxyOptionsFilter _defaultFilter;
    private static ProxyOptionsFilter _filter;
    private static ProxyOptions INSTANCE;
    private static final String PROXY_EXCEPTION_SEPARATOR = "|";
    private static String DEFAULT_PROXY_EXCEPTIONS;
    static final String[] LOCAL_PROXY_EXCEPTIONS;
    private static final String PROXY_HOST = "proxyHost";
    private static final String PROXY_PORT = "proxyPort";
    private static final String PROXY_EXCEPTIONS = "proxyExceptions";
    private static final String USE_PROXY = "useProxy";
    private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
    private static final String PROXY_USER_NAME = "proxyUserName";
    private static final String PROXY_PASSWORD = "proxyData";

    public ProxyOptions() {
    }

    protected ProxyOptions(HashStructure hash) {
        super(hash);
    }

    public static ProxyOptions getInstance(PropertyStorage prefs) {
        return new ProxyOptions(ProxyOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
    }

    public static final synchronized ProxyOptions getProxyOptions() throws TransientMarker {
        if (INSTANCE == null) {
            Preferences prefs = Preferences.getPreferences();
            ProxyOptions proxyOptions = new ProxyOptions(ProxyOptions.findOrCreate((PropertyStorage)prefs, (String)KEY_SETTINGS));
            boolean settingsUninitialized = prefs.getProperties().keyStatus(KEY_SETTINGS) == 2;
            proxyOptions.setIsIdeProxy(Boolean.TRUE);
            if (settingsUninitialized) {
                ProxyOptions.initializeProxyOptionsFromSystemProperties(proxyOptions);
            }
            INSTANCE = proxyOptions;
        }
        return INSTANCE;
    }

    void setIsIdeProxy(boolean isIdeProxy) {
        this._hash.putBoolean(IS_IDE_PROXY, Boolean.valueOf(isIdeProxy).booleanValue());
    }

    public boolean getIsIdeProxy() throws TransientMarker {
        Boolean booleanVal = this._hash.getBoolean(IS_IDE_PROXY, false);
        return booleanVal;
    }

    boolean isDefaultFilter() {
        return this.getFilter() instanceof DefaultProxyOptionsFilter;
    }

    public ProxyOptionsFilter getFilter() {
        if (this.getIsIdeProxy()) {
            return _filter;
        }
        return _defaultFilter;
    }

    public synchronized void setFilter(ProxyOptionsFilter filter) {
        if (this.getIsIdeProxy()) {
            _filter = filter == null ? _defaultFilter : filter;
        }
    }

    static void initializeProxyOptionsFromSystemProperties(ProxyOptions proxyOptions) {
        String proxyHostIn = System.getProperty(PROPERTY_PROXY_HOST);
        if (proxyHostIn != null) {
            String proxyExceptionsIn;
            String proxyPortIn = System.getProperty(PROPERTY_PROXY_PORT);
            if (proxyPortIn == null || proxyPortIn.length() == 0) {
                proxyPortIn = DEFAULT_PROXY_PORT;
            }
            if ((proxyExceptionsIn = System.getProperty(PROPERTY_PROXY_EXCEPTIONS)) == null) {
                proxyExceptionsIn = DEFAULT_PROXY_EXCEPTIONS;
            }
            proxyOptions.setUseProxy(Boolean.TRUE);
            proxyOptions.setProxyHost(proxyHostIn);
            proxyOptions.setProxyPort(proxyPortIn);
            proxyOptions.setProxyExceptions(proxyExceptionsIn);
        } else {
            proxyOptions.setUseProxy(Boolean.FALSE);
        }
        if (proxyOptions.getUseProxy().booleanValue()) {
            String proxyExceptions = proxyOptions.getProxyExceptions();
            proxyExceptions = ProxyOptions.ensureLocalExceptionsAdded(proxyExceptions);
            proxyOptions.setProxyExceptions(proxyExceptions);
        }
    }

    static boolean containsException(String[] currentExceptions, String exception) {
        boolean retval = false;
        if (currentExceptions != null && currentExceptions.length != 0 && exception.length() > 0) {
            for (String currentException : currentExceptions) {
                if (!currentException.equals(exception)) continue;
                retval = true;
                break;
            }
        }
        return retval;
    }

    static String normalizeExceptions(String exceptions) {
        String normalizedExceptions = exceptions;
        if (normalizedExceptions == null || normalizedExceptions.trim().length() == 0) {
            normalizedExceptions = DEFAULT_PROXY_EXCEPTIONS;
        } else {
            normalizedExceptions = normalizedExceptions.toLowerCase();
            normalizedExceptions = normalizedExceptions.replaceAll(",", PROXY_EXCEPTION_SEPARATOR);
            normalizedExceptions = normalizedExceptions.replaceAll(" ", "");
        }
        return normalizedExceptions;
    }

    static String[] splitExceptionsIntoArray(String exceptions) {
        String[] currentExceptions = null;
        if (ModelUtil.hasLength((String)exceptions)) {
            currentExceptions = exceptions.split("\\|");
        }
        return currentExceptions;
    }

    private static List<String> getLocalExceptions() {
        ArrayList<String> localExceptions = new ArrayList<String>(LOCAL_PROXY_EXCEPTIONS.length);
        for (String exception : LOCAL_PROXY_EXCEPTIONS) {
            localExceptions.add(exception);
        }
        try {
            InetAddress address = InetAddress.getLocalHost();
            String name = address.getCanonicalHostName();
            if (name != null) {
                localExceptions.add(name);
            }
            if ((name = address.getHostName()) != null) {
                localExceptions.add(name);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return localExceptions;
    }

    static String ensureLocalExceptionsAdded(String proxyExceptions) {
        String normalizedExceptions = ProxyOptions.normalizeExceptions(proxyExceptions);
        String[] currentExceptions = ProxyOptions.splitExceptionsIntoArray(normalizedExceptions);
        StringBuffer sb = ModelUtil.hasLength((String)normalizedExceptions) ? new StringBuffer(normalizedExceptions) : new StringBuffer();
        List<String> localExceptions = ProxyOptions.getLocalExceptions();
        for (String exception : localExceptions) {
            if (ProxyOptions.containsException(currentExceptions, exception)) continue;
            if (sb.length() > 0) {
                sb.append(PROXY_EXCEPTION_SEPARATOR);
            }
            sb.append(exception);
        }
        return sb.toString();
    }

    public static final void setProxyOptions(ProxyOptions proxyOptions) throws TransientMarker {
        ProxyOptions p = ProxyOptions.getProxyOptions();
        proxyOptions.copyTo((Object)p);
    }

    public final void setProxyHost(String newProxyHost) {
        this._hash.putString(PROXY_HOST, newProxyHost);
    }

    public final String getProxyHost() {
        return this.getFilter().getProxyHost(this._hash.getString(PROXY_HOST));
    }

    public final String getUnfilteredProxyHost() {
        return this._hash.getString(PROXY_HOST);
    }

    public final void setProxyPort(String newProxyPort) {
        this._hash.putString(PROXY_PORT, newProxyPort);
    }

    public final String getProxyPort() {
        return this.getFilter().getProxyPort(this._hash.getString(PROXY_PORT));
    }

    public final String getUnfilteredProxyPort() {
        return this._hash.getString(PROXY_PORT);
    }

    public final void setProxyExceptions(String newProxyExceptions) {
        this._hash.putString(PROXY_EXCEPTIONS, newProxyExceptions);
    }

    public final String getProxyExceptions() {
        return this.getFilter().getProxyExceptions(this._hash.getString(PROXY_EXCEPTIONS));
    }

    public final String getUnfilteredProxyExceptions() {
        return this._hash.getString(PROXY_EXCEPTIONS);
    }

    public final void setUseProxy(Boolean newUseProxy) {
        if (newUseProxy != null) {
            this._hash.putBoolean(USE_PROXY, newUseProxy.booleanValue());
        } else {
            this._hash.remove(USE_PROXY);
        }
    }

    public Boolean getUseProxy() {
        return this.getFilter().getUseProxy(this._hash.getBoolean(USE_PROXY));
    }

    public Boolean getUnfilteredUseProxy() {
        return this._hash.getBoolean(USE_PROXY);
    }

    public final void setUseProxyAuthentication(Boolean newUseProxyAuthentication) {
        if (newUseProxyAuthentication != null) {
            this._hash.putBoolean(USE_PROXY_AUTHENTICATION, newUseProxyAuthentication.booleanValue());
        } else {
            this._hash.remove(USE_PROXY_AUTHENTICATION);
        }
    }

    public Boolean getUseProxyAuthentication() {
        return this.getFilter().getUseProxyAuthentication(this._hash.getBoolean(USE_PROXY_AUTHENTICATION));
    }

    public Boolean getUnfilteredUseProxyAuthentication() {
        return this._hash.getBoolean(USE_PROXY_AUTHENTICATION);
    }

    public final void setProxyUserName(String newProxyUserName) {
        this._hash.putString(PROXY_USER_NAME, newProxyUserName);
    }

    public final String getProxyUserName() {
        return this.getFilter().getProxyUserName(this._hash.getString(PROXY_USER_NAME));
    }

    public final String getUnfilteredProxyUserName() {
        return this._hash.getString(PROXY_USER_NAME);
    }

    public final void setProxyPassword(String newProxyPassword) {
        try {
            byte[] b = newProxyPassword.getBytes();
            String encodedPassword = Util.e(Checksum.MD5((byte[])b, null));
            this._hash.putString(PROXY_PASSWORD, encodedPassword);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to set proxy password", e);
            this._hash.putString(PROXY_PASSWORD, "");
        }
    }

    public final String getProxyPassword() throws TransientMarker {
        byte[] b;
        String encodedPassword = this.getFilter().getProxyPassword(this._hash.getString(PROXY_PASSWORD));
        if (encodedPassword != null && (b = Util.d(encodedPassword)).length > 0) {
            try {
                b = Checksum.SHA((byte[])b, null);
                return new String(b);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to get proxy password", e);
            }
        }
        return "";
    }

    public final String getUnfilteredProxyPassword() throws TransientMarker {
        byte[] b;
        String encodedPassword = this._hash.getString(PROXY_PASSWORD);
        if (encodedPassword != null && (b = Util.d(encodedPassword)).length > 0) {
            try {
                b = Checksum.SHA((byte[])b, null);
                return new String(b);
            }
            catch (Exception e) {
                LOG.log(Level.SEVERE, "Failed to get proxy password", e);
            }
        }
        return "";
    }

    public final void setProxyData(String newData) {
        this._hash.putString(PROXY_PASSWORD, newData);
    }

    public final String getProxyData() {
        return this.getFilter().getProxyData(this._hash.getString(PROXY_PASSWORD));
    }

    public final String getUnfilteredProxyData() {
        return this._hash.getString(PROXY_PASSWORD);
    }

    public String[] getJavaProxyOptions() {
        String proxyHost;
        Boolean useProxy = this.getUseProxy();
        if (useProxy != null && useProxy.booleanValue() && (proxyHost = this.getProxyHost()) != null && proxyHost.length() > 0) {
            String[] jpo = new String[6];
            jpo[0] = "-Dhttp.proxyHost=" + proxyHost;
            String proxyPort = this.getProxyPort();
            String port = proxyPort != null && proxyPort.length() > 0 ? proxyPort : DEFAULT_PROXY_PORT;
            jpo[1] = "-Dhttp.proxyPort=" + port;
            String proxyExceptions = this.getProxyExceptions();
            jpo[2] = "-Dhttp.nonProxyHosts=" + proxyExceptions;
            jpo[3] = "-Dhttps.proxyHost=" + proxyHost;
            jpo[4] = "-Dhttps.proxyPort=" + port;
            jpo[5] = "-Dhttps.nonProxyHosts=" + proxyExceptions;
            return jpo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTask(Runnable r) {
        Class<ProxyOptions> clazz = ProxyOptions.class;
        synchronized (ProxyOptions.class) {
            ProxyOptions saved = ProxyOptions.getProxyOptions();
            try {
                this.applyToCurrentVM();
                r.run();
            }
            finally {
                saved.applyToCurrentVM();
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyToCurrentVM() {
        Class<ProxyOptions> clazz = ProxyOptions.class;
        synchronized (ProxyOptions.class) {
            block13: {
                Boolean useProxyBoolean = this.getUseProxy();
                boolean useProxy = useProxyBoolean != null ? useProxyBoolean : false;
                String proxyHost = this.getProxyHost();
                String proxyExceptions = this.getProxyExceptions();
                Boolean useProxyAuthBoolean = this.getUseProxyAuthentication();
                boolean useProxyAuth = useProxyAuthBoolean != null ? useProxyAuthBoolean : false;
                String proxyUserName = this.getProxyUserName();
                String proxyPassword = this.getProxyPassword();
                if (useProxy && proxyHost != null && proxyHost.length() > 0) {
                    String proxyPort = this.getProxyPort();
                    if (proxyPort == null || proxyPort.length() == 0) {
                        proxyPort = DEFAULT_PROXY_PORT;
                    }
                    if (proxyExceptions == null) {
                        proxyExceptions = "";
                    }
                    try {
                        System.setProperty(PROPERTY_PROXY_HOST, proxyHost);
                        System.setProperty(PROPERTY_PROXY_PORT, proxyPort);
                        System.setProperty(PROPERTY_PROXY_EXCEPTIONS, proxyExceptions);
                        System.setProperty(PROPERTY_PROXY_HOST_SECURE, proxyHost);
                        System.setProperty(PROPERTY_PROXY_PORT_SECURE, proxyPort);
                        System.setProperty(PROPERTY_PROXY_EXCEPTIONS_SECURE, proxyExceptions);
                        if (useProxyAuth && proxyUserName != null && proxyPassword != null) {
                            System.setProperty(PROPERTY_PROXY_USERNAME, proxyUserName);
                            System.setProperty(PROPERTY_PROXY_USERNAME2, proxyUserName);
                            System.setProperty(PROPERTY_PROXY_PASSWORD, proxyPassword);
                            System.setProperty(PROPERTY_PROXY_USERNAME_SECURE, proxyUserName);
                            System.setProperty(PROPERTY_PROXY_USERNAME_SECURE2, proxyUserName);
                            System.setProperty(PROPERTY_PROXY_PASSWORD_SECURE, proxyPassword);
                            break block13;
                        }
                        if (useProxyAuth) {
                            this.setUseProxyAuthentication(Boolean.FALSE);
                        }
                        Properties properties = System.getProperties();
                        properties.remove(PROPERTY_PROXY_USERNAME);
                        properties.remove(PROPERTY_PROXY_USERNAME2);
                        properties.remove(PROPERTY_PROXY_PASSWORD);
                        properties.remove(PROPERTY_PROXY_USERNAME_SECURE);
                        properties.remove(PROPERTY_PROXY_USERNAME_SECURE2);
                        properties.remove(PROPERTY_PROXY_PASSWORD_SECURE);
                    }
                    catch (SecurityException e) {
                        LOG.log(Level.SEVERE, "Could not set proxy setting", e);
                    }
                } else {
                    try {
                        Properties properties = System.getProperties();
                        properties.remove(PROPERTY_PROXY_HOST);
                        properties.remove(PROPERTY_PROXY_PORT);
                        properties.remove(PROPERTY_PROXY_EXCEPTIONS);
                        properties.remove(PROPERTY_PROXY_HOST_SECURE);
                        properties.remove(PROPERTY_PROXY_PORT_SECURE);
                        properties.remove(PROPERTY_PROXY_USERNAME);
                        properties.remove(PROPERTY_PROXY_USERNAME2);
                        properties.remove(PROPERTY_PROXY_PASSWORD);
                        properties.remove(PROPERTY_PROXY_USERNAME_SECURE);
                        properties.remove(PROPERTY_PROXY_USERNAME_SECURE2);
                        properties.remove(PROPERTY_PROXY_PASSWORD_SECURE);
                    }
                    catch (SecurityException e) {
                        LOG.log(Level.SEVERE, "Could not remove proxy setting", e);
                    }
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public final boolean equals(Object other) {
        boolean equal = true;
        if (other instanceof ProxyOptions) {
            ProxyOptions copy = (ProxyOptions)((Object)other);
            if (!ModelUtil.areEqual((Object)this.getUnfilteredProxyExceptions(), (Object)copy.getUnfilteredProxyExceptions())) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)this.getUnfilteredProxyHost(), (Object)copy.getUnfilteredProxyHost())) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)this.getUnfilteredProxyPassword(), (Object)copy.getUnfilteredProxyPassword())) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)this.getUnfilteredProxyPort(), (Object)copy.getUnfilteredProxyPort())) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)this.getUnfilteredProxyUserName(), (Object)copy.getUnfilteredProxyUserName())) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)this.getUnfilteredUseProxy(), (Object)copy.getUnfilteredUseProxy())) {
                equal = false;
            } else if (!ModelUtil.areEqual((Object)this.getUnfilteredUseProxyAuthentication(), (Object)copy.getUnfilteredUseProxyAuthentication())) {
                equal = false;
            }
        } else {
            equal = false;
        }
        return equal;
    }

    public Object copyTo(Object target) {
        ProxyOptions copy = target != null ? (ProxyOptions)((Object)target) : new ProxyOptions();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(ProxyOptions copy) {
        if (!this.equals((Object)copy)) {
            copy.setProxyExceptions(this.getUnfilteredProxyExceptions());
            copy.setProxyHost(this.getUnfilteredProxyHost());
            copy.setProxyPassword(this.getUnfilteredProxyPassword());
            copy.setProxyPort(this.getUnfilteredProxyPort());
            copy.setProxyUserName(this.getUnfilteredProxyUserName());
            copy.setUseProxy(this.getUnfilteredUseProxy());
            copy.setUseProxyAuthentication(this.getUnfilteredUseProxyAuthentication());
            copy.fireChangeEvent();
        }
    }

    static {
        _filter = _defaultFilter = new DefaultProxyOptionsFilter();
        DEFAULT_PROXY_EXCEPTIONS = "";
        LOCAL_PROXY_EXCEPTIONS = new String[]{"localhost", "localhost.localdomain", "127.0.0.1", "::1"};
    }

    private static class DefaultProxyOptionsFilter
    extends ProxyOptionsFilter {
        private DefaultProxyOptionsFilter() {
        }

        @Override
        public String getLabel() {
            return "DefaultProxyOptionsFilter";
        }
    }
}

