/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.webbrowser;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import oracle.ide.webbrowser.ProxyOptions;
import oracle.ideimpl.webbrowser.BrowserArb;

final class HttpPing {
    private static final int DEFAULT_TIMEOUT = 5000;
    private final ProxyOptions _proxyOptions;
    private final URL _url;
    private final int _timeout;

    public HttpPing(ProxyOptions options, URL url) {
        this(options, url, 5000);
    }

    public HttpPing(ProxyOptions options, URL url, int timeout) {
        if (options == null) {
            throw new IllegalArgumentException("options is null");
        }
        if (url == null) {
            throw new IllegalArgumentException("url is null");
        }
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must be >= 0: " + timeout);
        }
        this._proxyOptions = options;
        this._url = url;
        this._timeout = timeout;
    }

    public void ping() throws PingFailedException {
        PingRunnable runnable = new PingRunnable();
        this._proxyOptions.doTask(runnable);
        if (runnable.getThrown() != null) {
            throw runnable.getThrown();
        }
    }

    private PingFailedException convertToPingFailedException(IOException ioe, int httpResponseCode, String httpResponseMessage) {
        if (ioe instanceof SocketTimeoutException || httpResponseCode == 408 || httpResponseCode == 504) {
            if ("download.oracle.com".equals(this._url.getHost()) && this._proxyOptions.getProxyExceptions() != null && (this._proxyOptions.getProxyExceptions().toLowerCase().contains("*.oracle.com") || this._proxyOptions.getProxyExceptions().toLowerCase().contains("download.oracle.com"))) {
                return new PingFailedException(BrowserArb.getString(27), BrowserArb.format(28, this._url.getHost()), ioe, httpResponseCode, httpResponseMessage);
            }
            return new PingFailedException(BrowserArb.getString(19), BrowserArb.format(20, this._url.getHost()), ioe, httpResponseCode, httpResponseMessage);
        }
        if (httpResponseCode == 407) {
            if (this._proxyOptions.getProxyUserName() != null && this._proxyOptions.getProxyUserName().length() > 0 && this._proxyOptions.getUseProxyAuthentication().booleanValue()) {
                return new PingFailedException(BrowserArb.getString(23), BrowserArb.format(24, this._url.getHost()), ioe, httpResponseCode, httpResponseMessage);
            }
            return new PingFailedException(BrowserArb.getString(25), BrowserArb.format(26, this._url.getHost()), ioe, httpResponseCode, httpResponseMessage);
        }
        return new PingFailedException(BrowserArb.getString(21), BrowserArb.format(22, this._url.getHost()), ioe, httpResponseCode, httpResponseMessage);
    }

    public static final class PingFailedException
    extends Exception {
        private final String _details;
        private final int _responseCode;
        private final String _responseMessage;

        private PingFailedException(String summary, String details, Throwable cause, int responseCode, String responseMessage) {
            super(summary, cause);
            this._details = details;
            this._responseCode = responseCode;
            this._responseMessage = responseMessage;
        }

        public String getDetails() {
            return this._details;
        }

        public int getHttpResponseCode() {
            return this._responseCode;
        }

        public String getHttpResponseMessage() {
            return this._responseMessage;
        }
    }

    private class PingRunnable
    implements Runnable {
        private PingFailedException _thrown;

        private PingRunnable() {
        }

        public PingFailedException getThrown() {
            return this._thrown;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            URLConnection conn = null;
            int responseCode = -1;
            String responseMessage = null;
            try {
                conn = HttpPing.this._url.openConnection();
                conn.setConnectTimeout(HttpPing.this._timeout);
                conn.setReadTimeout(HttpPing.this._timeout);
                if (conn instanceof HttpURLConnection) {
                    HttpURLConnection httpConn = (HttpURLConnection)conn;
                    httpConn.setRequestMethod("HEAD");
                    httpConn.setInstanceFollowRedirects(true);
                }
                conn.connect();
                if (conn instanceof HttpURLConnection) {
                    responseCode = ((HttpURLConnection)conn).getResponseCode();
                    responseMessage = ((HttpURLConnection)conn).getResponseMessage();
                    if (responseCode >= 300 && responseCode != 302) {
                        this._thrown = HttpPing.this.convertToPingFailedException(null, responseCode, responseMessage);
                    }
                }
            }
            catch (IOException ioe) {
                this._thrown = HttpPing.this.convertToPingFailedException(ioe, responseCode, responseMessage);
            }
            finally {
                if (conn != null && conn instanceof HttpURLConnection) {
                    ((HttpURLConnection)conn).disconnect();
                }
            }
        }
    }
}

