/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.docking.DockStation;
import oracle.ide.docking.Dockable;
import oracle.ide.layout.IdeLayout;
import oracle.ide.layout.Layouts;
import oracle.ide.log.LogPage;
import oracle.ide.model.Element;
import oracle.ide.navigator.NavigatorConstants;
import oracle.ide.resource.IdeArb;
import oracle.ide.runner.Debugger;
import oracle.ide.runner.RunLogPage;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.Runner;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ide.view.ViewSelectionEvent;
import oracle.ide.view.ViewSelectionListener;
import oracle.ideimpl.resource.RunMgrArb;
import oracle.ideimpl.runner.DebuggerHook;
import oracle.ideimpl.runner.RunManagerDockableFactory;
import oracle.ideimpl.runner.RunManagerWindow;
import oracle.ideimpl.runner.RunnerBundle;
import oracle.ideri.util.Product;
import oracle.javatools.icons.OracleIcons;

public final class RunManagerUI
implements Addin,
IdeListener,
MenuListener,
Controller,
ViewSelectionListener,
ActiveViewListener {
    private static final String RUN_TERMINATE_CMD_PREFIX = "RunTerminateCommand";
    private static IdeAction actionViewRunManager;
    private static IdeAction actionStopOnError;
    private static IdeAction actionStopOnException;
    private static IdeAction actionStopOnDebugger;
    private static IdeAction actionTransferErrors;
    private static IdeAction actionStopInChrome;
    private static IdeAction actionGarbageCollect;
    private static IdeAction actionNavigatorTerminate;
    private static IdeAction actionViewLog;
    private static JMenu terminateSubMenu;
    private static JMenuItem emptyItem;
    static final int VIEW_RUN_MANAGER_CMD_ID;
    private static final int NAVIGATOR_TERMINATE_CMD_ID;
    private static final int VIEW_LOG_CMD_ID;
    private static final int RUN_STOP_ON_ERROR_CMD_ID;
    private static final int RUN_STOP_ON_EXCEPTION_CMD_ID;
    private static final int RUN_STOP_ON_DEBUGGER_CMD_ID;
    private static final int RUN_TRANSFER_ERRORS_CMD_ID;
    private static final int RUN_STOP_IN_CHROME_CMD_ID;
    private static final int RUN_GARBAGE_COLLECT_CMD_ID;
    private boolean addedJSMenus = false;
    private static final boolean testSimpleProcessExec = false;
    private static RunProcess activeRunProcess;
    private static Map currentTerminateActions;
    private static int countTerminateCommands;

    RunManagerUI() {
    }

    public void initialize() {
        new RunManagerDockableFactory();
        this.createActions();
        this.createRunMenus();
        Ide.addIdeListener((IdeListener)this);
    }

    private void viewLogPage(RunProcess runProcess, boolean raise) {
        LogPage lp = runProcess.getLogPage();
        if (lp instanceof RunLogPage) {
            RunLogPage runLogPage = (RunLogPage)lp;
            if (raise) {
                runLogPage.show();
            } else {
                runLogPage.showPage();
            }
        }
    }

    boolean isActiveRunProcess(RunProcess runProcess) {
        return runProcess.equals(activeRunProcess);
    }

    private void createActions() {
        String ACTION_CATEGORY_VIEW = IdeMainWindow.ACTION_CATEGORY_VIEW;
        actionViewRunManager = IdeAction.get((int)VIEW_RUN_MANAGER_CMD_ID, null, (String)RunMgrArb.getString((int)2), (String)ACTION_CATEGORY_VIEW, (Integer)RunMgrArb.getInteger((int)3), (ArrayResourceBundle)RunMgrArb.getInstance(), (int)4, null, (boolean)true);
        actionViewRunManager.addController((Controller)this);
        JMenu viewMenu = MenuManager.getJMenu((String)"View");
        viewMenu.addMenuListener(this);
        actionNavigatorTerminate = IdeAction.get((int)NAVIGATOR_TERMINATE_CMD_ID, null, (String)IdeArb.getString((int)151), null, (Integer)IdeArb.getInteger((int)152), (Icon)OracleIcons.getIcon((String)"terminate.png"), null, (boolean)true);
        actionNavigatorTerminate.addController((Controller)this);
        actionViewLog = IdeAction.get((int)VIEW_LOG_CMD_ID, null, (String)RunMgrArb.getString((int)13), (String)ACTION_CATEGORY_VIEW, (Integer)RunMgrArb.getInteger((int)14), (Icon)OracleIcons.getIcon((String)"log.png"), null, (boolean)false);
        actionViewLog.addController((Controller)this);
        this.addJSMenus();
    }

    private void createRunMenus() {
        Menubar menuMgr = Ide.getMenubar();
        JMenu runMenu = MenuManager.getJMenu((String)"Run");
        if (runMenu == null) {
            String runMenuLabel = RunnerBundle.get("RUN_MENU");
            runMenu = menuMgr.createMenu(runMenuLabel, MenuConstants.WEIGHT_RUN_MENU, MenuConstants.SECTION_RUN_ADDINS);
            MenuManager.putJMenu((String)"Run", (JMenu)runMenu);
            menuMgr.add((Component)runMenu);
        }
        menuMgr.add((Component)runMenu);
        terminateSubMenu = menuMgr.createSubMenu(IdeArb.getString((int)151), IdeArb.getInteger((int)152), MenuConstants.WEIGHT_RUN_TERMINATE);
        emptyItem = new JMenuItem(IdeArb.getString((int)234));
        emptyItem.setEnabled(false);
        terminateSubMenu.add(emptyItem);
        terminateSubMenu.setEnabled(false);
        if (!Product.isRaptor()) {
            menuMgr.add((Component)terminateSubMenu, runMenu, MenuConstants.SECTION_RUN_TERMINATE);
        }
    }

    private void addJSMenus() {
        if (this.addedJSMenus) {
            return;
        }
        this.addedJSMenus = true;
        actionStopOnError = IdeAction.get((int)RUN_STOP_ON_ERROR_CMD_ID, null, (String)IdeArb.getString((int)467), null, (Integer)IdeArb.getInteger((int)468), (ResourceBundle)IdeArb.getInstance(), null, null, (boolean)true);
        actionStopOnError.putValue("Check", (Object)true);
        actionStopOnError.addController((Controller)this);
        actionStopOnException = IdeAction.get((int)RUN_STOP_ON_EXCEPTION_CMD_ID, null, (String)IdeArb.getString((int)469), null, (Integer)IdeArb.getInteger((int)470), (ResourceBundle)IdeArb.getInstance(), (String)"", null, (boolean)true);
        actionStopOnException.putValue("Check", (Object)true);
        actionStopOnException.addController((Controller)this);
        actionStopOnDebugger = IdeAction.get((int)RUN_STOP_ON_DEBUGGER_CMD_ID, null, (String)IdeArb.getString((int)471), null, (Integer)IdeArb.getInteger((int)472), (ResourceBundle)IdeArb.getInstance(), null, null, (boolean)true);
        actionStopOnDebugger.putValue("Check", (Object)true);
        actionStopOnDebugger.addController((Controller)this);
        actionTransferErrors = IdeAction.get((int)RUN_TRANSFER_ERRORS_CMD_ID, null, (String)IdeArb.getString((int)473), null, (Integer)IdeArb.getInteger((int)474), (ResourceBundle)IdeArb.getInstance(), null, null, (boolean)true);
        actionTransferErrors.putValue("Check", (Object)true);
        actionTransferErrors.addController((Controller)this);
        actionStopInChrome = IdeAction.get((int)RUN_STOP_IN_CHROME_CMD_ID, null, (String)IdeArb.getString((int)475), null, (Integer)IdeArb.getInteger((int)476), (ResourceBundle)IdeArb.getInstance(), null, null, (boolean)true);
        actionStopInChrome.putValue("Check", (Object)true);
        actionStopInChrome.addController((Controller)this);
        actionGarbageCollect = IdeAction.get((int)RUN_GARBAGE_COLLECT_CMD_ID, null, (String)IdeArb.getString((int)477), null, (Integer)IdeArb.getInteger((int)478), (ResourceBundle)IdeArb.getInstance(), null, null, (boolean)true);
        actionGarbageCollect.addController((Controller)this);
    }

    void addTerminateMenu(RunProcess runProcess) {
        if (currentTerminateActions == null) {
            currentTerminateActions = new HashMap(10);
        }
        int cmdId = Ide.findOrCreateCmdID((String)(RUN_TERMINATE_CMD_PREFIX + ++countTerminateCommands));
        IdeAction terminateAction = IdeAction.get((int)cmdId, null, (String)runProcess.getShortLabel(), (String)null, null, (Icon)runProcess.getIcon(), null, (boolean)true);
        terminateAction.addController((Controller)this);
        currentTerminateActions.put(terminateAction, runProcess);
        if (terminateSubMenu.getItem(0) == emptyItem) {
            terminateSubMenu.remove(0);
        }
        terminateSubMenu.setEnabled(true);
        JMenuItem menuItem = Ide.getMenubar().createMenuItem((ToggleAction)terminateAction);
        terminateSubMenu.add(menuItem);
        terminateAction.putValue("UserData", (Object)menuItem);
    }

    void removeTerminateMenu(RunProcess runProcess) {
        for (IdeAction terminateAction : currentTerminateActions.keySet()) {
            if (!currentTerminateActions.get(terminateAction).equals(runProcess)) continue;
            currentTerminateActions.remove(terminateAction);
            JMenuItem menuItem = (JMenuItem)terminateAction.getValue("UserData");
            terminateSubMenu.remove(menuItem);
            menuItem.setAction(null);
            terminateAction.putValue("UserData", null);
            terminateAction.removeController((Controller)this);
            IdeAction.remove((int)terminateAction.getCommandId());
            if (terminateSubMenu.getItemCount() != 0) break;
            terminateSubMenu.add(emptyItem);
            terminateSubMenu.setEnabled(false);
            break;
        }
    }

    private void addPopupAction(IdeAction action, Context context, ContextMenu popup) {
        if (action != null) {
            this.update(action, context);
            if (action.isEnabled()) {
                popup.add((Component)popup.createMenuItem((ToggleAction)action));
            }
        }
    }

    public void addinsLoaded(IdeEvent e) {
    }

    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener((IdeListener)this);
        Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
        Debugger debugger = Debugger.getDebugger();
        if (debugger != null) {
            boolean selected;
            String cls;
            DebuggerHook hook = (DebuggerHook)ExtensionRegistry.getExtensionRegistry().getHook(DebuggerHook.ELEMENT);
            for (DebuggerHook.ObjectPreferencesExpression expr : hook.getExpressions()) {
                cls = expr.getClassName();
                selected = expr.isSelected();
                debugger.addObjectPreferencesExpression(cls, expr.getExpression(), selected);
            }
            for (DebuggerHook.ObjectPreferencesExpansion expansion : hook.getExpansions()) {
                cls = expansion.getClassName();
                selected = expansion.isSelected();
                String expressions = expansion.getExpressions();
                debugger.addObjectPreferencesExpansion(cls, expressions, selected);
            }
            for (DebuggerHook.ObjectPreferencesHideAllFields hideAllFields : hook.getHideAllFields()) {
                cls = hideAllFields.getClassName();
                debugger.addObjectPreferencesHideAllFields(cls);
            }
            for (DebuggerHook.ObjectPreferencesHideField hideField : hook.getHideFields()) {
                cls = hideField.getClassName();
                String fieldName = hideField.getFieldName();
                debugger.addObjectPreferencesHideField(cls, fieldName);
            }
            for (DebuggerHook.ObjectPreferencesIcon icon : hook.getIcons()) {
                cls = icon.getClassName();
                String iconName = icon.getIconName();
                debugger.addObjectPreferencesIcon(cls, iconName);
            }
            hook.dispose();
        }
    }

    public void mainWindowClosing(IdeEvent e) {
        Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        JMenu viewMenu;
        Object source = e.getSource();
        if (source == (viewMenu = MenuManager.getJMenu((String)"View"))) {
            viewMenu.removeMenuListener(this);
            Menubar menubar = Ide.getMenubar();
            JMenuItem menuitemViewRunManager = menubar.createMenuItem((ToggleAction)actionViewRunManager);
            menubar.add((Component)menuitemViewRunManager, viewMenu, MenuConstants.SECTION_VIEW_ALPHABETIZED_VIEWS);
        }
    }

    public void activeViewChanged(ActiveViewEvent e) {
        RunProcess runProcess;
        View activeView = Ide.getMainWindow().getLastActiveView();
        if (activeView instanceof RunLogPage && (runProcess = ((RunLogPage)activeView).getRunProcess()) != null) {
            Runner.getRunner().selectProcess(runProcess);
        }
    }

    public boolean handleEvent(IdeAction action, Context context) {
        RunProcess runProcess;
        int cmdId = action.getCommandId();
        if (cmdId == VIEW_RUN_MANAGER_CMD_ID) {
            Runner.getRunner().viewRunManager();
            return true;
        }
        if (cmdId == NAVIGATOR_TERMINATE_CMD_ID) {
            Element[] selection = context.getSelection();
            if (selection != null) {
                for (Element element : selection) {
                    if (!(element instanceof RunProcess)) continue;
                    RunProcess runProcess2 = (RunProcess)element;
                    runProcess2.terminate();
                }
            }
            return true;
        }
        if (cmdId == VIEW_LOG_CMD_ID) {
            Element element;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (element = selection[0]) instanceof RunProcess) {
                this.viewLogPage((RunProcess)element, true);
            }
            return true;
        }
        if (cmdId == RUN_STOP_ON_ERROR_CMD_ID) {
            Element elem;
            boolean canStopOnError = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess3 = (RunProcess)elem;
                if (runProcess3.canStopOnError()) {
                    canStopOnError = true;
                }
                action.setEnabled(canStopOnError);
                if (canStopOnError) {
                    runProcess3.setStopOnError(!runProcess3.getStopOnError());
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_ON_EXCEPTION_CMD_ID) {
            Element elem;
            boolean canStopOnException = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess4 = (RunProcess)elem;
                if (runProcess4.canStopOnException()) {
                    canStopOnException = true;
                }
                action.setEnabled(canStopOnException);
                if (canStopOnException) {
                    runProcess4.setStopOnException(!runProcess4.getStopOnException());
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_ON_DEBUGGER_CMD_ID) {
            Element elem;
            boolean canStopOnDebugger = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess5 = (RunProcess)elem;
                if (runProcess5.canStopOnDebuggerStatement()) {
                    canStopOnDebugger = true;
                }
                action.setEnabled(canStopOnDebugger);
                if (canStopOnDebugger) {
                    runProcess5.setStopOnDebuggerStatement(!runProcess5.getStopOnDebuggerStatement());
                }
            }
            return true;
        }
        if (cmdId == RUN_TRANSFER_ERRORS_CMD_ID) {
            Element elem;
            boolean canTransferErrors = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess6 = (RunProcess)elem;
                if (runProcess6.canTransferErrors()) {
                    canTransferErrors = true;
                }
                action.setEnabled(canTransferErrors);
                if (canTransferErrors) {
                    runProcess6.setTransferErrors(!runProcess6.getTransferErrors());
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_IN_CHROME_CMD_ID) {
            Element elem;
            boolean canStopInChrome = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess7 = (RunProcess)elem;
                if (runProcess7.canStopInChrome()) {
                    canStopInChrome = true;
                }
                action.setEnabled(canStopInChrome);
                if (canStopInChrome) {
                    runProcess7.setStopInChrome(!runProcess7.getStopInChrome());
                }
            }
            return true;
        }
        if (cmdId == RUN_GARBAGE_COLLECT_CMD_ID) {
            Element elem;
            boolean canGarbageCollect = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess8 = (RunProcess)elem;
                if (runProcess8.canGarbageCollect()) {
                    canGarbageCollect = true;
                }
                action.setEnabled(canGarbageCollect);
                if (canGarbageCollect) {
                    runProcess8.doGarbageCollection();
                }
            }
            return true;
        }
        if (currentTerminateActions != null && (runProcess = (RunProcess)currentTerminateActions.get(action)) != null) {
            runProcess.terminate();
            return true;
        }
        return false;
    }

    public boolean update(IdeAction action, Context context) {
        RunProcess runProcess;
        int cmdId = action.getCommandId();
        if (cmdId == VIEW_RUN_MANAGER_CMD_ID) {
            return true;
        }
        if (cmdId == NAVIGATOR_TERMINATE_CMD_ID) {
            int length;
            boolean canTerminate = false;
            Element[] selection = context.getSelection();
            if (selection != null && (length = selection.length) > 0) {
                int countCanTerminate = 0;
                for (int i = 0; i < length; ++i) {
                    RunProcess runProcess2;
                    Element element = selection[i];
                    if (!(element instanceof RunProcess) || !(runProcess2 = (RunProcess)element).canTerminate()) continue;
                    ++countCanTerminate;
                }
                if (countCanTerminate == length) {
                    canTerminate = true;
                }
            }
            action.setEnabled(canTerminate);
            return true;
        }
        if (cmdId == VIEW_LOG_CMD_ID) {
            boolean canView = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1) {
                canView = selection[0] instanceof RunProcess;
            }
            action.setEnabled(canView);
            return true;
        }
        if (cmdId == RUN_STOP_ON_ERROR_CMD_ID) {
            Element elem;
            boolean canStopOnError = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess3 = (RunProcess)elem;
                if (runProcess3.canStopOnError()) {
                    canStopOnError = true;
                }
                action.setEnabled(canStopOnError);
                if (canStopOnError) {
                    if (runProcess3.getStopOnError()) {
                        action.setState(true);
                    } else {
                        action.setState(false);
                    }
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_ON_EXCEPTION_CMD_ID) {
            Element elem;
            boolean canStopOnException = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess4 = (RunProcess)elem;
                if (runProcess4.canStopOnException()) {
                    canStopOnException = true;
                }
                action.setEnabled(canStopOnException);
                if (canStopOnException) {
                    if (runProcess4.getStopOnException()) {
                        action.setState(true);
                    } else {
                        action.setState(false);
                    }
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_ON_DEBUGGER_CMD_ID) {
            Element elem;
            boolean canStopOnDebugger = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess5 = (RunProcess)elem;
                if (runProcess5.canStopOnDebuggerStatement()) {
                    canStopOnDebugger = true;
                }
                action.setEnabled(canStopOnDebugger);
                if (canStopOnDebugger) {
                    if (runProcess5.getStopOnDebuggerStatement()) {
                        action.setState(true);
                    } else {
                        action.setState(false);
                    }
                }
            }
            return true;
        }
        if (cmdId == RUN_TRANSFER_ERRORS_CMD_ID) {
            Element elem;
            boolean canTransferErrors = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess6 = (RunProcess)elem;
                if (runProcess6.canTransferErrors()) {
                    canTransferErrors = true;
                }
                action.setEnabled(canTransferErrors);
                if (canTransferErrors) {
                    if (runProcess6.getTransferErrors()) {
                        action.setState(true);
                    } else {
                        action.setState(false);
                    }
                }
            }
            return true;
        }
        if (cmdId == RUN_STOP_IN_CHROME_CMD_ID) {
            Element elem;
            boolean canStopInChrome = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess7 = (RunProcess)elem;
                if (runProcess7.canStopInChrome()) {
                    canStopInChrome = true;
                }
                action.setEnabled(canStopInChrome);
                if (canStopInChrome) {
                    if (runProcess7.getStopInChrome()) {
                        action.setState(true);
                    } else {
                        action.setState(false);
                    }
                }
            }
            return true;
        }
        if (cmdId == RUN_GARBAGE_COLLECT_CMD_ID) {
            Element elem;
            boolean canGarbageCollect = false;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length == 1 && (elem = selection[0]) instanceof RunProcess) {
                RunProcess runProcess8 = (RunProcess)elem;
                if (runProcess8.canGarbageCollect()) {
                    canGarbageCollect = true;
                }
                action.setEnabled(canGarbageCollect);
            }
            return true;
        }
        if (currentTerminateActions != null && (runProcess = (RunProcess)currentTerminateActions.get(action)) != null) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }

    public void viewSelectionChanged(ViewSelectionEvent e) {
        Element element;
        Element[] sel;
        RunProcess newActiveRunProcess = null;
        Context context = Runner.getRunner().getRunManagerWindow().getContext();
        if (context != null && (sel = context.getSelection()) != null && sel.length > 0 && (element = sel[sel.length - 1]) instanceof RunProcess) {
            newActiveRunProcess = (RunProcess)element;
        }
        RunProcess prevActiveRunProcess = activeRunProcess;
        if (activeRunProcess != null) {
            activeRunProcess.unselected();
            activeRunProcess = null;
        }
        if (newActiveRunProcess != null) {
            if (prevActiveRunProcess == null || !prevActiveRunProcess.hasFinished()) {
                this.viewLogPage(newActiveRunProcess, false);
            }
            activeRunProcess = newActiveRunProcess;
            activeRunProcess.selected();
        }
        View activeView = Ide.getMainWindow().getLastActiveView();
        Dockable activeDockable = null;
        for (View view = activeView; view != null; view = view.owner()) {
            if (!(view instanceof Dockable)) continue;
            activeDockable = (Dockable)view;
            break;
        }
        Layouts layouts = Layouts.getLayouts();
        IdeLayout layout = null;
        if (activeRunProcess != null) {
            layout = activeRunProcess.getProcessLayout();
            if (layout == null) {
                layout = layouts.getDesignLayout();
            }
        } else if (Runner.getRunner().getProcessesFolder().size() == 0) {
            layout = layouts.getDesignLayout();
        }
        if (layout != null && !layout.equals((Object)layouts.getActiveLayout())) {
            layouts.activateLayout(layout);
        }
        if ((activeView instanceof RunManagerWindow || activeView instanceof LogPage) && !activeView.isVisible() && activeDockable != null) {
            DockStation.getDockStation().setDockableVisible(activeDockable, true);
        }
    }

    void menuWillShow(ContextMenu popup) {
        Context context = popup.getContext();
        if (context != null && context.getView() instanceof RunManagerWindow) {
            NavigatorConstants.removeNewMenuItem((ContextMenu)popup);
        }
        this.addPopupAction(actionNavigatorTerminate, context, popup);
        if (context != null && context.getView().getId().equals("RunManagerWindow")) {
            this.addPopupAction(actionViewLog, context, popup);
            this.addPopupAction(actionStopOnError, context, popup);
            this.addPopupAction(actionStopOnException, context, popup);
            this.addPopupAction(actionStopOnDebugger, context, popup);
            this.addPopupAction(actionTransferErrors, context, popup);
            this.addPopupAction(actionStopInChrome, context, popup);
            this.addPopupAction(actionGarbageCollect, context, popup);
        }
    }

    void menuWillHide(ContextMenu popup) {
    }

    boolean handleDefaultAction(Context context) {
        Element element;
        Element[] sel;
        if (context != null && (sel = context.getSelection()) != null && sel.length > 0 && (element = sel[sel.length - 1]) instanceof RunProcess) {
            RunProcess runProcess = (RunProcess)element;
            runProcess.doubleClicked();
            return true;
        }
        return false;
    }

    static {
        VIEW_RUN_MANAGER_CMD_ID = Ide.findOrCreateCmdID((String)"ViewRunManager");
        NAVIGATOR_TERMINATE_CMD_ID = Ide.findOrCreateCmdID((String)"TerminateCommand");
        VIEW_LOG_CMD_ID = Ide.findOrCreateCmdID((String)"RunManagerViewLogCommand");
        RUN_STOP_ON_ERROR_CMD_ID = Ide.findOrCreateCmdID((String)"JSStopOnError");
        RUN_STOP_ON_EXCEPTION_CMD_ID = Ide.findOrCreateCmdID((String)"JSStopOnException");
        RUN_STOP_ON_DEBUGGER_CMD_ID = Ide.findOrCreateCmdID((String)"JSStopOnDebuggerStatement");
        RUN_TRANSFER_ERRORS_CMD_ID = Ide.findOrCreateCmdID((String)"JSTransferErrors");
        RUN_STOP_IN_CHROME_CMD_ID = Ide.findOrCreateCmdID((String)"JSStopInChrome");
        RUN_GARBAGE_COLLECT_CMD_ID = Ide.findOrCreateCmdID((String)"JSGarbageCollect");
    }
}

