/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.event.EventListenerList;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.ExitCommand;
import oracle.ide.cmd.ShutdownHook;
import oracle.ide.config.Preferences;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuManager;
import oracle.ide.docking.DockUtil;
import oracle.ide.docking.DockableView;
import oracle.ide.exception.SingletonClassException;
import oracle.ide.layout.Layouts;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.navigator.NavigatorWindow;
import oracle.ide.panels.Navigable;
import oracle.ide.runner.AbstractStarterFactory;
import oracle.ide.runner.RunProcess;
import oracle.ide.runner.RunProcessLifecycleListener;
import oracle.ide.runner.Runner;
import oracle.ide.runner.RunnerOptions;
import oracle.ide.runner.StarterFactory;
import oracle.ideimpl.resource.RunMgrArb;
import oracle.ideimpl.runner.BaseRunnerFolder;
import oracle.ideimpl.runner.Processes;
import oracle.ideimpl.runner.RunManagerUI;
import oracle.ideimpl.runner.RunManagerWindow;
import oracle.ideimpl.runner.StarterFactoryWrapper;
import oracle.javatools.data.PropertyStorage;

public final class RunManager
extends BaseRunnerFolder
implements Addin {
    private static RunManager instance;
    private static RunManagerUI instanceUI;
    private static boolean hasUI;
    static Runner runner;
    private static Map registeredStarterFactories;
    private static List runConfigurationLaunchNavigables;
    private static List runConfigurationToolNavigables;
    private static RunManagerWindow runManagerWindow;
    private static Processes processes;
    private static RunnerOptions runnerOptions;

    public RunManager() throws SingletonClassException {
        if (instance != null) {
            throw new SingletonClassException("oracle.ide.runner.RunManager");
        }
        instance = this;
        hasUI = Ide.getIdeArgs().getCreateUI();
    }

    private RunManagerUI getUI() {
        if (instanceUI == null && hasUI) {
            instanceUI = (RunManagerUI)AddinManager.getAddinManager().getAddin(RunManagerUI.class);
        }
        return instanceUI;
    }

    @Override
    public String getShortLabel() {
        return RunMgrArb.getString((int)6);
    }

    public void initialize() {
        registeredStarterFactories = new HashMap();
        runConfigurationLaunchNavigables = new ArrayList();
        runConfigurationToolNavigables = new ArrayList();
        runner = new RunnerImpl();
        Runner.setRunner(runner);
        RunManager.initializeIdeSettings();
    }

    boolean isActiveRunProcess(RunProcess runProcess) {
        RunManagerUI runManagerUI = this.getUI();
        if (runManagerUI != null) {
            return runManagerUI.isActiveRunProcess(runProcess);
        }
        return false;
    }

    private static void initializeIdeSettings() {
        Preferences p = Preferences.getPreferences();
        runnerOptions = RunnerOptions.getInstance((PropertyStorage)p);
    }

    static {
        instanceUI = null;
    }

    private class RunnerImpl
    extends Runner
    implements ShutdownHook {
        private boolean shuttingDown = false;
        private EventListenerList listeners = new EventListenerList();

        RunnerImpl() {
            ExitCommand.addShutdownHook((ShutdownHook)this);
        }

        @Override
        public boolean isRunning(Project project) {
            if (processes != null) {
                for (RunProcess runProcess : processes.getRunProcesses()) {
                    if (project != null && project != runProcess.getProject()) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean terminate(Project project, boolean force) {
            if (processes != null) {
                ArrayList<RunProcess> temp = new ArrayList<RunProcess>();
                for (RunProcess runProcess : processes.getRunProcesses()) {
                    if (project != null && project != runProcess.getProject()) continue;
                    temp.add(runProcess);
                }
                int length = temp.size();
                if (length > 0) {
                    boolean kill;
                    if (force) {
                        kill = true;
                    } else {
                        String title;
                        Object[] messages = new Object[1 + length];
                        int im = 0;
                        if (length == 1) {
                            messages[im++] = RunMgrArb.getString((int)11);
                            title = RunMgrArb.getString((int)9);
                        } else {
                            messages[im++] = RunMgrArb.getString((int)12);
                            title = RunMgrArb.getString((int)10);
                        }
                        for (RunProcess runProcess : temp) {
                            JLabel label = new JLabel(runProcess.getShortLabel(), runProcess.getIcon(), 2);
                            messages[im++] = label;
                        }
                        int answer = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), messages, title, 0, 3);
                        boolean bl = kill = answer == 0;
                    }
                    if (kill) {
                        this.shuttingDown = true;
                        for (RunProcess runProcess : temp) {
                            runProcess.terminate();
                        }
                        Layouts layouts = Layouts.getLayouts();
                        layouts.activateLayout(layouts.getDesignLayout());
                    } else {
                        return false;
                    }
                }
            }
            return true;
        }

        @Override
        public JMenu getRunMenu() {
            return MenuManager.getJMenu((String)"Run");
        }

        @Override
        public synchronized NavigatorWindow getRunManagerWindow() {
            RunManagerUI runManagerUI = RunManager.this.getUI();
            if (runManagerUI != null) {
                if (runManagerWindow == null) {
                    Context context = Context.newIdeContext((Element)RunManager.this);
                    context.setProject(null);
                    context.setWorkspace(null);
                    runManagerWindow = new RunManagerWindow(context, RunManager.this);
                    runManagerWindow.setToolbarVisible(true);
                    runManagerWindow.addViewSelectionListener(runManagerUI);
                    this.getProcessesFolder();
                }
                return runManagerWindow;
            }
            return null;
        }

        @Override
        public Folder getRunManagerFolder() {
            this.getRunManagerWindow();
            return RunManager.this;
        }

        @Override
        public synchronized Folder getProcessesFolder() {
            if (processes == null) {
                try {
                    processes = new Processes(RunManager.this);
                    this.getRunManagerFolder().add((Element)processes);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return processes;
        }

        @Override
        public synchronized RunProcess[] getRunProcesses() {
            return processes.getRunProcesses();
        }

        @Override
        public void viewRunManager() {
            DockUtil.showDockableWindow((DockableView)this.getRunManagerWindow());
        }

        @Override
        public boolean isRunManagerVisible() {
            if (runManagerWindow == null) {
                return false;
            }
            return runManagerWindow.isVisible();
        }

        @Override
        public IdeAction getViewRunManagerAction() {
            return IdeAction.find((int)RunManagerUI.VIEW_RUN_MANAGER_CMD_ID);
        }

        @Override
        public boolean selectProcess(RunProcess runProcess) {
            return ((RunManagerWindow)this.getRunManagerWindow()).selectProcess(runProcess);
        }

        @Override
        public void addTerminateMenu(RunProcess runProcess) {
            RunManagerUI runManagerUI = RunManager.this.getUI();
            if (runManagerUI != null) {
                runManagerUI.addTerminateMenu(runProcess);
            }
        }

        @Override
        public void removeTerminateMenu(RunProcess runProcess) {
            RunManagerUI runManagerUI = RunManager.this.getUI();
            if (runManagerUI != null) {
                runManagerUI.removeTerminateMenu(runProcess);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerStarterFactory(Class targetClass, StarterFactory starterFactory) {
            if (!(starterFactory instanceof AbstractStarterFactory)) {
                starterFactory = new StarterFactoryWrapper(starterFactory);
            }
            if (((AbstractStarterFactory)starterFactory).canBeRegistered()) {
                Map map = registeredStarterFactories;
                synchronized (map) {
                    ArrayList<StarterFactory> factories = (ArrayList<StarterFactory>)registeredStarterFactories.get(targetClass);
                    if (factories == null) {
                        factories = new ArrayList<StarterFactory>();
                        registeredStarterFactories.put(targetClass, factories);
                    }
                    factories.add(0, starterFactory);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unregisterStarterFactory(Class targetClass, StarterFactory starterFactory) {
            Map map = registeredStarterFactories;
            synchronized (map) {
                List factories = (List)registeredStarterFactories.get(targetClass);
                if (factories != null) {
                    if (!factories.remove(starterFactory)) {
                        for (Object o : factories) {
                            if (!(o instanceof StarterFactoryWrapper) || !((StarterFactoryWrapper)o).getStarterFactory().equals(starterFactory)) continue;
                            factories.remove(o);
                            break;
                        }
                    }
                    if (factories.isEmpty()) {
                        registeredStarterFactories.remove(targetClass);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Class[] getClassesWithRegisteredStarterFactory() {
            Map map = registeredStarterFactories;
            synchronized (map) {
                return registeredStarterFactories.keySet().toArray(new Class[registeredStarterFactories.size()]);
            }
        }

        @Override
        public AbstractStarterFactory[] getRegisteredStarterFactories(Class targetClass) {
            return this.getRegisteredStarterFactories(targetClass, null);
        }

        private boolean checkStarterFactorySubClass(Class starterFactorySubClass, Object starterFactory) {
            if (starterFactorySubClass == null) {
                return true;
            }
            if (starterFactorySubClass.isAssignableFrom(starterFactory.getClass())) {
                return true;
            }
            if (starterFactory instanceof StarterFactoryWrapper) {
                return this.checkStarterFactorySubClass(starterFactorySubClass, ((StarterFactoryWrapper)starterFactory).getStarterFactory());
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractStarterFactory[] getRegisteredStarterFactories(Class targetClass, Class starterFactorySubClass) {
            Map map = registeredStarterFactories;
            synchronized (map) {
                ArrayList list = new ArrayList();
                List factories = (List)registeredStarterFactories.get(targetClass);
                for (Object starterFactory : factories) {
                    if (!this.checkStarterFactorySubClass(starterFactorySubClass, starterFactory)) continue;
                    list.add(starterFactory);
                }
                return list.toArray(new AbstractStarterFactory[list.size()]);
            }
        }

        @Override
        public AbstractStarterFactory[] getStarterFactoriesForTarget(Class targetClass) {
            return this.getStarterFactoriesForTarget(targetClass, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractStarterFactory[] getStarterFactoriesForTarget(Class targetClass, Class starterFactorySubClass) {
            Map map = registeredStarterFactories;
            synchronized (map) {
                ArrayList list = new ArrayList();
                for (Class registeredClass : registeredStarterFactories.keySet()) {
                    if (!registeredClass.isAssignableFrom(targetClass)) continue;
                    List factories = (List)registeredStarterFactories.get(registeredClass);
                    for (Object starterFactory : factories) {
                        if (!this.checkStarterFactorySubClass(starterFactorySubClass, starterFactory)) continue;
                        list.add(starterFactory);
                    }
                }
                return list.toArray(new AbstractStarterFactory[list.size()]);
            }
        }

        @Override
        public boolean couldNodeBeRunnable(Node node) {
            return this.couldNodeBeRunnable(node, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean couldNodeBeRunnable(Node node, Class starterFactorySubClass) {
            if (node != null) {
                Class<?> targetClass = node.getClass();
                Map map = registeredStarterFactories;
                synchronized (map) {
                    for (Class registeredClass : registeredStarterFactories.keySet()) {
                        if (!registeredClass.isAssignableFrom(targetClass)) continue;
                        List factories = (List)registeredStarterFactories.get(registeredClass);
                        for (Object starterFactory : factories) {
                            if (!this.checkStarterFactorySubClass(starterFactorySubClass, starterFactory)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean enableRunDebugActions(Context context, Class starterFactorySubClass) {
            Node node = RunProcess.getContextNodeForRun(context);
            if (node != null) {
                if (node instanceof Project && node == context.getProject()) {
                    return true;
                }
                Class<?> targetClass = node.getClass();
                Map map = registeredStarterFactories;
                synchronized (map) {
                    for (Class registeredClass : registeredStarterFactories.keySet()) {
                        if (!registeredClass.isAssignableFrom(targetClass)) continue;
                        List factories = (List)registeredStarterFactories.get(registeredClass);
                        for (Object starterFactory : factories) {
                            AbstractStarterFactory abstractStarterFactory;
                            if (!this.checkStarterFactorySubClass(starterFactorySubClass, starterFactory) || !(abstractStarterFactory = (AbstractStarterFactory)starterFactory).enableRunDebugActions(context)) continue;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        @Override
        public Navigable getProjectSettingsRunnerNavigable() {
            return null;
        }

        @Override
        public void setProjectSettingsRunnerNavigable(Navigable navigable) {
        }

        @Override
        public void addRunConfigurationLaunchNavigable(Navigable navigable) {
            runConfigurationLaunchNavigables.add(navigable);
        }

        @Override
        public Navigable[] getRunConfigurationLaunchNavigables() {
            return runConfigurationLaunchNavigables.toArray(new Navigable[runConfigurationLaunchNavigables.size()]);
        }

        @Override
        public void addRunConfigurationToolNavigable(Navigable navigable) {
            runConfigurationToolNavigables.add(navigable);
        }

        @Override
        public Navigable[] getRunConfigurationToolNavigables() {
            return runConfigurationToolNavigables.toArray(new Navigable[runConfigurationToolNavigables.size()]);
        }

        @Override
        public RunProcess[] getContainedRunProcesses(RunProcess container) {
            ArrayList<RunProcess> procs = new ArrayList<RunProcess>();
            RunProcess[] allprocs = this.getRunProcesses();
            if (allprocs != null) {
                for (RunProcess runProcess : allprocs) {
                    if (runProcess.hasFinished() || runProcess.getContainer() != container) continue;
                    procs.add(runProcess);
                }
            }
            return procs.toArray(new RunProcess[procs.size()]);
        }

        @Override
        public boolean isShuttingDown() {
            return this.shuttingDown;
        }

        @Override
        public void addLifecycleListener(RunProcessLifecycleListener listener) {
            this.listeners.add(RunProcessLifecycleListener.class, listener);
        }

        @Override
        public void removeLifecycleListener(RunProcessLifecycleListener listener) {
            for (RunProcessLifecycleListener l : (RunProcessLifecycleListener[])this.listeners.getListeners(RunProcessLifecycleListener.class)) {
                if (l != listener) continue;
                this.listeners.remove(RunProcessLifecycleListener.class, listener);
            }
        }

        @Override
        public EventListenerList getListeners() {
            return this.listeners;
        }

        @Override
        public RunnerOptions getRunnerOptions() {
            if (runnerOptions == null) {
                RunManager.initializeIdeSettings();
            }
            return runnerOptions;
        }

        public void shutdown() {
            this.terminate(null, true);
        }

        public boolean canShutdown() {
            return !this.isRunning(null) || this.terminate(null, false);
        }
    }
}

