/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import oracle.ide.IdeHook;

public final class DebuggerHook
extends IdeHook {
    public static final ElementName ELEMENT = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "debugger-hook");
    private static final ElementName OBJECT_EXPRESSION = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "object-expression");
    private static final ElementName OBJECT_EXPANSION = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "object-expansion");
    private static final ElementName OBJECT_HIDE_FIELD = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "object-hide-field");
    private static final ElementName OBJECT_HIDE_ALL_FIELDS = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "object-hide-all-fields");
    private static final ElementName OBJECT_ICON = new ElementName("http://xmlns.oracle.com/jdeveloper/1013/extension", "object-icon");
    private List<ObjectPreferencesExpression> _expressions = new ArrayList<ObjectPreferencesExpression>();
    private final ElementVisitor _objectExpressionVisitor = new ObjectExpressionVisitor();
    private List<ObjectPreferencesExpansion> _expansions = new ArrayList<ObjectPreferencesExpansion>();
    private final ElementVisitor _objectExpansionVisitor = new ObjectExpansionVisitor();
    private List<ObjectPreferencesHideAllFields> _hideAllFields = new ArrayList<ObjectPreferencesHideAllFields>();
    private final ElementVisitor _objectHideAllFieldsVisitor = new ObjectHideAllFieldsVisitor();
    private List<ObjectPreferencesHideField> _hideFields = new ArrayList<ObjectPreferencesHideField>();
    private final ElementVisitor _objectHideFieldVisitor = new ObjectHideFieldVisitor();
    private List<ObjectPreferencesIcon> _icons = new ArrayList<ObjectPreferencesIcon>();
    private final ElementVisitor _objectIconVisitor = new ObjectIconVisitor();

    public List<ObjectPreferencesExpression> getExpressions() {
        return this._expressions;
    }

    public List<ObjectPreferencesExpansion> getExpansions() {
        return this._expansions;
    }

    public List<ObjectPreferencesHideAllFields> getHideAllFields() {
        return this._hideAllFields;
    }

    public List<ObjectPreferencesHideField> getHideFields() {
        return this._hideFields;
    }

    public List<ObjectPreferencesIcon> getIcons() {
        return this._icons;
    }

    public void dispose() {
        this._expressions = null;
        this._expansions = null;
        this._hideAllFields = null;
        this._hideFields = null;
        this._icons = null;
    }

    public void start(ElementStartContext context) {
        context.registerChildVisitor(OBJECT_EXPRESSION, this._objectExpressionVisitor);
        context.registerChildVisitor(OBJECT_EXPANSION, this._objectExpansionVisitor);
        context.registerChildVisitor(OBJECT_HIDE_ALL_FIELDS, this._objectHideAllFieldsVisitor);
        context.registerChildVisitor(OBJECT_HIDE_FIELD, this._objectHideFieldVisitor);
        context.registerChildVisitor(OBJECT_ICON, this._objectIconVisitor);
    }

    private final class ObjectIconVisitor
    extends ElementVisitor {
        private ObjectIconVisitor() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null || className.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'class'");
                return;
            }
            String iconName = context.getAttributeValue("icon");
            if (iconName == null || iconName.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'icon'");
            }
            DebuggerHook.this._icons.add(new ObjectPreferencesIcon(className, iconName));
        }
    }

    public static final class ObjectPreferencesIcon {
        private final String _className;
        private final String _iconName;

        private ObjectPreferencesIcon(String className, String iconName) {
            this._className = className;
            this._iconName = iconName;
        }

        public String getClassName() {
            return this._className;
        }

        public String getIconName() {
            return this._iconName;
        }
    }

    public static final class ObjectPreferencesHideField {
        private final String _className;
        private final String _fieldName;

        private ObjectPreferencesHideField(String className, String fieldName) {
            this._className = className;
            this._fieldName = fieldName;
        }

        public String getClassName() {
            return this._className;
        }

        public String getFieldName() {
            return this._fieldName;
        }
    }

    private final class ObjectHideFieldVisitor
    extends ElementVisitor {
        private ObjectHideFieldVisitor() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null || className.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'class'");
                return;
            }
            String fieldName = context.getAttributeValue("field");
            if (fieldName == null || fieldName.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'field'");
            }
            DebuggerHook.this._hideFields.add(new ObjectPreferencesHideField(className, fieldName));
        }
    }

    public static final class ObjectPreferencesHideAllFields {
        private final String _className;

        private ObjectPreferencesHideAllFields(String className) {
            this._className = className;
        }

        public String getClassName() {
            return this._className;
        }
    }

    private final class ObjectHideAllFieldsVisitor
    extends ElementVisitor {
        private ObjectHideAllFieldsVisitor() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null || className.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'class'");
                return;
            }
            DebuggerHook.this._hideAllFields.add(new ObjectPreferencesHideAllFields(className));
        }
    }

    public static final class ObjectPreferencesExpansion {
        private final String _className;
        private final String _expressions;
        private final boolean _selected;

        private ObjectPreferencesExpansion(String className, String expressions, boolean selected) {
            this._className = className;
            this._expressions = expressions;
            this._selected = selected;
        }

        public String getClassName() {
            return this._className;
        }

        public String getExpressions() {
            return this._expressions;
        }

        public boolean isSelected() {
            return this._selected;
        }
    }

    private final class ObjectExpansionVisitor
    extends ElementVisitor {
        private ObjectExpansionVisitor() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null || className.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'class'");
                return;
            }
            String expressions = context.getAttributeValue("expressions");
            if (expressions == null || expressions.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'expressions'");
            }
            Boolean selected = Boolean.valueOf(context.getAttributeValue("selected"));
            DebuggerHook.this._expansions.add(new ObjectPreferencesExpansion(className, expressions, selected));
        }
    }

    public static final class ObjectPreferencesExpression {
        private final String _className;
        private final String _expression;
        private final boolean _selected;

        private ObjectPreferencesExpression(String className, String expression, boolean selected) {
            this._className = className;
            this._expression = expression;
            this._selected = selected;
        }

        public String getClassName() {
            return this._className;
        }

        public String getExpression() {
            return this._expression;
        }

        public boolean isSelected() {
            return this._selected;
        }
    }

    private final class ObjectExpressionVisitor
    extends ElementVisitor {
        private ObjectExpressionVisitor() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className == null || className.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'class'");
                return;
            }
            String expression = context.getAttributeValue("expression");
            if (expression == null || expression.trim().length() == 0) {
                this.log((ElementContext)context, Level.SEVERE, "Missing attribute 'expression'");
            }
            Boolean selected = Boolean.valueOf(context.getAttributeValue("selected"));
            DebuggerHook.this._expressions.add(new ObjectPreferencesExpression(className, expression, selected));
        }
    }
}

