/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.runner;

import java.net.URL;
import java.util.Map;
import javax.swing.JMenu;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.runner.DebuggerAdapter;
import oracle.ide.runner.DebuggerExtender;
import oracle.ide.runner.DebuggerExtenderCallback;
import oracle.ide.runner.DebuggerInspectorExpressionProvider;
import oracle.ide.runner.DebuggerStartCallback;
import oracle.ide.runner.DebuggerWindowProvider;
import oracle.ide.runner.DebuggerWindowProviderCallback;
import oracle.ide.runner.SmartDataProvider;
import oracle.ide.runner.ToolTipExpressionProvider;
import oracle.javatools.jndi.Names;

public abstract class Debugger {
    private static final String DEBUGGER_NAME = "ide/debugger";

    public static Debugger getDebugger() {
        return (Debugger)Names.lookup((javax.naming.Context)Names.newInitialContext(), (String)DEBUGGER_NAME);
    }

    public static void setDebugger(Debugger debugger) {
        Names.bind((javax.naming.Context)Names.newInitialContext(), (String)DEBUGGER_NAME, (Object)debugger);
    }

    public abstract JMenu getDebugMenu();

    public abstract ContextMenu getContextMenu();

    public JMenu getViewMenu() {
        return null;
    }

    public abstract boolean isDebugging();

    public abstract void startDebugger(Context var1, DebuggerStartCallback var2);

    @Deprecated
    public abstract void redefineClasses(Map var1);

    public abstract void redefineClasses(Project var1, Map var2);

    public abstract boolean isStackTraceLine(String var1);

    public abstract boolean showSourceFileForStackTraceLine(Workspace var1, Project var2, String var3);

    public abstract URL parseStackTraceLine(Workspace var1, Project var2, String var3);

    public abstract boolean showSourceFileForStackTraceLine(Workspace var1, Project var2, URL var3);

    public abstract void addSmartDataProvider(SmartDataProvider var1);

    public abstract void removeSmartDataProvider(SmartDataProvider var1);

    public abstract void addToolTipExpressionProvider(ToolTipExpressionProvider var1);

    public abstract void removeToolTipExpressionProvider(ToolTipExpressionProvider var1);

    public abstract void addRunAndDebugToContextMenu(ContextMenu var1, Context var2);

    public abstract void addDebuggerListener(DebuggerAdapter var1);

    public abstract void removeDebuggerListener(DebuggerAdapter var1);

    public abstract Object evaluateNumericExpression(String var1);

    public DebuggerWindowProviderCallback addDebuggerWindowProvider(DebuggerWindowProvider provider) {
        return null;
    }

    public void removeDebuggerWindowProvider(DebuggerWindowProvider provider) {
    }

    public DebuggerExtenderCallback addDebuggerExtender(DebuggerExtender extender) {
        return null;
    }

    public void removeDebuggerExtender(DebuggerExtender extender) {
    }

    public abstract void addObjectPreferencesExpression(String var1, String var2, boolean var3);

    public abstract void addObjectPreferencesExpansion(String var1, String var2, boolean var3);

    public void addObjectPreferencesHideAllFields(String className) {
    }

    public void addObjectPreferencesHideField(String className, String fieldName) {
    }

    public void addObjectPreferencesIcon(String className, String iconName) {
    }

    public void addInspectorExpressionProvider(DebuggerInspectorExpressionProvider expressionProvider) {
    }

    public void removeInspectorExpressionProvider(DebuggerInspectorExpressionProvider expressionProvider) {
    }
}

