/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.List;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.Function;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SimpleSQLFragment;

public class WindowFunction
extends Function {
    private static final String OVER = "OVER";
    private static final String PARTITION_BY = "PARTITION BY";
    private static final String BETWEEN = "BETWEEN";
    private static final String AND = " AND ";
    private static final String UNBOUNDED = "UNBOUNDED";
    private static final String CURRENT_ROW = "CURRENT ROW";

    public WindowFunction() {
        this((String)null);
    }

    public WindowFunction(String func) {
        super(func, null, false);
    }

    public void setPartitionBy(SQLFragment[] frags) {
        this.getChildSupport("partitionBy").setChildArray(frags);
    }

    public SQLFragment[] getPartitionBy() {
        return this.getChildSupport("partitionBy").getChildArray(SQLFragment.class);
    }

    public void setOrderBy(OrderByObject[] frags) {
        this.getChildSupport("orderBy").setChildArray(frags);
    }

    public OrderByObject[] getOrderBy() {
        return this.getChildSupport("orderBy").getChildArray(OrderByObject.class);
    }

    public void setClauseType(ClauseType clauseType) {
        this.setProperty("clauseType", (Object)clauseType);
    }

    public ClauseType getClauseType() {
        return (ClauseType)((Object)this.getProperty("clauseType"));
    }

    public void setBounds(SQLFragment[] bounds) {
        this.getChildSupport("bounds").setChildArray(bounds);
    }

    public SQLFragment[] getBounds() {
        return this.getChildSupport("bounds").getChildArray(SQLFragment.class);
    }

    public String getSQLText() {
        boolean between;
        String funcSQL = super.getSQLText();
        List partitionBys = this.getChildSupport("partitionBy").getChildList(false);
        List orderBys = this.getChildSupport("orderBy").getChildList(false);
        List bounds = this.getChildSupport("bounds").getChildList(false);
        boolean partBy = partitionBys != null && partitionBys.size() > 0;
        boolean orderBy = orderBys != null && orderBys.size() > 0;
        boolean bl = between = bounds != null && bounds.size() == 2;
        if (partBy || orderBy) {
            ClauseType clauseType;
            StringBuilder buff2 = new StringBuilder();
            if (partBy) {
                buff2.append(" ").append(PARTITION_BY).append(" ");
                buff2.append(this.argsToString(partitionBys, true, ", ", 0));
            }
            if (orderBy) {
                buff2.append(" ").append("ORDER BY").append(" ");
                buff2.append(this.argsToString(orderBys, true, ", ", 0));
            }
            if ((clauseType = this.getClauseType()) != null) {
                buff2.append(" ").append(clauseType.toString()).append(" ");
                if (between) {
                    buff2.append(BETWEEN).append(" ");
                }
                buff2.append(this.argsToString(bounds, false, AND, 0));
            }
            StringBuilder buff = new StringBuilder(funcSQL);
            buff.append(" ").append(OVER);
            buff.append(this.surroundWithBrackets(buff2.toString()));
            return buff.toString();
        }
        return funcSQL;
    }

    public static class WindowFunctionBound
    extends AbstractSQLFragment {
        public void setBoundExpr(SQLFragment[] boundExpr) {
            this.getChildSupport("boundExpr").setChildArray(boundExpr);
        }

        public SQLFragment[] getBoundExpr() {
            return this.getChildSupport("boundExpr").getChildArray(SQLFragment.class);
        }

        public void setBoundType(BoundType boundType) {
            this.setProperty("boundType", (Object)boundType);
        }

        public BoundType getBoundType() {
            return (BoundType)((Object)this.getProperty("boundType"));
        }

        public String getSQLText() {
            List bound = this.getChildSupport("boundExpr").getChildList(false);
            BoundType boundType = this.getBoundType();
            StringBuilder buff = new StringBuilder();
            if (bound != null && bound.size() > 0) {
                boolean needparen = false;
                for (SQLFragment b : bound) {
                    needparen = !(b instanceof SimpleSQLFragment);
                }
                String bstring = this.argsToString(bound, true, ", ", 0);
                if (needparen) {
                    bstring = this.surroundWithBrackets(bstring);
                }
                buff.append(bstring);
                if (boundType != null) {
                    buff.append(" ").append(boundType.toString());
                }
            } else if (boundType != null) {
                if (boundType == BoundType.CURRENT_ROW) {
                    buff.append(WindowFunction.CURRENT_ROW);
                } else {
                    buff.append(WindowFunction.UNBOUNDED).append(" ");
                    buff.append(boundType.toString());
                }
            }
            String result = buff.toString();
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BoundType {
        PRECEDING,
        FOLLOWING,
        CURRENT_ROW;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClauseType {
        ROWS,
        RANGE;

    }
}

