/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.JoinCondition;

public class UsingJoinCondition
extends AbstractSQLFragment
implements JoinCondition {
    public static final String USING = "USING";

    public UsingJoinCondition() {
    }

    public UsingJoinCondition(FromObjectUsage[] cols) {
        this.setColumns(cols);
    }

    public FromObjectUsage[] getColumns() {
        return this.getChildSupport("columns").getChildArray(FromObjectUsage.class);
    }

    public void setColumns(FromObjectUsage[] cols) {
        this.getChildSupport("columns").setChildArray(cols);
    }

    public void addColumn(FromObjectUsage col) {
        this.getChildSupport("columns").addChild(col);
    }

    public void addColumn(int index, FromObjectUsage col) {
        this.getChildSupport("columns").addChild(index, (Object)col);
    }

    public boolean removeColumn(FromObjectUsage col) {
        return this.getChildSupport("columns").removeChild(col);
    }

    public String getSQLText() {
        StringBuilder buff = new StringBuilder();
        buff.append(USING);
        buff.append(" ");
        String conditionText = this.surroundWithBrackets(this.getConditionText());
        buff.append(conditionText);
        return buff.toString();
    }

    public String getConditionText() {
        StringBuilder buff = new StringBuilder();
        this.getConditionTextImpl(buff);
        return buff.toString();
    }

    private void getConditionTextImpl(StringBuilder buff) {
        List cols = this.getChildSupport("columns").getChildList(false);
        if (cols != null) {
            Iterator iter = cols.iterator();
            while (iter.hasNext()) {
                FromObjectUsage u = (FromObjectUsage)iter.next();
                buff.append(u.getColumnName());
                if (!iter.hasNext()) continue;
                buff.append(",");
            }
        }
    }
}

