/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class SetOperation
extends Operation {
    public static final int BETWEEN = 704;
    public static final int NOT_BETWEEN = 706;
    public static final int IN = 705;
    public static final int EQUALS_ANY = 729;
    public static final int NOT_IN = 707;
    private static Map s_setOps = new HashMap();

    public SetOperation() {
        this(705, null);
    }

    public SetOperation(int operator, SQLFragment[] args) {
        this.setFunctionFormat(false);
        this.setArguments(args);
        this.setOperator(operator);
    }

    public void setOperator(int operator) {
        if (operator == 704 || operator == 706) {
            this.setSeparator(" AND ");
        } else if (operator == 705 || operator == 729 || operator == 707) {
            this.setSeparator(", ");
        } else {
            throw new IllegalArgumentException(DBArb.format(55, "" + operator));
        }
        this.setProperty("operator", operator);
    }

    public int getOperator() {
        return (Integer)this.getProperty("operator", 705);
    }

    protected String getOperatorText() {
        return SetOperation.getSetOperator(this.getOperator());
    }

    public static boolean isSetOperator(int operator) {
        return operator == 704 || operator == 706 || operator == 705 || operator == 729 || operator == 707;
    }

    public static String getSetOperator(int operator) {
        return (String)s_setOps.get(new Integer(operator));
    }

    static {
        s_setOps.put(new Integer(704), "BETWEEN");
        s_setOps.put(new Integer(706), "NOT BETWEEN");
        s_setOps.put(new Integer(705), "IN");
        s_setOps.put(new Integer(729), "=ANY");
        s_setOps.put(new Integer(707), "NOT IN");
    }
}

