/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractFromObjectUsage;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.SelectObject;

public class SelectObjectUsage
extends AbstractFromObjectUsage {
    public SelectObjectUsage() {
    }

    public SelectObjectUsage(SelectObject select, FromObject from) {
        this(select != null ? select.getID() : null, from);
    }

    public SelectObjectUsage(DBObjectID selectID, FromObject from) {
        this(selectID, from != null ? from.getID() : null);
    }

    public SelectObjectUsage(DBObjectID selectID, DBObjectID fromID) {
        super(fromID);
        this.setSelectObjectID(selectID);
    }

    @Transient
    @Deprecated
    public void setSelectObject(SelectObject used) {
        this.setSelectObjectID(used != null ? used.getID() : null);
    }

    @Transient
    @Deprecated
    public SelectObject getSelectObject() {
        return null;
    }

    public void setSelectObjectID(DBObjectID selectID) {
        this.setProperty("selectObjectID", selectID);
    }

    public DBObjectID getSelectObjectID() {
        return (DBObjectID)this.getProperty("selectObjectID");
    }

    private SelectObject resolveSelectObject() {
        SelectObject select = null;
        DBObjectID selectID = this.getSelectObjectID();
        if (selectID != null) {
            try {
                select = (SelectObject)selectID.resolveID();
            }
            catch (DBException e) {
                DBLog.logStackTrace(e);
            }
        }
        return select;
    }

    public String getSQLText() {
        return this.getSQLTextImpl().toString();
    }

    public String getColumnName() {
        int index;
        SelectObject select = this.resolveSelectObject();
        String selectString = select == null ? null : select.getName();
        int n = index = selectString == null ? -1 : selectString.lastIndexOf(".");
        if (index > -1) {
            selectString = selectString.substring(index + 1);
        }
        return selectString;
    }
}

