/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Relation;
import oracle.javatools.db.sql.AbstractSQLQueryBuilder;
import oracle.javatools.db.sql.ColumnUsage;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.ModelUtil;

public class SQLFragmentExpressionBuilder {
    public static SQLFragment getExpression(DBObjectProvider provider, Relation relation, ExpressionType type, String expression) {
        SQLFragment retval = null;
        if (ModelUtil.hasLength((String)expression)) {
            Column c;
            if (type == ExpressionType.ITEM && (c = relation.getColumn(provider.getInternalName(expression))) != null && c.getID() != null) {
                ColumnUsage cu = new ColumnUsage(c.getID());
                cu.setProvider(provider);
                retval = cu;
            }
            if (retval == null) {
                SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder(provider, relation.getSchema());
                if (builder instanceof AbstractSQLQueryBuilder) {
                    ((AbstractSQLQueryBuilder)builder).setSingleRelation(relation);
                    if (type == ExpressionType.CONDITION) {
                        try {
                            builder.buildQuery("SELECT 1 FROM " + relation.getName() + " WHERE " + expression);
                            retval = builder.getSQLQuery().getWhereObject();
                            builder.getSQLQuery().setWhereObject(null);
                        }
                        catch (SQLQueryException e) {
                            retval = null;
                        }
                    } else if (type == ExpressionType.ITEM) {
                        String query = "SELECT " + expression + " FROM " + relation.getName();
                        try {
                            ((AbstractSQLQueryBuilder)builder).buildQuery(query);
                            retval = builder.getSQLQuery().getSelectObjects()[0].getExpression();
                            builder.getSQLQuery().getSelectObjects()[0].setExpression(null);
                        }
                        catch (SQLQueryException e) {
                            retval = null;
                        }
                    }
                }
                if (retval != null) {
                    SQLFragmentExpressionBuilder.resetFromObjectIDs(retval);
                } else {
                    retval = new SimpleSQLFragment(expression);
                }
                retval.setParent(null);
            }
        }
        return retval;
    }

    private static void resetFromObjectIDs(SQLFragment frag) {
        if (frag instanceof ColumnUsage) {
            ((ColumnUsage)frag).setFromObjectID(null);
        }
        for (DBObject kid : frag.getOwnedObjects()) {
            if (!(kid instanceof SQLFragment)) continue;
            SQLFragmentExpressionBuilder.resetFromObjectIDs((SQLFragment)kid);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpressionType {
        ITEM,
        CONDITION;

    }
}

