/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.Arrays;
import java.util.List;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Operation
extends AbstractSQLFragment {
    private String m_separator = ", ";
    private boolean m_funcFormat;
    private boolean m_commutative;

    public Operation() {
    }

    public Operation(SQLFragment[] args) {
        this.setArguments(args);
    }

    protected void setFunctionFormat(boolean boo) {
        this.m_funcFormat = boo;
    }

    protected void setCommutative(boolean boo) {
        this.m_commutative = boo;
    }

    public SQLFragment[] getArguments() {
        return this.getChildSupport("arguments").getChildArray(SQLFragment.class);
    }

    public void setArguments(SQLFragment[] arguments) {
        this.checkNewSize(arguments == null ? 0 : arguments.length);
        this.getChildSupport("arguments").setChildArray(arguments);
    }

    public void addArgument(SQLFragment expression) {
        this.checkNewSize(this.getArgumentCount() + 1);
        this.getChildSupport("arguments").addChild(expression);
    }

    public void addArgument(int index, SQLFragment expression) {
        this.checkNewSize(this.getArgumentCount() + 1);
        this.getChildSupport("arguments").addChild(index, (Object)expression);
    }

    public void addArguments(SQLFragment[] expressions) {
        this.checkNewSize(this.getArgumentCount() + expressions.length);
        for (SQLFragment e : expressions) {
            this.getChildSupport("arguments").addChild(e);
        }
    }

    public boolean removeArgument(SQLFragment expression) {
        this.checkNewSize(this.getArgumentCount() - 1);
        return this.getChildSupport("arguments").removeChild(expression);
    }

    protected void checkNewSize(int proposedSize) {
    }

    public int getArgumentCount() {
        return this.getChildSupport("arguments").getChildCount();
    }

    protected abstract String getOperatorText();

    protected void checkArgument(List<SQLFragment> existing, SQLFragment add) throws IllegalArgumentException {
    }

    protected void setSeparator(String separator) {
        this.m_separator = !ModelUtil.hasLength((String)separator) ? null : separator;
    }

    protected String getSeparator() {
        return this.m_separator;
    }

    protected String getDistinctText() {
        return "";
    }

    @Override
    public String getSQLText() {
        String sep = this.getSeparator();
        List<SQLFragment> args = Arrays.asList(this.getArguments());
        if (this.m_funcFormat) {
            String t = this.getDistinctText() + this.argsToString(args, this.m_commutative, sep, 0);
            t = this.surroundWithBrackets(t, true);
            return this.getOperatorText() + t;
        }
        if (sep == null) {
            return this.argsToString(args, this.m_commutative, " " + this.getOperatorText() + " ", 0);
        }
        StringBuilder retval = new StringBuilder();
        if (args != null && args.size() > 0) {
            boolean def = ModelUtil.areEqual((Object)sep, (Object)", ") && args.size() > 2;
            retval.append(args.iterator().next());
            retval.append(" ").append(this.getOperatorText()).append(" ");
            String argsText = this.argsToString(args, this.m_commutative, sep, 1);
            if (def) {
                argsText = this.surroundWithBrackets(argsText, true);
            }
            retval.append(argsText);
        }
        return retval.toString();
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject other) {
        return super.equalsImpl(other) && ModelUtil.areEqual((Object)((Operation)other).m_separator, (Object)this.m_separator);
    }

    @Override
    protected void copyToImpl(AbstractDBObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        ((Operation)target).m_funcFormat = this.m_funcFormat;
        ((Operation)target).m_commutative = this.m_commutative;
        ((Operation)target).m_separator = this.m_separator;
    }
}

