/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.logging.Level;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.sql.SQLQueryException;

public class InvalidSQLException
extends SQLQueryException {
    private final String m_sql;
    private final Integer m_offset;

    public InvalidSQLException(String sql, String message) {
        this(sql, message, null);
    }

    public InvalidSQLException(String sql, String message, Integer offset) {
        super(message);
        this.m_sql = sql;
        if (offset != null && (this.m_sql == null || offset >= this.m_sql.length())) {
            DBLog.getLogger(this).log(Level.WARNING, "Invalid offset {0} for error {1}", new Object[]{offset, this.m_sql});
            offset = null;
        }
        this.m_offset = offset;
    }

    public String getSQL() {
        return this.m_sql;
    }

    public Integer getOffset() {
        return this.m_offset;
    }

    public Integer getLineNumber() {
        String sql = this.getSQL();
        Integer offset = this.getOffset();
        Integer count = null;
        if (sql != null && offset != null) {
            int i = sql.lastIndexOf("\n", (int)this.getOffset());
            count = 1;
            while (i >= 0) {
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                i = sql.lastIndexOf("\n", i - 1);
            }
        }
        return count;
    }

    public Integer getColumnNumber() {
        String sql = this.getSQL();
        Integer offset = this.getOffset();
        Integer retval = null;
        if (sql != null && offset != null) {
            int i = sql.lastIndexOf("\n", (int)offset);
            retval = i < 0 ? offset : Integer.valueOf(offset - (i + 1));
        }
        return retval;
    }

    public String getSQLWithError() {
        String retval = this.getSQL();
        Integer offset = this.getOffset();
        if (offset != null && retval != null) {
            try {
                int lastNewLine = retval.lastIndexOf("\n", (int)offset);
                int nextNewLine = retval.indexOf("\n", (int)offset);
                StringBuilder buff = new StringBuilder();
                if (nextNewLine < 0) {
                    buff.append(retval);
                } else {
                    buff.append(retval.substring(0, nextNewLine));
                }
                buff.append('\n');
                int pad = lastNewLine < 0 ? offset : offset - (lastNewLine + 1);
                for (int i = 0; i < pad; ++i) {
                    buff.append(' ');
                }
                buff.append("^");
                if (nextNewLine > 0) {
                    buff.append(retval.substring(nextNewLine));
                }
                retval = buff.toString();
            }
            catch (Exception e) {
                DBLog.getLogger(this).log(Level.WARNING, "Error constructing query text with error", e);
            }
        }
        return retval;
    }

    public String getMessage() {
        String msg = super.getMessage();
        Integer line = this.getLineNumber();
        Integer col = this.getColumnNumber();
        if (line != null && col != null) {
            msg = DBArb.format(60, line, col, msg);
        }
        return msg;
    }
}

