/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.SQLFragment;

public class IndexObject
extends AbstractSQLFragment {
    public static final String TYPE = "IndexObject";
    public static final String ASC = "ASC";
    public static final String DESC = "DESC";

    public IndexObject() {
    }

    public IndexObject(SQLFragment exp) {
        this.setExpression(exp);
    }

    public IndexObject(SQLFragment exp, String ordering) {
        this.setExpression(exp);
        this.setOrder(ordering);
    }

    public String getType() {
        return TYPE;
    }

    public String getOrder() {
        return (String)this.getProperty("order");
    }

    public void setOrder(String order) {
        if (order != null && !order.equals(ASC) && !order.equals(DESC)) {
            throw new IllegalArgumentException(DBArb.format(19, order));
        }
        this.setProperty("order", order);
    }

    public SQLFragment getExpression() {
        return (SQLFragment)this.getProperty("expression");
    }

    public void setExpression(SQLFragment exp) {
        this.setProperty("expression", exp);
    }

    public String getSQLText() {
        SQLFragment exp = this.getExpression();
        String order = this.getOrder();
        return this.getTextOrNull(exp) + (order == null ? "" : " " + order);
    }
}

