/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.DBObjectUsage;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractSchemaObjectUsage
extends AbstractSQLFragment
implements DBObjectUsage {
    private transient DBObjectProvider m_pro;

    public AbstractSchemaObjectUsage() {
    }

    public AbstractSchemaObjectUsage(DBObjectID id) {
        this.setObjectID(id);
    }

    public void setProvider(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    public void setObjectID(DBObjectID id) {
        this.setProperty("objectID", id);
    }

    public DBObjectID getObjectID() {
        return (DBObjectID)this.getProperty("objectID");
    }

    public String getSQLText() {
        DBObjectID objectID = this.getObjectID();
        if (objectID != null) {
            String schema = null;
            String name = null;
            if (objectID instanceof NameBasedID) {
                schema = ((NameBasedID)objectID).getSchemaName();
                name = ((NameBasedID)objectID).getName();
            }
            if (!ModelUtil.hasLength(schema) || !ModelUtil.hasLength(name)) {
                try {
                    SchemaObject obj = (SchemaObject)objectID.resolveID();
                    if (obj != null) {
                        Schema s = obj.getSchema();
                        if (s != null) {
                            schema = s.getName();
                        }
                        name = obj.getName();
                    }
                }
                catch (DBException dbe) {
                    DBLog.logStackTrace(dbe);
                }
            }
            StringBuilder buff = new StringBuilder();
            if (this.isInDifferentSchema(schema) && schema != null) {
                buff.append(this.getExternalName(schema)).append(".");
            }
            buff.append(this.getExternalName(name));
            return buff.toString();
        }
        return null;
    }

    private boolean isInDifferentSchema(String schemaName) {
        Schema ourSchema = DBUtil.getSchema(this);
        if (ourSchema != null) {
            return !ourSchema.getName().equals(schemaName);
        }
        return false;
    }

    protected String getExternalName(String name) {
        if (this.m_pro != null) {
            return this.m_pro.getExternalName(name);
        }
        return name;
    }

    protected void copyToImpl(AbstractDBObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        ((AbstractSchemaObjectUsage)target).m_pro = this.m_pro;
    }
}

