/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.List;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.property.After;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.GroupByObject;
import oracle.javatools.db.sql.HierarchicalQueryObject;
import oracle.javatools.db.sql.OrderByObject;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SelectObject;
import oracle.javatools.db.sql.WhereObject;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractSQLQuery
extends AbstractSQLFragment
implements SQLQuery {
    static final String INDENT = "    ";

    protected AbstractSQLQuery() {
        this.setDistinct(false);
    }

    public String getType() {
        return "SQLQuery";
    }

    public String getSQLText() {
        String wholeQuery = this.getQueryString();
        return ModelUtil.hasLength((String)wholeQuery) ? wholeQuery : this.getQueryText();
    }

    private String getQueryText() {
        List obos;
        GroupByObject groupby;
        HierarchicalQueryObject connectBy;
        StringBuilder sql = new StringBuilder();
        this.appendSelectSQL(sql);
        this.appendFromSQL(sql);
        WhereObject where = this.getWhereObject();
        if (where != null) {
            sql.append("WHERE").append(" ").append("\n");
            sql.append(INDENT).append(where.getSQLText());
            sql.append(" ").append("\n");
        }
        if ((connectBy = this.getHierarchicalQueryObject()) != null) {
            sql.append(connectBy.getSQLText());
            sql.append(" ").append("\n");
        }
        if ((groupby = this.getGroupByObject()) != null) {
            sql.append(groupby.getSQLText());
            sql.append(" ").append("\n");
        }
        if ((obos = this.getChildSupport("orderByObjects").getChildList(false)) != null && obos.size() > 0) {
            sql.append("ORDER BY").append(" ").append("\n");
            this.appendToBuffer(sql, obos, INDENT);
            sql.append(" ").append("\n");
        }
        return sql.toString();
    }

    protected void appendSelectSQL(StringBuilder sql) {
        sql.append("SELECT").append(" ");
        String distinct = this.getDistinctSource();
        if (ModelUtil.hasLength((String)distinct)) {
            sql.append(distinct).append(" ");
        }
        sql.append("\n");
        List selects = this.getChildSupport("selectObjects").getChildList(false);
        this.appendToBuffer(sql, selects, INDENT);
        sql.append(" ").append("\n");
    }

    protected void appendFromSQL(StringBuilder sql) {
        sql.append("FROM").append(" ").append("\n");
        List froms = this.getChildSupport("fromObjects").getChildList(false);
        this.appendToBuffer(sql, froms, INDENT);
        sql.append(" ").append("\n");
    }

    @After
    public String getQueryString() {
        return (String)this.getProperty("queryString");
    }

    public void setQueryString(String query) {
        this.setProperty("queryString", query);
    }

    protected void clearQueryString() {
        this.setQueryString(null);
    }

    public SelectObject[] getSelectObjects() {
        return this.getChildSupport("selectObjects").getChildArray(SelectObject.class);
    }

    public void setSelectObjects(SelectObject[] selects) {
        this.clearQueryString();
        this.getChildSupport("selectObjects").setChildArray(selects);
    }

    public void addSelectObject(SelectObject s) {
        this.clearQueryString();
        this.getChildSupport("selectObjects").addChild(s);
    }

    public void addSelectObject(int index, SelectObject s) {
        this.clearQueryString();
        this.getChildSupport("selectObjects").addChild(index, (Object)s);
    }

    public boolean removeSelectObject(SelectObject s) {
        if (this.getChildSupport("selectObjects").removeChild(s)) {
            this.clearQueryString();
            return true;
        }
        return false;
    }

    public void moveSelectObject(SelectObject s, int newIndex) {
        if (this.getChildSupport("selectObjects").moveChild(s, newIndex)) {
            this.clearQueryString();
        }
    }

    public int indexOf(SelectObject s) {
        return this.getChildSupport("selectObjects").indexOfChild(s);
    }

    public FromObject[] getFromObjects() {
        return this.getChildSupport("fromObjects").getChildArray(FromObject.class);
    }

    public void setFromObjects(FromObject[] froms) {
        this.clearQueryString();
        this.getChildSupport("fromObjects").setChildArray(froms);
    }

    public void addFromObject(FromObject f) {
        this.clearQueryString();
        this.getChildSupport("fromObjects").addChild(f);
    }

    public void addFromObject(int index, FromObject f) {
        this.clearQueryString();
        this.getChildSupport("fromObjects").addChild(index, (Object)f);
    }

    public boolean removeFromObject(FromObject f) {
        if (this.getChildSupport("fromObjects").removeChild(f)) {
            this.clearQueryString();
            return true;
        }
        return false;
    }

    public void moveFromObject(FromObject f, int newIndex) {
        if (this.getChildSupport("fromObjects").moveChild(f, newIndex)) {
            this.clearQueryString();
        }
    }

    public int indexOf(FromObject f) {
        return this.getChildSupport("fromObjects").indexOfChild(f);
    }

    public OrderByObject[] getOrderByObjects() {
        return this.getChildSupport("orderByObjects").getChildArray(OrderByObject.class);
    }

    public void setOrderByObjects(OrderByObject[] orderBys) {
        this.clearQueryString();
        this.getChildSupport("orderByObjects").setChildArray(orderBys);
    }

    public void addOrderByObject(OrderByObject o) {
        this.clearQueryString();
        this.getChildSupport("orderByObjects").addChild(o);
    }

    public void addOrderByObject(int index, OrderByObject o) {
        this.clearQueryString();
        this.getChildSupport("orderByObjects").addChild(index, (Object)o);
    }

    public boolean removeOrderByObject(OrderByObject o) {
        if (this.getChildSupport("orderByObjects").removeChild(o)) {
            this.clearQueryString();
            return true;
        }
        return false;
    }

    public void moveOrderByObject(OrderByObject o, int newIndex) {
        if (this.getChildSupport("orderByObjects").moveChild(o, newIndex)) {
            this.clearQueryString();
        }
    }

    public int indexOf(OrderByObject o) {
        return this.getChildSupport("orderByObjects").indexOfChild(o);
    }

    public void setWhereObject(WhereObject where) {
        this.clearQueryString();
        this.setProperty("whereObject", where);
    }

    public WhereObject getWhereObject() {
        return (WhereObject)this.getProperty("whereObject");
    }

    public void setHierarchicalQueryObject(HierarchicalQueryObject connectby) {
        this.clearQueryString();
        this.setProperty("hierarchicalQueryObject", connectby);
    }

    public HierarchicalQueryObject getHierarchicalQueryObject() {
        return (HierarchicalQueryObject)this.getProperty("hierarchicalQueryObject");
    }

    public void setGroupByObject(GroupByObject groupby) {
        this.clearQueryString();
        this.setProperty("groupByObject", groupby);
    }

    public GroupByObject getGroupByObject() {
        return (GroupByObject)this.getProperty("groupByObject");
    }

    public void setDistinct(boolean isDistinct) {
        this.setProperty("distinct", isDistinct);
    }

    public boolean isDistinct() {
        return (Boolean)this.getProperty("distinct", false);
    }

    public void setDistinctSource(String distinctSource) {
        this.setProperty("distinctSource", distinctSource);
    }

    public String getDistinctSource() {
        return (String)this.getProperty("distinctSource");
    }

    public void setID(DBObjectID id) {
        DBObject[] kids;
        super.setID(id);
        for (DBObject kid : kids = this.getOwnedObjects("SQLFragment")) {
            SQLFragment frag = (SQLFragment)kid;
            if (!(frag.getID() instanceof BaseObjectID)) continue;
            ((BaseObjectID)frag.getID()).setParent(id);
        }
    }

    public DBObject findOwnedObject(DBObjectID id) {
        return this.findOwnedObject(id, true);
    }
}

