/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.FromObject;
import oracle.javatools.db.sql.FromObjectUsage;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractFromObjectUsage
extends AbstractSQLFragment
implements FromObjectUsage {
    protected AbstractFromObjectUsage() {
        this.setQualified(true);
    }

    @Deprecated
    protected AbstractFromObjectUsage(FromObject from) {
        this(from != null ? from.getID() : null);
    }

    protected AbstractFromObjectUsage(DBObjectID fromId) {
        this();
        this.setFromObjectID(fromId);
    }

    @Transient
    @Deprecated
    public void setFromObject(FromObject from) {
        this.setFromObjectID(from != null ? from.getID() : null);
    }

    @Transient
    @Deprecated
    public FromObject getFromObject() {
        return this.resolveFromObject();
    }

    public FromObject resolveFromObject() {
        return this.resolveFromObject(this.getFromObjectID());
    }

    protected FromObject resolveFromObject(DBObjectID fromId) {
        SQLQuery query;
        FromObject from = null;
        if (fromId instanceof TemporaryObjectID) {
            try {
                from = (FromObject)fromId.resolveID();
            }
            catch (DBException dbe) {}
        } else if (fromId != null && (query = this.findParent(SQLQuery.class)) != null) {
            from = (FromObject)query.findOwnedObject(fromId);
        }
        return from;
    }

    public void setFromObjectID(DBObjectID id) {
        this.setProperty("fromObjectID", id);
    }

    public DBObjectID getFromObjectID() {
        return (DBObjectID)this.getProperty("fromObjectID");
    }

    public void setQualified(boolean qualified) {
        this.setProperty("qualified", qualified);
    }

    public boolean isQualified() {
        return (Boolean)this.getProperty("qualified", true);
    }

    protected StringBuilder getSQLTextImpl() {
        String rel;
        StringBuilder buff = new StringBuilder();
        FromObject from = this.resolveFromObject();
        if (from != null && this.isQualified() && ModelUtil.hasLength((String)(rel = from.getName())) && rel.indexOf(" ") < 0) {
            buff.append(rel);
            buff.append(".");
        }
        buff.append(this.getColumnName());
        return buff;
    }
}

