/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyHelper {
    private Map<Class, Map<String, PropertyDescriptor>> m_propsCache;

    private Map<Class, Map<String, PropertyDescriptor>> getPropsCache() {
        if (this.m_propsCache == null) {
            this.m_propsCache = new HashMap<Class, Map<String, PropertyDescriptor>>();
        }
        return this.m_propsCache;
    }

    public Object getPropertyValue(Object obj, String propPath) {
        try {
            return this.getPropertyValueOrFail(obj, propPath);
        }
        catch (MissingPropertyException mpe) {
            DBLog.getLogger(this).log(Level.FINE, "No such property {0} on {1}", new Object[]{propPath, obj.getClass().getSimpleName()});
            return null;
        }
    }

    public Object getPropertyValueOrFail(Object obj, String propPath) throws MissingPropertyException {
        return this.getPropertyValueImpl(obj, propPath, null);
    }

    private Object getPropertyValueImpl(Object obj, String propPath, Object context) throws MissingPropertyException {
        if (propPath == null) {
            throw new MissingPropertyException(obj, "");
        }
        MissingPropertyException mpe = null;
        if (obj instanceof DBObjectID) {
            if ("name".equals(propPath)) {
                return DBUtil.getDBObjectName((DBObjectID)obj);
            }
            try {
                Object fromObj;
                DBObject resolved = ((DBObjectID)obj).resolveID();
                if (resolved != null && (fromObj = this.getPropertyValueImpl(resolved, propPath, null)) != null) {
                    return fromObj;
                }
            }
            catch (MissingPropertyException idMpe) {
                mpe = idMpe;
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "Error accessing property " + propPath + ": " + dbe.getMessage());
            }
            if (propPath == "schema") {
                propPath = "schemaName";
            }
        }
        int index = propPath.indexOf("/");
        String restOfPath = null;
        if (index > -1) {
            restOfPath = propPath.substring(index + 1);
            propPath = propPath.substring(0, index);
        }
        boolean found = false;
        Object value = null;
        boolean properties = "properties".equals(propPath);
        if (properties && obj instanceof DBObject && restOfPath != null) {
            return this.getPropertyValueImpl(obj, restOfPath, context);
        }
        if (!found) {
            PropertyDescriptor prop;
            if (obj instanceof Map && ((Map)obj).containsKey(propPath)) {
                value = ((Map)obj).get(propPath);
                found = true;
            } else if (obj instanceof DBObject && !properties) {
                value = ((DBObject)obj).getProperty(propPath);
                boolean bl = found = value != null && !(value instanceof List);
            }
            if (!found && (prop = this.getProperty(obj, propPath)) != null) {
                found = true;
                Method m = prop.getReadMethod();
                try {
                    value = m.invoke(obj, (Object[])null);
                }
                catch (Exception e) {
                    DBLog.getLogger().log(Level.SEVERE, "Error accessing property " + propPath, e);
                    return null;
                }
            }
        }
        if (value != null && restOfPath != null) {
            if (value instanceof Object[]) {
                Object[] valueA = (Object[])value;
                Object[] newValue = new Object[valueA.length];
                for (int i = 0; i < valueA.length; ++i) {
                    newValue[i] = this.getPropertyValueImpl(valueA[i], restOfPath, obj);
                }
                return newValue;
            }
            return this.getPropertyValueImpl(value, restOfPath, obj);
        }
        if (found) {
            return value;
        }
        if (mpe == null) {
            if (this.isValidProperty(obj, propPath, context)) {
                return null;
            }
            mpe = new MissingPropertyException(obj, propPath);
        }
        throw mpe;
    }

    public boolean isValidProperty(Object obj, String propName, Object context) {
        Metadata m = Metadata.getInstance();
        Object query = obj instanceof Map ? context : obj;
        Class<DBObject> clz = null;
        if (query instanceof DBObjectID) {
            clz = m.getObjectClass(((DBObjectID)query).getType());
        } else if (query instanceof DBObject) {
            clz = ((DBObject)query).getClass();
        }
        if (clz == null) {
            return true;
        }
        return m.getSupportedProperties(clz, null).contains(propName);
    }

    public void setPropertyValue(Object bean, String propPath, Object value) {
        try {
            this.setPropertyValueOrFail(bean, propPath, value);
        }
        catch (MissingPropertyException mpe) {
            // empty catch block
        }
    }

    public void setPropertyValueOrFail(Object bean, String propPath, Object value) throws MissingPropertyException {
        int index = propPath.indexOf("/");
        String restOfPath = null;
        if (index > -1) {
            restOfPath = propPath.substring(index + 1);
            propPath = propPath.substring(0, index);
        }
        if (restOfPath != null) {
            Object obj = this.getPropertyValueOrFail(bean, propPath);
            if (obj != null) {
                this.setPropertyValueOrFail(obj, restOfPath, value);
            }
        } else if (bean != null) {
            if (bean instanceof Map) {
                if (value == null) {
                    ((Map)bean).remove(propPath);
                } else {
                    ((Map)bean).put(propPath, value);
                }
            } else {
                if (bean instanceof DBObjectID) {
                    try {
                        bean = ((DBObjectID)bean).resolveID();
                    }
                    catch (DBException dbe) {
                        DBLog.getLogger(this).log(Level.WARNING, "Couldn't resolve id to set property", dbe);
                    }
                }
                if (bean instanceof DBObject && "properties".equals(propPath)) {
                    ((DBObject)bean).setProperty(propPath, value);
                } else {
                    PropertyDescriptor prop = this.getProperty(bean, propPath);
                    if (prop == null || prop.getWriteMethod() == null) {
                        throw new MissingPropertyException(bean, propPath);
                    }
                    Method m = prop.getWriteMethod();
                    try {
                        m.invoke(bean, value);
                    }
                    catch (Exception e) {
                        DBLog.getLogger(this).log(Level.WARNING, "Couldn't set property value for " + propPath);
                    }
                }
            }
        }
    }

    private PropertyDescriptor getProperty(Object bean, String propName) {
        Map<String, PropertyDescriptor> props = this.getProperties(bean.getClass());
        return props == null ? null : props.get(propName);
    }

    private Map<String, PropertyDescriptor> getProperties(Class beanClass) {
        Map<String, PropertyDescriptor> retval = this.getPropsCache().get(beanClass);
        if (retval == null) {
            retval = new HashMap<String, PropertyDescriptor>();
            try {
                BeanInfo bi = Introspector.getBeanInfo(beanClass);
                PropertyDescriptor[] props = bi.getPropertyDescriptors();
                for (int i = 0; i < props.length; ++i) {
                    if (props[i].getReadMethod() == null) continue;
                    retval.put(props[i].getName(), props[i]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getPropsCache().put(beanClass, retval);
        }
        return retval;
    }

    public Difference getChildDifference(Difference diff, String propPath) throws MissingPropertyException {
        String[] propToks = propPath.split("/");
        boolean found = false;
        Difference propRs = diff;
        block0: for (String s : propToks) {
            found = false;
            if (!ModelUtil.hasLength((String)s)) {
                throw new IllegalArgumentException("invalid property path " + propPath);
            }
            for (Difference difference : propRs.getChildren()) {
                if (difference == null || !s.equals(difference.getPropertyName())) continue;
                propRs = difference;
                found = true;
                continue block0;
            }
        }
        if (found) {
            return propRs;
        }
        if (this.isValidProperty(diff.getOriginalObject(), propToks[0], null)) {
            return null;
        }
        throw new MissingPropertyException(diff.getOriginalObject(), propPath);
    }

    public static PropertyInfo findPropertyInfo(String type, String propPath, Class<? extends DBObjectProvider> proClz) {
        Class<? extends DBObject> clz = Metadata.getInstance().getObjectClass(type);
        return clz == null ? null : PropertyHelper.findPropertyInfo(clz, propPath, proClz);
    }

    public static PropertyInfo findPropertyInfo(Class clz, String propPath, Class<? extends DBObjectProvider> proClz) {
        String rest;
        String prop;
        PropertyInfo retval = null;
        if (propPath.contains("/")) {
            int cut = propPath.indexOf("/");
            prop = propPath.substring(0, cut);
            rest = propPath.substring(cut + 1);
        } else {
            prop = propPath;
            rest = null;
        }
        Collection<String> props = Metadata.getInstance().getSupportedProperties(clz, proClz);
        if (props.contains(prop)) {
            PropertyIterator iter = new PropertyIterator(clz, proClz);
            Map<String, PropertyInfo> infos = iter.getPropertyInfos(true, true, false);
            retval = infos.get(prop);
        }
        if (retval != null && ModelUtil.hasLength((String)rest)) {
            Class<?> propClz = retval.getPropertyClass();
            if (Map.class.isAssignableFrom(propClz)) {
                propClz = clz;
            } else if (propClz.isArray()) {
                propClz = propClz.getComponentType();
            }
            retval = PropertyHelper.findPropertyInfo(propClz, rest, proClz);
        }
        return retval;
    }
}

