/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyDefinition
extends PropertyInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Class m_returnType;
    private Collection<Class<? extends DBObject>> m_objTypes;
    private Class<? extends DBObjectProvider> m_providerType;
    private String m_name;
    private boolean m_staticReference;

    public PropertyDefinition() {
    }

    public PropertyDefinition(String name, PropertyKey pk) {
        this(name, pk.value(), false, pk.provider(), pk.childOf());
    }

    public PropertyDefinition(String name, Class returnType, boolean staticReference, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objTypes) {
        this.m_name = name;
        if (!ModelUtil.hasLength((String)this.m_name)) {
            throw new IllegalArgumentException("Every property must have a name.");
        }
        this.m_returnType = returnType;
        this.m_staticReference = staticReference;
        this.m_providerType = providerType;
        if (this.m_providerType == null) {
            this.m_providerType = DBObjectProvider.class;
        }
        this.m_objTypes = new HashSet<Class<? extends DBObject>>();
        if (objTypes != null) {
            for (Class<? extends DBObject> clz : objTypes) {
                if (clz == null) continue;
                this.m_objTypes.add(clz);
            }
        }
        if (this.m_objTypes.size() == 0) {
            this.m_objTypes.add(DBObject.class);
        }
    }

    @Override
    public String getPropertyName() {
        return this.m_name;
    }

    @Override
    public String getPropertyPath() {
        return "properties/" + this.m_name;
    }

    @Override
    public Class getPropertyClass() {
        return this.m_returnType;
    }

    public Collection<Class<? extends DBObject>> getObjectClasses() {
        return this.m_objTypes;
    }

    public Class<? extends DBObjectProvider> getProviderClass() {
        return this.m_providerType;
    }

    public boolean matches(Class<? extends DBObjectProvider> proClz, Class<? extends DBObject> objClz) {
        if ((proClz == null || this.m_providerType.isAssignableFrom(proClz)) && objClz != null) {
            for (Class<? extends DBObject> c : this.m_objTypes) {
                if (!c.isAssignableFrom(objClz)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean equalsImpl(PropertyInfo other) {
        return other instanceof PropertyDefinition ? this.equalsImpl((PropertyDefinition)other) : false;
    }

    protected boolean equalsImpl(PropertyDefinition other) {
        return ModelUtil.areEqual((Object)other.m_name, (Object)this.m_name) && ModelUtil.areEqual((Object)other.m_returnType, (Object)this.m_returnType) && ModelUtil.areEqual(other.m_providerType, this.m_providerType) && ModelUtil.areEqual(other.m_objTypes, this.m_objTypes);
    }

    public String toString() {
        return this.m_name + "(" + this.m_returnType.getName() + ")";
    }

    public int hashCode() {
        return this.m_name == null ? 0 : this.m_name.hashCode();
    }

    @Override
    public Object getPropertyValue(Object bean) {
        return ((DBObject)bean).getProperty(this.m_name);
    }

    @Override
    public void setPropertyValue(Object bean, Object value) throws Exception {
        ((DBObject)bean).setProperty(this.m_name, value);
    }

    @Override
    protected boolean isAfter() {
        return false;
    }

    @Override
    public boolean isGetTransient() {
        return false;
    }

    @Override
    public boolean isSetTransient() {
        return false;
    }

    @Override
    public boolean isStaticReference() {
        return this.m_staticReference;
    }
}

