/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.property.MetadataImpl;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.util.Copyable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metadata {
    private MetadataImpl m_impl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metadata getInstance() {
        DBCore core = DBCore.getInstance();
        boolean doit = false;
        Class<Metadata> clazz = Metadata.class;
        synchronized (Metadata.class) {
            Metadata m = core.get(Metadata.class);
            if (m == null) {
                m = new Metadata();
                core.put(m);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return m;
        }
    }

    private Metadata() {
    }

    synchronized MetadataImpl getMetadata() {
        if (this.m_impl == null) {
            this.m_impl = new MetadataImpl();
        }
        return this.m_impl;
    }

    public Map<String, Class<? extends DBObject>> getDBObjectClasses() {
        return Collections.unmodifiableMap(this.getMetadata().getTypeMap());
    }

    public boolean isSchemaObject(String type) {
        return this.isTypeOf(SchemaObject.class, type);
    }

    public boolean isTypeOf(Class<? extends DBObject> clz, String type) {
        Class<? extends DBObject> typeClz;
        boolean retval = false;
        if (type != null && (typeClz = this.getMetadata().getTypeMap().get(type)) != null) {
            retval = clz.isAssignableFrom(typeClz);
        }
        return retval;
    }

    public DBObject newDBObject(String type, String name) {
        Class<? extends DBObject> clz = this.getObjectClass(type);
        if (clz != null) {
            try {
                DBObject obj = clz.newInstance();
                obj.setName(name);
                return obj;
            }
            catch (Exception e) {
                DBLog.getLogger(this).log(Level.FINE, "Couldn't create new " + type, e);
            }
        }
        return null;
    }

    public Class<? extends DBObject> getObjectClass(String type) {
        return type == null ? null : this.getMetadata().getTypeMap().get(type);
    }

    public synchronized void registerObjectClass(String type, Class<? extends DBObject> clz) {
        Class<? extends DBObject> exists = this.getObjectClass(type);
        if (exists == null) {
            this.getMetadata().registerClass(clz);
        } else if (exists != clz) {
            throw new IllegalArgumentException(MessageFormat.format("Cannot register class {0}: type {1} is registered as class {2}", clz.getName(), type, exists.getName()));
        }
    }

    public Collection<String> getAllTypes(Class<? extends DBObject> clz) {
        Collection<Class<? extends DBObject>> impls;
        HashSet<String> types = new HashSet<String>();
        String clzType = Metadata.getType(clz);
        if (clzType != null) {
            types.add(clzType);
        }
        if ((impls = this.getMetadata().getImpementations(clz)) != null) {
            for (Class<? extends DBObject> implclz : impls) {
                String type = Metadata.getType(implclz);
                if (type == null) continue;
                types.add(type);
            }
        }
        return types;
    }

    public DBObject newInstance(String type) {
        Class<? extends DBObject> clz = this.getObjectClass(type);
        if (clz != null) {
            try {
                return clz.newInstance();
            }
            catch (Exception e) {
                DBLog.getLogger().log(Level.FINE, "Error instantiating new DBObject", e);
            }
        }
        return null;
    }

    public Collection<String> getSupportedProperties(Class<? extends DBObject> objClz, Class<? extends DBObjectProvider> proClz) {
        return this.getSupportedProperties(objClz, proClz, true, true);
    }

    public Collection<String> getSupportedProperties(Class<? extends DBObject> objClz, Class<? extends DBObjectProvider> proClz, boolean incBean, boolean incExtra) {
        Collection<String> globalProps;
        HashSet<String> retval = new HashSet<String>();
        if (incBean && (globalProps = this.getMetadata().getProperties(objClz)) != null) {
            retval.addAll(globalProps);
        }
        if (incExtra) {
            for (Map.Entry<String, PropertyDefinition> entry : this.getMetadata().getExtraProps().entrySet()) {
                PropertyDefinition propDef = entry.getValue();
                if (!propDef.matches(proClz, objClz)) continue;
                retval.add(entry.getKey());
            }
        }
        return retval;
    }

    public void registerProperty(String name, Class returnType, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        this.registerPropertyImpl(name, returnType, true, providerType, objectTypes);
    }

    public void registerIDProperty(String name, boolean staticReference, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        this.registerPropertyImpl(name, DBObjectID.class, staticReference, providerType, objectTypes);
    }

    private void registerPropertyImpl(String name, Class returnType, boolean staticReference, Class<? extends DBObjectProvider> providerType, Class<? extends DBObject> ... objectTypes) {
        PropertyDefinition prop = new PropertyDefinition(name, returnType, staticReference, providerType, objectTypes);
        Map<String, PropertyDefinition> extraProps = this.getMetadata().getExtraProps();
        if (extraProps.containsKey(name)) {
            throw new IllegalStateException("Property " + name + " has already been defined.");
        }
        extraProps.put(name, prop);
    }

    public boolean isStaticReferenceProperty(String propName) {
        Map<String, PropertyDefinition> extraProps = this.getMetadata().getExtraProps();
        PropertyDefinition pd = extraProps.get(propName);
        if (pd != null) {
            return pd.isStaticReference();
        }
        return false;
    }

    public boolean isBeanProperty(Class<? extends DBObject> clz, String propName) {
        Collection<String> props = this.getMetadata().getProperties(clz);
        return props != null && props.contains(propName);
    }

    public static boolean isRealBean(Class<? extends Copyable> clz) {
        int m;
        return clz != null && Modifier.isPublic(m = clz.getModifiers()) && !Modifier.isAbstract(m) && !clz.isInterface();
    }

    public static String getType(Class<? extends DBObject> objClass) {
        String retval = null;
        if (objClass != null) {
            try {
                Field f = objClass.getField("TYPE");
                if (f != null) {
                    retval = (String)f.get(null);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retval;
    }
}

