/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DeclarativePlSql;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.plsql.PlSqlDeclarator;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlSubprg;
import oracle.javatools.util.ModelUtil;

class PlSqlSubprogramDeclarator
extends PlSqlDeclarator {
    public PlSqlSubprogramDeclarator(DBObjectProvider pr) {
        super(pr);
    }

    public void loadDeclarativeInfo(SourceObject obj) {
        if (!(obj instanceof DeclarativePlSql)) {
            throw new IllegalArgumentException("Attempt made to get declarative information for an invalid object");
        }
        super.loadDeclarativeInfo(obj);
        this.loadPlSql();
    }

    private void loadPlSql() {
        this._loadProperties();
        this._loadParameters();
        this._loadReturnType();
        this._loadBody();
    }

    private PlsqlSubprg _getSubprg() {
        return this.getRoot().getUnits().length == 1 && this.getRoot().getUnits()[0] instanceof PlsqlSubprg ? (PlsqlSubprg)this.getRoot().getUnits()[0] : null;
    }

    private void _loadProperties() {
        PlSqlInterrogator pi = ((PlSql)this.getSourceObject()).getSourceInterrogator();
        String name = pi.getName();
        if (this.m_prv != null) {
            name = this.m_prv.getInternalName(name);
        }
        ((PlSql)this.getSourceObject()).setName(name);
    }

    private void _loadParameters() {
        PlSqlInterrogator pi = ((PlSql)this.getSourceObject()).getSourceInterrogator();
        PlSqlFragment rootFrag = pi.getRoot();
        if (rootFrag != null && rootFrag.getChildren() != null) {
            PlSqlFragment frag = rootFrag.getChildren()[0];
            this.getPlSql().setParameters(this.getPlsqlParams(frag, this.m_prv, this.getSourceObject()));
        }
    }

    private void _loadReturnType() {
        String retType;
        PlsqlSubprg prg = this._getSubprg();
        if (prg != null && ModelUtil.hasLength((String)(retType = PlSqlSubprogramDeclarator.getReturnType((PlsqlNode)prg)))) {
            DataType dt = this.m_prv.getOrCreateDataType(retType.toUpperCase());
            this.getPlSql().setReturnTypeID(DataTypeHelper.findOrCreateIDForTypeString(this.m_prv, this.getSourceObject().getSchema(), retType));
        }
    }

    public DeclarativePlSql getPlSql() {
        return (DeclarativePlSql)((Object)this.getSourceObject());
    }

    private void _loadBody() {
        PlsqlSubprg prg = this._getSubprg();
    }
}

