/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.plsql.ObjectTypeDeclarator;
import oracle.javatools.db.plsql.PackageDeclarator;
import oracle.javatools.db.plsql.PlSqlDeclarator;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlSubprogramDeclarator;
import oracle.javatools.db.plsql.TriggerDeclarator;
import oracle.javatools.util.ModelUtil;

public class PlSqlDeclaratorFactory {
    private PlSqlDeclaratorFactory() {
    }

    public static void loadDeclarativeInfo(PlSql plsql, DBObjectProvider prov) {
        PlSqlDeclarator d = PlSqlDeclaratorFactory.getDeclarator(plsql, prov);
        if (d != null) {
            d.loadDeclarativeInfo(plsql);
        }
    }

    public static PlSqlDeclarator getDeclarator(PlSql plsql, DBObjectProvider prov) {
        return PlSqlDeclaratorFactory.getDeclarator(plsql.getType(), prov);
    }

    public static PlSqlDeclarator getDeclarator(String type, DBObjectProvider prov) {
        if ("PACKAGE".equals(type)) {
            return new PackageDeclarator(prov);
        }
        if ("TYPE".equals(type)) {
            return new ObjectTypeDeclarator(prov);
        }
        if ("TRIGGER".equals(type)) {
            return new TriggerDeclarator(prov);
        }
        if ("FUNCTION".equals(type) || "PROCEDURE".equals(type)) {
            return new PlSqlSubprogramDeclarator(prov);
        }
        return null;
    }

    @Deprecated
    public static void setAndClearSchema(PlSql obj, DBObjectProvider prov) {
        if (obj != null) {
            SpecPlSql body;
            PlSqlInterrogator bodyPi;
            String bodySchemaName;
            PlSqlInterrogator pi = obj.getSourceInterrogator();
            String name = pi.getName();
            String schemaName = pi.getSchemaName();
            if (ModelUtil.hasLength((String)schemaName)) {
                Schema schema = null;
                if (prov != null) {
                    schemaName = prov.getInternalName(schemaName);
                    try {
                        schema = prov.getSchema(schemaName);
                    }
                    catch (DBException e) {
                        // empty catch block
                    }
                }
                if (schema == null) {
                    schema = new Schema(schemaName);
                }
                obj.setSource(pi.getRenamedSource(name, true));
                obj.setSchema(schema);
            }
            if (obj instanceof SpecPlSql && ModelUtil.hasLength((String)(bodySchemaName = (bodyPi = (body = (SpecPlSql)obj).getBodySourceInterrogator()).getSchemaName()))) {
                body.setBodySource(bodyPi.getRenamedSource(name, true));
            }
            if (obj instanceof Trigger) {
                TriggerDeclarator.updateSourceFromRefs((Trigger)obj, prov);
            }
        }
    }
}

