/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.ArrayList;
import java.util.logging.Level;
import oracle.javatools.buffer.ReadTextBuffer;
import oracle.javatools.buffer.TextBufferFactory;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PlSqlAttribute;
import oracle.javatools.db.PlSqlMethod;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSearchException;
import oracle.javatools.parser.plsql.PlsqlParser;
import oracle.javatools.parser.plsql.data.PlsqlAdt;
import oracle.javatools.parser.plsql.data.PlsqlHasName;
import oracle.javatools.parser.plsql.data.PlsqlName;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlPkg;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.parser.plsql.data.PlsqlSubprg;
import oracle.javatools.parser.plsql.data.PlsqlType;
import oracle.javatools.parser.plsql.data.PlsqlVariable;
import oracle.javatools.util.ModelUtil;

public abstract class PlSqlDeclarator {
    private SourceObject m_src;
    protected PlsqlRoot m_root;
    protected DBObjectProvider m_prv;
    public static final int NAME = 5;
    public static final int ATTRIBUTES = 21;
    public static final int METHODS = 20;

    public PlSqlDeclarator() {
    }

    public PlSqlDeclarator(DBObjectProvider prv) {
        this.m_prv = prv;
    }

    public void checkRoot() {
        if (this.m_root == null) {
            String srcText = this.m_src.getSource() == null ? "" : this.m_src.getSource();
            ReadTextBuffer textBuffer = TextBufferFactory.createReadTextBuffer((String)srcText);
            PlsqlParser.ParsingOptions options = new PlsqlParser.ParsingOptions();
            options.inputType = 0;
            this.m_root = PlsqlParser.parsePlsql((ReadTextBuffer)textBuffer);
        }
    }

    public void loadDeclarativeInfo(SourceObject obj) {
        this.m_src = obj;
    }

    protected void checkState() {
        this.checkRoot();
        if (this.m_root == null && !(this.m_root instanceof PlsqlRoot)) {
            throw new IllegalStateException("PlSqlDeclarator class not properly initialized.");
        }
    }

    protected SourceObject getSourceObject() {
        return this.m_src;
    }

    protected PlsqlRoot getRoot() {
        this.checkRoot();
        return this.m_root;
    }

    public PlsqlNode getKid(int type, String name) {
        PlsqlNode[] kids = this._getKids(type, name);
        return kids != null && kids.length == 1 ? kids[0] : null;
    }

    public PlsqlNode[] getKids(int type) {
        return this._getKids(type, null);
    }

    private PlsqlNode[] _getKids(int type, String name) {
        PlsqlAdt parent;
        this.checkState();
        ArrayList<PlsqlNode> interested = new ArrayList<PlsqlNode>();
        PlsqlNode[] kids = null;
        if (this.getRoot().getUnits().length == 1 && this.getRoot().getUnits()[0] instanceof PlsqlAdt) {
            parent = (PlsqlAdt)this.getRoot().getUnits()[0];
            kids = parent.getComponents();
        } else if (this.getRoot().getUnits().length == 1 && this.getRoot().getUnits()[0] instanceof PlsqlPkg) {
            parent = (PlsqlPkg)this.getRoot().getUnits()[0];
            kids = parent.getDeclarations();
        }
        if (kids != null) {
            for (int index = 0; kids != null && index < kids.length; ++index) {
                if (kids[index].getTreeKind() != type || name != null && !name.equals(this.getName(kids[index]))) continue;
                interested.add(kids[index]);
            }
        }
        return interested.toArray(new PlsqlNode[interested.size()]);
    }

    public String getName(PlsqlNode node) {
        PlsqlName plsqlName;
        if (node instanceof PlsqlHasName && (plsqlName = ((PlsqlHasName)node).getName()) != null) {
            String name = plsqlName.toString();
            return this.m_prv == null ? name : this.m_prv.getInternalName(name);
        }
        return null;
    }

    public static String getType(PlsqlNode node) {
        PlsqlType type;
        if (node instanceof PlsqlVariable && (type = ((PlsqlVariable)node).getVariableType()) != null && type.getTypeName() != null) {
            return type.getTypeName().toString();
        }
        return null;
    }

    public static String getReturnType(PlsqlNode node) {
        PlsqlType type;
        if (node instanceof PlsqlSubprg && (type = ((PlsqlSubprg)node).getReturnType()) != null && type.getTypeName() != null) {
            return type.getTypeName().toString();
        }
        return null;
    }

    protected void _loadAttributes() {
        ArrayList<PlSqlAttribute> attribList = new ArrayList<PlSqlAttribute>();
        PlsqlNode[] atts = this.getKids(this.getAttributesType());
        for (int i = 0; atts != null && i < atts.length; ++i) {
            String name = this.getName(atts[i]);
            String type = PlSqlDeclarator.getType(atts[i]);
            DataType dt = this.m_prv.getOrCreateDataType(type);
            PlSqlAttribute attr = new PlSqlAttribute(name, dt);
            DBObjectID parId = this.m_src.getID();
            if (parId instanceof BaseObjectID) {
                attr.setID(new NameBasedID("TypeAttribute", name, parId));
            }
            attribList.add(attr);
        }
        PlSqlAttribute[] attribArray = attribList.toArray(new PlSqlAttribute[attribList.size()]);
        ((SpecPlSql)this.m_src).setAttributes(attribArray);
    }

    protected void _loadMethods() {
        ArrayList<PlSqlMethod> methodList = new ArrayList<PlSqlMethod>();
        PlsqlNode[] methods = this.getKids(this.getMethodsType());
        for (int i = 0; methods != null && i < methods.length; ++i) {
            DataType dt;
            String name = this.getName(methods[i]);
            PlSqlMethod method = new PlSqlMethod(name);
            DBObjectID parId = this.m_src.getID();
            if (parId instanceof BaseObjectID) {
                method.setID(new NameBasedID("TypeMethod", name, parId));
            }
            methodList.add(method);
            String retType = PlSqlDeclarator.getReturnType(methods[i]);
            if (ModelUtil.hasLength((String)retType) && (dt = this.m_prv.getOrCreateDataType(retType)) != null) {
                method.setReturnTypeID(dt.getID());
            }
            ArrayList<PlSqlParameter> varList = new ArrayList<PlSqlParameter>();
            if (!(methods[i] instanceof PlsqlSubprg)) continue;
            PlsqlVariable[] vars = ((PlsqlSubprg)methods[i]).getFormalParameters();
            for (int j = 0; vars != null && j < vars.length; ++j) {
                String varName = this.getName((PlsqlNode)vars[j]);
                String type = PlSqlDeclarator.getType((PlsqlNode)vars[j]);
                DataType dt2 = this.m_prv.getOrCreateDataType(type);
                PlSqlParameter param = new PlSqlParameter(varName, dt2);
                if (parId instanceof BaseObjectID) {
                    param.setID(new NameBasedID("PlSqlParameter", varName, parId));
                }
                varList.add(param);
            }
            method.setParameters(varList.toArray(new PlSqlParameter[varList.size()]));
        }
        PlSqlMethod[] methodArray = methodList.toArray(new PlSqlMethod[methodList.size()]);
        ((SpecPlSql)this.m_src).setMethods(methodArray);
    }

    protected int getMethodsType() {
        return 20;
    }

    protected int getAttributesType() {
        return 21;
    }

    public PlSqlParameter[] getPlsqlParams(PlSqlFragment fragment, DBObjectProvider provider, DBObject parent) {
        ArrayList<PlSqlParameter> retval = new ArrayList<PlSqlParameter>();
        if (fragment.getFramentType() == PlSqlFragment.Type.PROCEDURE || fragment.getFramentType() == PlSqlFragment.Type.PROCEDURE_FD || fragment.getFramentType() == PlSqlFragment.Type.FUNCTION || fragment.getFramentType() == PlSqlFragment.Type.FUNCTION_FD) {
            PlSqlFragment paramList = null;
            for (PlSqlFragment frag : fragment.getChildren()) {
                if (frag.getFramentType() != PlSqlFragment.Type.PARAMETER_LIST) continue;
                paramList = frag;
                break;
            }
            if (paramList != null) {
                for (PlSqlFragment frag : paramList.getChildren()) {
                    if (frag.getFramentType() != PlSqlFragment.Type.PARAMETER) continue;
                    PlSqlParameter param = new PlSqlParameter();
                    param.setParent(parent);
                    PlSqlSearch paramExpr = null;
                    try {
                        paramExpr = new PlSqlSearch("<name ?> <mode [{IN OUT|IN|OUT}]> <nocopy [NOCOPY]> <datatype ?%> [DEFAULT <default {?}...>]");
                    }
                    catch (PlSqlSearchException e) {
                        DBLog.getLogger(this).log(Level.SEVERE, "Invalid plsqlsearch expression", e);
                    }
                    if (!paramExpr.matches(frag.getSource())) continue;
                    retval.add(param);
                    String name = paramExpr.getNamedMatch("name");
                    DBObjectID parId = parent.getID();
                    if (parId instanceof BaseObjectID) {
                        param.setID(new NameBasedID("PlSqlParameter", name, parId));
                    }
                    param.setName(name);
                    String mode = paramExpr.getNamedMatch("mode");
                    if ("IN OUT".equals(mode)) {
                        param.setMode(PlSqlParameter.Mode.INOUT);
                    } else if ("OUT".equals(mode)) {
                        param.setMode(PlSqlParameter.Mode.OUT);
                    } else {
                        param.setMode(PlSqlParameter.Mode.IN);
                    }
                    if ("NOCOPY".equals(paramExpr.getNamedMatch("NOCOPY"))) {
                        param.setNoCopy(true);
                    }
                    Schema s = null;
                    if (parent instanceof SchemaObject) {
                        s = ((SchemaObject)parent).getSchema();
                    }
                    String datatype = paramExpr.getNamedMatch("datatype");
                    DBObjectID typeID = DataTypeHelper.findOrCreateIDForTypeString(provider, s, datatype);
                    param.setDataTypeID(typeID);
                    String defaultStr = paramExpr.getNamedMatch("default");
                    param.setDefaultValue(defaultStr);
                }
            }
        }
        return retval.toArray(new PlSqlParameter[retval.size()]);
    }
}

