/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.PlSqlAttribute;
import oracle.javatools.db.PlSqlMethod;
import oracle.javatools.db.PlSqlParameter;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.plsql.PlSqlDeclarator;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSearchException;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;

class ObjectTypeDeclarator
extends PlSqlDeclarator {
    private ComplexType m_type;
    private PlSqlSearch m_collTypeSearch;
    private PlSqlSearch m_objTypeSearch;
    private PlSqlSearch m_attributeSearch;
    private PlSqlSearch m_methodSearch;
    private PlSqlSearch m_paramSearch;
    private PlSqlSearch m_dependantHandlingSearch;
    private PlSqlSearch m_alterCollectionSearch;
    private PlSqlSearch m_alterFinalInstantiableSearch;
    private static Map<String, PropertyInfo> s_derivedPropInfos = null;

    public ObjectTypeDeclarator(DBObjectProvider pr) {
        super(pr);
    }

    public void loadDeclarativeInfo(SourceObject obj) {
        if (obj instanceof ComplexType) {
            this.m_type = (ComplexType)obj;
            if (!this.m_type.isMadeDeclarative()) {
                this.m_type.setMadeDeclarative(true);
                super.loadDeclarativeInfo(obj);
                this.clearDerivedProperties();
                PlSqlInterrogator pi = this.m_type.getSourceInterrogator();
                PlSqlFragment root = pi.getRoot();
                this.m_type.setName(this.m_prv.getInternalName(pi.getName()));
                if (!pi.isWrapped() && root != null) {
                    if (pi.isEvolvedType()) {
                        root = root.getChildren()[0];
                    }
                    this.m_type.setTypeCode(pi.getTypeCode());
                    this.m_type.setCollectionType(pi.getCollectionType());
                    if ("OBJECT".equals(pi.getTypeCode())) {
                        this.deriveObjectProperties(root);
                    } else {
                        this.deriveCollectionProperties(root);
                    }
                    if (pi.isEvolvedType()) {
                        for (int i = 1; i < pi.getRoot().getChildren().length; ++i) {
                            PlSqlFragment alterFrag = pi.getRoot().getChildren()[i];
                            this.processAlterFragment(alterFrag);
                        }
                    }
                }
            }
        }
    }

    private void clearDerivedProperties() {
        if (s_derivedPropInfos == null) {
            PropertyIterator iter = new PropertyIterator(ComplexType.class, OracleDatabase.class);
            s_derivedPropInfos = iter.getPropertyInfos();
            s_derivedPropInfos.remove("ID");
            s_derivedPropInfos.remove("source");
            s_derivedPropInfos.remove("bodySource");
            s_derivedPropInfos.remove("schema");
            s_derivedPropInfos.remove("properties");
        }
        for (PropertyInfo info : s_derivedPropInfos.values()) {
            try {
                info.setPropertyValue(this.m_type, null);
            }
            catch (Exception exception) {}
        }
    }

    private void deriveObjectProperties(PlSqlFragment root) {
        boolean isFinal = true;
        boolean isInstantiable = true;
        if (this.getObjTypeSearch().matches(root.getFirstToken())) {
            this.m_type.setOID(this.getObjTypeSearch().getNamedMatch("oid"));
            boolean authidCurrentUser = "CURRENT_USER".equalsIgnoreCase(this.getObjTypeSearch().getNamedMatch("authid"));
            this.m_type.setAuthidCurrentUser(authidCurrentUser);
            if (this.getObjTypeSearch().getNamedMatch("under") != null) {
                this.m_type.setUnderTypeID(this.getDTID(this.getObjTypeSearch().getNamedMatch("under")));
            }
            this.m_type.setSqljExternalName(this.getNameSearchStripQuotes(this.getObjTypeSearch(), "extname"));
            if (this.m_type.getSqljExternalName() != null) {
                ComplexType.SQLJUsingType sqljUsing = null;
                String using = this.getObjTypeSearch().getNamedMatch("using");
                if ("SQLData".equalsIgnoreCase(using)) {
                    sqljUsing = ComplexType.SQLJUsingType.SQLData;
                } else if ("OraData".equalsIgnoreCase(using)) {
                    sqljUsing = ComplexType.SQLJUsingType.OraData;
                }
                if ("CustomDatum".equalsIgnoreCase(using)) {
                    sqljUsing = ComplexType.SQLJUsingType.CustomDatum;
                }
                this.m_type.setSqljUsing(sqljUsing);
            }
            PlSqlToken tk = root.getLastToken();
            while (!tk.isCode() || tk.matches(";") || tk.matches("/")) {
                tk = tk.getPrevCodeToken();
            }
            if (tk.matches("INSTANTIABLE") && (tk = tk.getPrevCodeToken()).matches("NOT")) {
                isInstantiable = false;
                tk = tk.getPrevCodeToken();
            }
            if (tk.matches("FINAL") && (tk = tk.getPrevCodeToken()).matches("NOT")) {
                isFinal = false;
            }
            this.m_type.setFinal(isFinal);
            this.m_type.setInstantiable(isInstantiable);
            PlSqlFragment typeSpecFrag = root.findChild(PlSqlFragment.Type.TYPE_SPEC, true);
            if (typeSpecFrag != null) {
                for (PlSqlFragment f : typeSpecFrag.getChildren()) {
                    if (f.getFramentType().equals((Object)PlSqlFragment.Type.DECLARATION)) {
                        this.processAttributeFragment(f);
                        continue;
                    }
                    if (!f.getFramentType().equals((Object)PlSqlFragment.Type.PROCEDURE_FD) && !f.getFramentType().equals((Object)PlSqlFragment.Type.FUNCTION_FD)) continue;
                    this.processMethodFragment(f);
                }
            }
        } else {
            this.m_type.addDeclaratorError("Source did not match deriveObjectProperties pattern");
        }
    }

    private void deriveCollectionProperties(PlSqlFragment root) {
        if (this.getCollTypeSearch().matches(root.getFirstToken())) {
            this.m_type.setOID(this.getCollTypeSearch().getNamedMatch("oid"));
            this.m_type.setLimit(this.getIntegerNamedMatch(this.getCollTypeSearch(), "limit"));
            this.m_type.setOfTypeUsage(this.getDTU(this.getCollTypeSearch().getNamedMatch("datatype")));
        } else {
            this.m_type.addDeclaratorError("Source did not match deriveCollectionProperties pattern");
        }
    }

    private void processAlterFragment(PlSqlFragment alterFrag) {
        if (alterFrag.getChildren() != null && alterFrag.getChildren().length > 0 && alterFrag.getAlterSubType() == null) {
            for (PlSqlFragment childFrag : alterFrag.getChildren()) {
                this.processAlterFragment(childFrag);
            }
        } else {
            PlSqlToken tk = alterFrag.getFirstToken();
            PlSqlToken endToken = alterFrag.getLastToken();
            if (this.getDependantHandlingSearch().isWithin(tk, endToken)) {
                endToken = this.getDependantHandlingSearch().getStartToken().getPrevCodeToken();
            }
            if (alterFrag.getAlterSubType() != null) {
                PlSqlFragment.AlterSubType action = alterFrag.getAlterSubType();
                switch (action) {
                    case ADD_ATTRIBUTE: 
                    case MODIFY_ATTRIBUTE: 
                    case DROP_ATTRIBUTE: {
                        this.processAlterAttributeFragment(action, tk, endToken);
                        break;
                    }
                    case ADD_METHOD: {
                        this.processMethodFragment(alterFrag);
                        break;
                    }
                    case DROP_METHOD: {
                        this.processDropMethodFragment(alterFrag);
                    }
                }
            } else if (this.getAlterCollectionSearch().matches(tk, endToken)) {
                String datatype = this.getAlterCollectionSearch().getNamedMatch("datatype");
                if (datatype != null) {
                    this.m_type.setOfTypeUsage(this.getDTU(datatype));
                } else {
                    this.m_type.setLimit(this.getIntegerNamedMatch(this.getAlterCollectionSearch(), "limit"));
                }
            } else if (this.getAlterFinalInstantiableSearch().matches(tk, endToken)) {
                if (this.getAlterFinalInstantiableSearch().getNamedMatch("notInst") != null) {
                    this.m_type.setInstantiable(false);
                } else if (this.getAlterFinalInstantiableSearch().getNamedMatch("inst") != null) {
                    this.m_type.setInstantiable(true);
                }
                if (this.getAlterFinalInstantiableSearch().getNamedMatch("notFinal") != null) {
                    this.m_type.setFinal(false);
                } else if (this.getAlterFinalInstantiableSearch().getNamedMatch("final") != null) {
                    this.m_type.setFinal(true);
                }
            } else {
                this.m_type.addDeclaratorError("Source did not match any of the processAlterFragment patterns");
            }
        }
    }

    private void processAttributeFragment(PlSqlFragment attrFrag) {
        PlSqlAttribute attr = null;
        if (!attrFrag.getFirstToken().matches("PRAGMA")) {
            attr = this.getAttribute(attrFrag.getFirstToken(), null);
            if (attr != null) {
                this.m_type.addAttribute(attr);
            } else {
                this.m_type.addDeclaratorError("Fragment (" + attrFrag.getSource() + ") did not match processAttributeFragment pattern");
            }
        }
    }

    private PlSqlAttribute getAttribute(PlSqlToken startToken, PlSqlToken endToken) {
        PlSqlAttribute attr = null;
        if (this.getAttributeSearch().matches(startToken, endToken)) {
            String name = this.m_prv.getInternalName(this.getAttributeSearch().getNamedMatch("name"));
            DataTypeUsage dtu = this.getDTU(this.getAttributeSearch().getNamedMatch("datatype"));
            attr = new PlSqlAttribute(name, dtu);
            attr.setSqljExternalName(this.getNameSearchStripQuotes(this.getAttributeSearch(), "extname"));
        }
        return attr;
    }

    private void processMethodFragment(PlSqlFragment methodFrag) {
        PlSqlMethod method = this.getMethod(methodFrag);
        if (method != null) {
            this.m_type.addMethod(method);
        }
    }

    private PlSqlMethod getMethod(PlSqlFragment methodFrag) {
        PlSqlMethod method = null;
        if (this.getMethodSearch().matches(methodFrag.getFirstToken())) {
            method = new PlSqlMethod();
            method.setFinal(this.getMethodSearch().getNamedMatch("final") != null);
            method.setOverriding(this.getMethodSearch().getNamedMatch("over") != null);
            method.setInstantiable(this.getMethodSearch().getNamedMatch("notInst") == null);
            String methodTypeStr = this.getMethodSearch().getNamedMatch("methodType");
            methodTypeStr = methodTypeStr.replace(" ", "_");
            try {
                method.setMethodType(PlSqlMethod.MethodType.valueOf(methodTypeStr));
            }
            catch (Exception e) {
                method.setMethodType(PlSqlMethod.MethodType.MEMBER);
            }
            String methodName = this.getMethodSearch().getNamedMatch("methodName");
            methodName = this.m_prv.getInternalName(methodName);
            method.setName(methodName);
            String datatype = this.getMethodSearch().getNamedMatch("datatype");
            if (datatype != null) {
                method.setReturnTypeID(this.getDTID(datatype));
            }
            String javaName = this.getNameSearchStripQuotes(this.getMethodSearch(), "javaname");
            String cLibName = this.getNameSearchStripQuotes(this.getMethodSearch(), "clibname");
            if (javaName != null) {
                method.setCallSpecLanguage(PlSqlMethod.CallSpecLanguage.JAVA);
                method.setCallSpecName(javaName);
            } else if (cLibName != null) {
                method.setCallSpecLanguage(PlSqlMethod.CallSpecLanguage.C);
                method.setCallSpecName(this.getNameSearchStripQuotes(this.getMethodSearch(), "cname"));
                method.setCallSpecLibName(cLibName);
                method.setCallSpecWithContext(this.getMethodSearch().getNamedMatch("ccontext") != null);
            }
            String extname = this.getNameSearchStripQuotes(this.getMethodSearch(), "extname");
            String extvarname = this.getNameSearchStripQuotes(this.getMethodSearch(), "extvarname");
            if (extname != null) {
                method.setSqljSigName(extname);
            } else if (extvarname != null) {
                method.setSqljSigVarName(extvarname);
            }
            ArrayList<PlSqlParameter> params = new ArrayList<PlSqlParameter>();
            PlSqlFragment paramListFrag = methodFrag.findChild(PlSqlFragment.Type.PARAMETER_LIST, false);
            if (paramListFrag != null) {
                for (PlSqlFragment paramFrag : paramListFrag.getChildren()) {
                    PlSqlParameter param = new PlSqlParameter();
                    PlSqlParameter.Mode mode = PlSqlParameter.Mode.IN;
                    if (this.getParamSearch().matches(paramFrag.getFirstToken())) {
                        String name = this.m_prv.getInternalName(this.getParamSearch().getNamedMatch("param"));
                        String modeStr = this.getParamSearch().getNamedMatch("mode");
                        if (modeStr != null) {
                            if (modeStr.equals("OUT")) {
                                mode = PlSqlParameter.Mode.OUT;
                            } else if (modeStr.equals("IN OUT")) {
                                mode = PlSqlParameter.Mode.INOUT;
                            }
                        }
                        param.setName(name);
                        param.setMode(mode);
                        param.setDefaultValue(this.getParamSearch().getNamedMatch("default"));
                        param.setNoCopy(this.getParamSearch().getNamedMatch("nocopy") != null);
                        param.setDataTypeID(this.getDTID(this.getParamSearch().getNamedMatch("datatype")));
                        params.add(param);
                        continue;
                    }
                    this.m_type.addDeclaratorError("Fragment (" + paramFrag.getSource() + ") did not match processMethodFragment.parameters pattern");
                }
                method.setParameters(params.toArray(new PlSqlParameter[params.size()]));
            }
        } else {
            this.m_type.addDeclaratorError("Fragment did not match processMethodFragment pattern");
        }
        return method;
    }

    private void processAlterAttributeFragment(PlSqlFragment.AlterSubType action, PlSqlToken startTk, PlSqlToken endToken) {
        PlSqlToken startToken = startTk;
        boolean last = true;
        if (startToken.matches("(")) {
            last = false;
            startToken = startToken.getNextCodeToken();
        }
        do {
            if (action == PlSqlFragment.AlterSubType.DROP_ATTRIBUTE) {
                PlSqlAttribute oldAttr = this.m_type.getAttribute(startToken.getSource(true));
                if (oldAttr != null) {
                    this.m_type.removeAttribute(oldAttr);
                }
            } else {
                PlSqlAttribute attr = this.getAttribute(startToken, endToken);
                if (attr != null) {
                    if (action == PlSqlFragment.AlterSubType.ADD_ATTRIBUTE) {
                        this.m_type.addAttribute(attr);
                    } else {
                        PlSqlAttribute oldAttr = this.m_type.getAttribute(attr.getName());
                        attr.copyTo(oldAttr);
                    }
                }
            }
            if (last) continue;
            if (action != PlSqlFragment.AlterSubType.DROP_ATTRIBUTE) {
                startToken = this.getAttributeSearch().getEndToken();
            }
            if ((startToken = startToken.getNextCodeToken()).matches(",")) {
                startToken = startToken.getNextCodeToken();
                continue;
            }
            last = true;
        } while (!last);
    }

    private void processDropMethodFragment(PlSqlFragment methodFrag) {
        PlSqlMethod method = this.getMethod(methodFrag);
        if (method != null) {
            String sig = method.getSignature();
            PlSqlMethod delMethod = null;
            for (PlSqlMethod m : this.m_type.getMethods()) {
                if (!sig.equals(m.getSignature())) continue;
                delMethod = m;
                break;
            }
            if (delMethod != null) {
                this.m_type.removeMethod(delMethod);
            }
        }
    }

    private Integer getIntegerNamedMatch(PlSqlSearch search, String name) {
        Integer retval = null;
        String strVal = search.getNamedMatch(name);
        if (strVal != null) {
            try {
                retval = Integer.valueOf(strVal);
            }
            catch (NumberFormatException e) {
                retval = null;
            }
        }
        return retval;
    }

    private DBObjectID getDTID(String usageString) {
        DBObjectID retval = this.getSelfReference(usageString);
        if (retval == null) {
            retval = DataTypeHelper.findOrCreateIDForTypeString(this.m_prv, this.m_type.getSchema(), usageString);
            this.checkDataType(retval);
        }
        return retval;
    }

    private DataTypeUsage getDTU(String usageString) {
        DataTypeUsage retval = null;
        DBObjectID id = this.getSelfReference(usageString);
        if (id != null) {
            retval = new ObjectTypeUsage();
            retval.setDataTypeID(id);
        } else {
            retval = DataTypeHelper.getDataTypeUsageForString(this.m_prv, this.m_type.getSchema(), usageString);
            this.checkDataType(retval.getDataTypeID());
        }
        return retval;
    }

    private DBObjectID getSelfReference(String usageString) {
        DBObjectID retval = null;
        if (this.m_type.getID() != null) {
            StringBuffer sb = new StringBuffer("{<ref [REF]> ");
            if (this.m_type.getSchema() != null) {
                sb.append("[").append(this.m_type.getSchema().getName()).append(" .]");
            }
            sb.append(this.m_type.getName()).append("|SELF AS RESULT} \\");
            try {
                PlSqlSearch s = new PlSqlSearch(sb.toString());
                if (s.matches(usageString + " \\")) {
                    retval = this.m_type.getID();
                    if (s.getNamedMatch("ref") != null) {
                        retval = new ReferenceID("REF", retval, null, null, null);
                    }
                }
            }
            catch (PlSqlSearchException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return retval;
    }

    private void checkDataType(DBObjectID id) {
        DBObjectID idToCheck = id;
        if (id instanceof ReferenceID && "REF".equals(id.getType())) {
            idToCheck = id.getParent();
        }
        if (idToCheck instanceof ReferenceID) {
            // empty if block
        }
    }

    private String getNameSearchStripQuotes(PlSqlSearch search, String name) {
        String retval = search.getNamedMatch(name);
        if (retval != null && (retval.startsWith("'") && retval.endsWith("'") || retval.startsWith("\"") && retval.endsWith("\""))) {
            retval = retval.substring(1, retval.length() - 1);
        }
        return retval;
    }

    private final PlSqlSearch getCollTypeSearch() {
        if (this.m_collTypeSearch == null) {
            try {
                this.m_collTypeSearch = new PlSqlSearch("TYPE ?. [FORCE] [OID <oid ?>] {IS|AS} { {VARRAY | VARYING ARRAY} ( <limit ?> ) |   TABLE } OF <datatype ?%> [NOT NULL]");
            }
            catch (PlSqlSearchException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_collTypeSearch;
    }

    private final PlSqlSearch getObjTypeSearch() {
        if (this.m_objTypeSearch == null) {
            try {
                this.m_objTypeSearch = new PlSqlSearch("TYPE ?. [FORCE] [OID <oid ?>] [AUTHID <authid ?>] {{IS|AS}OBJECT|UNDER <under ?.>|{IS|AS}OPAQUE VARYING (*) USING LIBRARY ?} [EXTERNAL NAME <extname ?> LANGUAGE JAVA USING <using ?>]");
            }
            catch (PlSqlSearchException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_objTypeSearch;
    }

    private final PlSqlSearch getAttributeSearch() {
        if (this.m_attributeSearch == null) {
            try {
                this.m_attributeSearch = new PlSqlSearch("<name ?> <datatype ?%> [EXTERNAL NAME <extname ?>]");
            }
            catch (PlSqlSearchException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_attributeSearch;
    }

    private final PlSqlSearch getMethodSearch() {
        if (this.m_methodSearch == null) {
            try {
                this.m_methodSearch = new PlSqlSearch("[ { NOT FINAL | <final FINAL> |     NOT OVERRIDING | <over OVERRIDING> |     <notInst  NOT INSTANTIABLE> | INSTANTIABLE }...] <methodType {MEMBER|STATIC|CONSTRUCTOR|MAP MEMBER|ORDER MEMBER}> {FUNCTION|PROCEDURE} <methodName ?> [({^)}...)] [RETURN <datatype {SELF AS RESULT|?%}>  [EXTERNAL {NAME <extname ?> | VARIABLE NAME <extvarname ?> } ]] [{DETERMINISTIC|PIPELINED|RESULT_CACHE}...][ {IS|AS} LANGUAGE     { JAVA NAME <javaname ?>     | C [NAME <cname ?>] LIBRARY <clibname ?.>       [AGENT IN ({^)}...) ]       [WITH <ccontext CONTEXT>]       [PARAMETERS ({^)}...) ]     } ]");
            }
            catch (PlSqlSearchException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_methodSearch;
    }

    private final PlSqlSearch getParamSearch() {
        if (this.m_paramSearch == null) {
            try {
                this.m_paramSearch = new PlSqlSearch("<param ?> [<mode {IN OUT|OUT|IN}>] [<nocopy NOCOPY>] <datatype ?%> [{DEFAULT|:=} <default ?>]");
            }
            catch (PlSqlSearchException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_paramSearch;
    }

    private final PlSqlSearch getDependantHandlingSearch() {
        if (this.m_dependantHandlingSearch == null) {
            try {
                this.m_dependantHandlingSearch = new PlSqlSearch("{INVALIDATE|CASCADE}");
            }
            catch (PlSqlSearchException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_dependantHandlingSearch;
    }

    private final PlSqlSearch getAlterCollectionSearch() {
        if (this.m_alterCollectionSearch == null) {
            try {
                this.m_alterCollectionSearch = new PlSqlSearch("ALTER TYPE ?. MODIFY {LIMIT <limit ?>|ELEMENT TYPE <datatype ?%>}");
            }
            catch (PlSqlSearchException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_alterCollectionSearch;
    }

    private final PlSqlSearch getAlterFinalInstantiableSearch() {
        if (this.m_alterFinalInstantiableSearch == null) {
            try {
                this.m_alterFinalInstantiableSearch = new PlSqlSearch("ALTER TYPE ?.  { <notInst NOT INSTANTIABLE>|   <inst INSTANTIABLE>|   <notFinal NOT FINAL>|   <final FINAL>}...");
            }
            catch (PlSqlSearchException e) {
                DBLog.getLogger().log(Level.SEVERE, "failed to contruct PlSqlSearch: " + e.getMessage());
            }
        }
        return this.m_alterFinalInstantiableSearch;
    }
}

